// ----------------------------------------------------------------------------
// Base class for dialogs
//

#ifndef UIDIALOG_HEADER_INCLUDED
#define UIDIALOG_HEADER_INCLUDED

#include "winsystem.h"		// use Widget, CB_Data

class Session;
class Stringy;
class Table;
class WinSys;

// ----------------------------------------------------------------------------
//
class Dialog
{
 public:
  Dialog(Session &, const Stringy &name);
  Dialog(Widget, Session &);
  virtual ~Dialog();

  bool shown();
  virtual void apply();

  static void ok_cb(Widget, CB_Data, CB_Data);
  static void apply_cb(Widget, CB_Data, CB_Data);
  static void close_cb(Widget, CB_Data, CB_Data);
  static void help_cb(Widget, CB_Data, CB_Data);

 protected:
  Session &session;
  WinSys &ws;
  Widget dialog;

 private:
  bool destroy_widget;

  static void window_destroyed_cb(Widget, CB_Data, CB_Data);
};

// ----------------------------------------------------------------------------
//
class Dialog_Table
{
public:
  Dialog_Table();
  ~Dialog_Table();

  void *get_dialog(const Stringy &name);
  void set_dialog(const Stringy &name, void *dialog);
  void delete_dialog(const Stringy &name, void *dialog);

  void *get_data(const Stringy &name);
  void set_data(const Stringy &name, void *data);

  List *dialog_list(const Stringy &name);
  void append_to_dialog_list(const Stringy &name, void *dialog);
  void delete_from_dialog_list(const Stringy &name, void *dialog);

private:
  Table *dtable;
};

#endif
