// ----------------------------------------------------------------------------
//
#include "list.h"		// use List
#include "session.h"		// use Session
#include "stringc.h"		// use Stringy
#include "table.h"		// use Table
#include "uidialog.h"			// use Dialog, Dialog_Table
#include "uidialogs.h"		// use show_help()

// ----------------------------------------------------------------------------
//
Dialog::Dialog(Session &s, const Stringy &name)
  : session(s), ws(s.window_system())
{
  this->dialog = ws.create_dialog(name);
  this->destroy_widget = true;
  ws.add_event_callback(destroy_event, dialog, window_destroyed_cb, this);
}

// ----------------------------------------------------------------------------
//
Dialog::Dialog(Widget w, Session &s)  : session(s), ws(s.window_system())
{
  this->dialog = w;
  this->destroy_widget = false;
}

// ----------------------------------------------------------------------------
//
Dialog::~Dialog()
{
  ws.remove_event_callback(destroy_event, dialog, window_destroyed_cb, this);

  if (destroy_widget)
    ws.delete_widget(dialog);
}

// ----------------------------------------------------------------------------
//
void Dialog::window_destroyed_cb(Widget, CB_Data d, CB_Data)
{
  delete (Dialog *) d;
}

// ----------------------------------------------------------------------------
//
void Dialog::ok_cb(Widget, CB_Data dialog, CB_Data)
{
  Dialog *d = (Dialog *) dialog;
  d->apply();
  d->ws.unshow_dialog(d->dialog);
}

// ----------------------------------------------------------------------------
//
void Dialog::apply_cb(Widget, CB_Data dialog, CB_Data)
{
  Dialog *d = (Dialog *) dialog;
  d->apply();
}

// ----------------------------------------------------------------------------
//
void Dialog::close_cb(Widget, CB_Data dialog, CB_Data)
{
  Dialog *d = (Dialog *) dialog;
  d->ws.unshow_dialog(d->dialog);
}

// ----------------------------------------------------------------------------
//
bool Dialog::shown()
{
  return ws.is_viewable(dialog);
}

// ----------------------------------------------------------------------------
//
void Dialog::apply()
{
}

// ----------------------------------------------------------------------------
// Used as help button callback.  URL is retrieved from option database.
//
void Dialog::help_cb(Widget help_button, CB_Data session, CB_Data)
{
  Session *s = (Session *) session;
  WinSys &ws = s->window_system();
  Stringy url = ws.read_application_resource(help_button, "url", "Url", "");
  show_manual_url(*s, url);
}

// ----------------------------------------------------------------------------
//
Dialog_Table::Dialog_Table()
{
  dtable = new Table(equal_strings, hash_string);
}

// ----------------------------------------------------------------------------
//
Dialog_Table::~Dialog_Table()
{
  List names = dtable->keys();
  free_string_list_entries(names);
  delete dtable;
  dtable = NULL;
}

// ----------------------------------------------------------------------------
// Retrieve a dialog pointer by name.  Returns NULL if no dialog with the
// given name is known.
//
void *Dialog_Table::get_dialog(const Stringy &name)
  { return get_data(name); }

// ----------------------------------------------------------------------------
// Add or overwrite the dialog pointer associated with a name.
//
void Dialog_Table::set_dialog(const Stringy &name, void *dialog)
  { set_data(name, dialog); }

// ----------------------------------------------------------------------------
//
void *Dialog_Table::get_data(const Stringy &name)
{
  TableData d;
  if (dtable->find((TableKey) &name, &d))
    return d;
  return NULL;
}

// ----------------------------------------------------------------------------
//
void Dialog_Table::set_data(const Stringy &name, void *data)
{
  Stringy *key = new Stringy(name);
  Stringy *oldkey = (Stringy *) dtable->remove(key);
  if (oldkey)
    delete oldkey;
  dtable->insert((TableKey) key, (TableData) data);
}

// ----------------------------------------------------------------------------
// The named dialog is in the table delete the entry.  This is used when
// a dialog is deleted.
//
void Dialog_Table::delete_dialog(const Stringy &name, void *dialog)
{
  TableData d;
  if (dtable->find((TableKey) &name, &d) && d == dialog)
    {
      Stringy *key = (Stringy *) dtable->remove((TableKey) &name);
      delete key;
    }
}

// ----------------------------------------------------------------------------
//
List *Dialog_Table::dialog_list(const Stringy &name)
{
  TableData d;
  if (dtable->find((TableKey) &name, &d))
    return (List *) d;
  return NULL;
}

// ----------------------------------------------------------------------------
//
void Dialog_Table::append_to_dialog_list(const Stringy &name, void *dialog)
{
  if (dialog_list(name) == NULL)
    dtable->insert((TableKey) new Stringy(name), (TableData) new List());
  dialog_list(name)->append(dialog);  
}

// ----------------------------------------------------------------------------
// The dialog list table entry is removed if it becomes empty.
//
void Dialog_Table::delete_from_dialog_list(const Stringy &name, void *dialog)
{
  List *dlist = dialog_list(name);
  if (dlist)
    {
      dlist->erase(dialog);
      if (dlist->empty())
	{
	  Stringy *key = (Stringy *) dtable->remove((TableKey) &name);
	  delete key;
	  delete dlist;
	}
    }
}
