// ----------------------------------------------------------------------------
// UCSF NMR data file format
//

#ifndef UCSFFILE_HEADER_INCLUDED
#define UCSFFILE_HEADER_INCLUDED

#include <stdio.h>		// Use FILE

class Memory_Cache;
class NMR_Data;
class Stringy;

bool is_ucsf_nmr_data(const Stringy &path);
NMR_Data *ucsf_nmr_data(const Stringy &path, Memory_Cache *);
bool write_ucsf_nmr_data(NMR_Data *nmr_data, const Stringy &path,
			 Stringy *err_msg, Memory_Cache *);
bool print_ucsf_nmr_header(const Stringy &path, FILE *outfp);
bool change_ucsf_axis_label(const Stringy &path, int axis,
			    const Stringy &label);
bool change_ucsf_origin(const Stringy &path, int axis, float origin_ppm);
bool change_ucsf_spectral_width(const Stringy &path, int axis, float sw_hz);
bool change_ucsf_spectrometer_frequency(const Stringy &path, int axis,
					float freq_mhz);

#endif
