// ----------------------------------------------------------------------------
// This stuff belongs with the NMR_Data class in nmrdata.h
//
#ifndef _SpectrumData_h
#define _SpectrumData_h

#include "spoint.h"		// use SPoint

enum Units {INDEX, HZ, PPM, NOUNITS};
extern const char *Unit_Names[];

class List;
class NMR_Data;
class Stringy;

class SpectrumData {

public:
		SpectrumData(NMR_Data *nmr_data);
  virtual	~SpectrumData();

  int		dimension() const;
  IRegion	index_range() const;
  SRegion	ppm_region() const;	// Caution: max - min != spectral width
  float		height_at_point(const SPoint &p) const;
  float		height_at_index(const IPoint &index) const;
  bool		heights_for_region(const IRegion &index_region,
				   float *data) const;
  bool		have_noise_level() const;
  double	noise_level();
  void		set_noise_level(double noise);
  Stringy	data_path() const;

  SPoint	ppm_spectrum_width() const;
  SPoint	ppm_sweep_width() const;
  void		set_ppm_sweep_width(const SPoint &sweepwidth);
  SRegion	alias_region() const;

  SPoint	ppm_shift() const;
  void		set_ppm_shift(const SPoint &ppmshift);

  Stringy	nucleus_type(int axis) const;
  const List &	nucleus_types() const;
  bool		is_nucleus_unique(const Stringy &nucleus, int *axis);
  bool		is_homonuclear(int axis1, int axis2) const;
  double	nucleus_ppm_factor(int axis) const;

  double	scale(double x, int a, Units from, Units to) const;
  SPoint	scale(const SPoint &p, Units from, Units to) const;
  SRegion	scale(const SRegion &region, Units from, Units to) const;
  double	map(double x, int a, Units from, Units to) const;
  SPoint	map(const SPoint &p, Units from, Units to) const;
  SRegion	map(const SRegion &region, Units from, Units to) const;

private:
  int			mDimension;
  NMR_Data		*mNMRData;	// nmr data
  double		mNoise;		// computed data height noise
  bool			mHaveNoise;
  SPoint		nucleus_factor;	// H = 1, C = 4, N = 10
  SPoint		axis_shift;	// ppm
  SPoint		sweep_width;	// ppm
};

SPoint local_maximum(SpectrumData *sp, const SPoint &p, double *h);
SPoint half_height_width(SpectrumData *sp, const SPoint &p);
SPoint symmetric_half_height_width(SpectrumData *sp, const SPoint &p);
SPoint alias_onto_spectrum(const SPoint &freq, SpectrumData *sp);
double sample_spectrum_noise(SpectrumData *sp, int sample_count);

#endif
