// ----------------------------------------------------------------------------
// A Session object encapsulates the state of a Sparky session.
// Static variables in the code are only used for constant data,
// like tables that need run time initialization, or for working
// around interface limitations, like setting a static variable that
// is used by a comparison function called by the C stdlib qsort().
// When Sparky is run as a Python extension it should be possible to run
// two Sparky sessions in the same interpretter without them interfering
// with each other.  That's not particularly useful.  The main intent
// is to avoid the use of global state which can make the code harder
// to understand.  There are probably violations of these conventions
// lurking in dark corners of the code.  I've tried to label all static
// variable declarations with a comment "state variable".
//
#ifndef SESSION_HEADER_INCLUDED
#define SESSION_HEADER_INCLUDED

class Command_Dispatcher;
class Dialog_Table;
class Notifier;
class Project;
class Reporter;
class WinSys;

class Session
{
public:
  Session(int *argc, char *argv[]);	// w/o Python
  Session(void *tcl_interp);		// with Python
  virtual ~Session();

  Notifier &		notifier();
  Project &		project();
  Dialog_Table &	dialog_table();
  WinSys &		window_system();
  Command_Dispatcher &	command_dispatcher();
  Reporter &		reporter();

  bool ok_to_end_session();
  void end_session();

private:
  bool			delete_on_exit;
  bool			delete_queued;
  Notifier *		nt;
  Project *		proj;
  Dialog_Table *	dt;
  WinSys *		ws;
  Command_Dispatcher *	cd;
  Reporter *		rep;

  void init_systems();
};

void request_coredump(Session &);

#endif
