// ----------------------------------------------------------------------------
//
#ifndef PRINT_HEADER_INCLUDED
#define PRINT_HEADER_INCLUDED

#include "stringc.h"			// use Stringy

class Color;
class Rectangle;
class View;
class Wait;

// ----------------------------------------------------------------------------
//
class Print_Options
{
public:
  Print_Options();

  bool		preview;
  bool		print_to_file;
  Stringy	print_file;		// name of file (if print to file)
  Stringy	temp_file;		// used for preview or printer print
  Stringy	print_command;

  bool		landscape;
  bool		black_labels;

  bool		show_banner;
  Stringy	title;			// title (if banner chosen)

  bool		show_grids;
  bool		show_peakgroups;
  bool		show_peaks;
  bool		show_contours;

  bool		fixed_scale;
  double	fixed_scales[2];	// ppm/cm (if fixed scale)
  int		pages[2];		// number of pages (if not fixed scale)
  double	label_spacing[2];	// ppm
};

// ----------------------------------------------------------------------------
//
int	color_index(const Color &c);
bool	print_previewer_exists	();
bool	print_view		(View *vp, Rectangle r,
				 const Print_Options &po, Wait *wait);

#endif
