#ifndef PEAKPICK_HEADER_INCLUDED
#define PEAKPICK_HEADER_INCLUDED

#include "spoint.h"		// use SPoint, SRegion

class List;
class Spectrum;
class Wait;

class Peak_Pick_Parameters
{
public:
  Peak_Pick_Parameters(int dimension);
  Peak_Pick_Parameters(const Peak_Pick_Parameters &);

  double minPosHt;		// minimum positive height
  double minNegHt;		// negative minimum height
  SPoint minimum_linewidth;	// half height linewidth
  double minimum_drop_factor;
};

List	peak_pick_region(Spectrum *sp, const SRegion &region,
			 const Peak_Pick_Parameters &params, Wait *wait);

#endif
