// ----------------------------------------------------------------------------
// Form paths for finding Sparky session and peak list files.
//
#include <stdlib.h>		// use getenv()

#include "paths.h"
#include "stringc.h"		// use Stringy
#include "system.h"		// Use file_path()

// ----------------------------------------------------------------------------
//
Stringy installation_path(const Stringy &subdir)
{
  char *sparky_install = getenv("SPARKY_INSTALL");
  if (sparky_install == NULL)
    return file_path(default_sparky_install_path(), subdir);

  return file_path(sparky_install, subdir);
}

// ----------------------------------------------------------------------------
//
Stringy sparky_directory(const Stringy &subdir)
{
  Stringy home = home_directory();

  if (!is_directory(home))
    {
      Stringy sample_data = installation_path(SPARKY_SAMPLE_DATA);
      if (is_directory(sample_data))
	home = sample_data;
    }

  return (home.is_empty() ? Stringy("") : file_path(home, subdir));
}

// ----------------------------------------------------------------------------
// This is the base path when a dialog for opening or saving a file
// is presented to the user.  This directory normally contains Save,
// Projects, and List subdirectories.
//
Stringy home_directory()
{
  Stringy home = getenv("SPARKYHOME");
  if (home.is_empty())
    {
      Stringy path = file_path("~", SPARKY_HOME);
      home = tilde_expand(path);
      if (home == path)
	home = "";	// Failed to expand ~.
    }

  return home;
}
