// ----------------------------------------------------------------------------
// Maintain mapping between C objects and id numbers.
//
// This is used by undo eg. to restore a deleted label's connection to
// an existing peak.  And it is used by Python.  Python calls use id
// numbers to reference Sparky C objects.
//

#ifndef OBJECTID_HEADER_INCLUDED
#define OBJECTID_HEADER_INCLUDED

#include "table.h"		// use Table

class List;
class Stringy;

// ----------------------------------------------------------------------------
//
class Object_Table
{
public:
  Object_Table();
  int id(void *pointer, const Stringy &type);
  void *object(int id, Stringy *type);
  void set_id(void *pointer, const Stringy &type, int id);
  List delete_ids(void *pointer);

private:
  int next_object_id;
  Table id_to_object_table;
  Table object_to_id_table;
};

#endif
