// ----------------------------------------------------------------------------
// A model is a set of xyz coordinates for atoms of a molecule.
//

#ifndef MODEL_HEADER_INCLUDED
#define MODEL_HEADER_INCLUDED

#include "stringc.h"		// use Stringy
#include "table.h"		// use Table

class Atom;
class List;
class SPoint;

// ----------------------------------------------------------------------------
//
class Model
{
public:
  Model(const Stringy &path, const List &atom_entries);
  virtual ~Model();

  Stringy file_path() const;
  bool coordinates(const Atom &, SPoint *) const;

private:
  Stringy path;
  Table atom_table;
};

Model *read_pdb_model(const Stringy &pdb_path);

#endif
