// ----------------------------------------------------------------------------
// Extendable arrays of void * pointers
//

#ifndef LIST_HEADER_INCLUDED
#define LIST_HEADER_INCLUDED

class ListOrder;

class List
{
 public:

  List();
  List(const List &);
  List &operator=(const List &);
  virtual ~List();

  bool empty() const;
  int size() const;
  void *operator[](int k) const;
  void *pop();

  void append(void *);
  void append(const List &);
  void insert(void *, int);
  void swap(int, int);
  void move(int from, int to);
  bool erase(void *);
  void erase(int pos);
  void erase(int beg, int end);		// Includes beg but not end
  void erase(const List &);
  void erase();
  void replace(void *, void *);

  bool contains(const void *) const;
  bool contains(const void *, ListOrder) const;
  bool find(const void *, int *position) const;
  int find(const void *) const;
  List sublist(int beg, int end);	// Includes beg but not end
  void reverse();
  void sort(const ListOrder &);
  void sort_removing_duplicates(const ListOrder &);

 private:

  void **pointers;
  int used;
  int allocated;
};

class ListOrder
{
 public:
  ListOrder(int (*compare)(const void *a, const void *b));
  ListOrder();		// For derived classes that overload operator()
  virtual ~ListOrder() {};
  virtual int operator()(const void *a, const void *b) const;
 private:
  int (*compare)(const void *a, const void *b);
};
int compare_ints(int, int);
int compare_doubles(double, double);
int compare_pointers(const void *, const void *);

#endif
