// ----------------------------------------------------------------------------
//
#include <stdlib.h>		// Use atoi()
#include <ctype.h>		// Use isdigit()

#include "group.h"
#include "stringc.h"

static void parse_group_name(const Stringy &name, Stringy *symbol,
			     int *num, Stringy *suffix);

// ----------------------------------------------------------------------------
//
Group::Group(const Stringy &nm)
{
  mName = nm;
  parse_group_name(nm, &mSymbol, &mNum, &mSuffix);
}

// ----------------------------------------------------------------------------
//
Group::~Group()
{
}

// ----------------------------------------------------------------------------
//
const Stringy &Group::name() const
  { return mName; }
const Stringy &Group::symbol() const
  { return mSymbol; }
int Group::number() const
  { return mNum; }
const Stringy &Group::suffix() const
  { return mSuffix; }

// ----------------------------------------------------------------------------
//
static void parse_group_name(const Stringy &name, Stringy *symbol,
			     int *num, Stringy *suffix)
{
  int length = name.length();
  int d = 0;
  while (d < length && !isdigit(name[d]))
    d += 1;
  int s = d;
  while (s < length && isdigit(name[s]))
    s += 1;

  *symbol = name.substring(0,d);
  *num = atoi(name.substring(d,s).cstring());
  *suffix = name.substring(s);
}
