// ----------------------------------------------------------------------------
// Table of key, value pairs attached to objects by extensions.
// For example the integration dialog can attach default integration
// parameters to spectra to be saved between sessions.
//
// Keys and values are strings.  To make it easy to save in files
// keys must contain no spaces and values must contain no newlines.
// If these conditions are violated save_value() returns false and
// the (key, value) is not saved.
//

#include "attacheddata.h"
#include "list.h"		// use List
#include "memalloc.h"		// use new()
#include "stringc.h"		// use Stringy
#include "table.h"		// use Table

// ----------------------------------------------------------------------------
//
AttachedData::AttachedData() : key_value(equal_strings, hash_string) {}

// ----------------------------------------------------------------------------
//
AttachedData::~AttachedData()
{
  List keys = key_value.keys();
  for (int ki = 0 ; ki < keys.size() ; ++ki)
    remove_entry(*(Stringy *) keys[ki]);
}

// ----------------------------------------------------------------------------
//
bool AttachedData::save_value(const Stringy &key, const Stringy &value)
{
  if (contains_whitespace(key) || find_character(value, "\n", NULL))
    return false;

  remove_entry(key);
  key_value.insert((TableKey) new Stringy(key),
		   (TableData) new Stringy(value));
  return true;
}

// ----------------------------------------------------------------------------
//
bool AttachedData::saved_value(const Stringy &key, Stringy *value) const
{
  TableData v;
  if (key_value.find((TableKey) &key, &v))
    {
      *value = *(Stringy *) v;
      return true;
    }
  return false;
}

// ----------------------------------------------------------------------------
//
List AttachedData::keys() const
{
  return key_value.keys();
}

// ----------------------------------------------------------------------------
//
void AttachedData::remove_entry(const Stringy &key)
{
  TableKey k = (TableKey) &key;
  TableData v_string;
  if (key_value.find(k, &v_string))
    {
      TableKey k_string = key_value.remove(k);
      delete (Stringy *) k_string;
      delete (Stringy *) v_string;
    }
}
