/*
 * Interface to the Atom class 
 *
 * A Molecule is composed of Atoms. Atoms with magnetic dipoles resonate at
 * frequencies determined by chemical bonds, molecular geometry, and
 * the NMR and physical conditions of a given NMR experiment. The
 * resonant frequency is encoded in the Resonance object, contained in
 * the Condition object, which encodes the NMR and physical conditions.
 *
 * Each Atom has a unique identifier (its ID) and a name given to it by the
 * user. Each Atom may also belong to a Group, which is usually an amino acid
 * or DNA base.
 *
 */
#ifndef ATOM_HEADER_INCLUDED
#define ATOM_HEADER_INCLUDED

class Atom;

#include "stringc.h"		// Use Stringy

class Group;

class Atom
{
public:
  Atom(const Stringy &name, const Stringy &nucleus, Group *g);
  virtual		~Atom();

  const Stringy &	name() const;		// Just atom part
  Stringy		LongName() const;	// Group and atom names
  const Stringy	&	nucleus() const;
  Group			*group() const;

private:
  Stringy	mName;
  Stringy	mNucleus;
  Group		*mGroup;
};

#endif
