///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: RCPtr.h 68 2004-11-04 15:43:03Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _RCPtr_h
#define _RCPtr_h

#include "RefCountMixin.h"

//
// Older versions of g++ shipped with incomplete auto_ptr implementations.
// This class provides the same basic functionality as auto_ptr.
//
template<class T>
class RCPtr
{
public:
  RCPtr(T *p = 0)
    : m_ptr(p)
  {
    link();
  }

  ~RCPtr()
  {
    unlink();
  }

  T *operator->() const
  {
    assert(m_ptr);
    return m_ptr;
  }

  T &operator*() const
  {
    assert(m_ptr);
    return *m_ptr;
  }

  T *get() const
  {
    return m_ptr;
  }

  void set(T *p = 0)
  {
    unlink();
    m_ptr = p;
    link();
  }

  void clear()
  {
    unlink();
    m_ptr = 0;
  }

  T *release()
  {
    drop();
    T *ptr = m_ptr;
    m_ptr = 0;
    return ptr;
  }

  bool isNull()
  {
      return m_ptr == 0;
  }

  bool isNotNull()
  {
      return m_ptr != 0;
  }

private:
  void link()
  {
    if (m_ptr) {
      m_ptr->rcAddReference();
    }
  }

  void unlink()
  {
    if (m_ptr) {
      m_ptr->rcRemoveReference();
    }
  }

  void drop()
  {
    if (m_ptr) {
      m_ptr->rcDropReference();
    }
  }

private:
  /// Not implemented.
  RCPtr(const RCPtr &);

  /// Not implemented.
  RCPtr& operator=(const RCPtr &);

  T *m_ptr;
};

#endif // _RCPtr_h
