///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: MultiLineSubString.h 60 2004-11-03 00:12:15Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _MultiLineSubString_h
#define _MultiLineSubString_h

#include "AbstractMultiLineString.h"

class MultiLineSubString : public AbstractMultiLineString
{
public:
    MultiLineSubString(AbstractMultiLineString *target,
                       int start_index);

    MultiLineSubString(AbstractMultiLineString *target,
                       int start_index,
                       int end_index);
    virtual ~MultiLineSubString();

    virtual int lineCount() const;
    virtual const string *line(int index) const;

private:
    RCPtr<AbstractMultiLineString> m_target;
    int m_startIndex;
    int m_endIndex;
};

#endif

