///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: MailMessage.h 60 2004-11-03 00:12:15Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#ifndef _MailMessage_h
#define _MailMessage_h

#include "util.h"

class AbstractMultiLineString;
class MessageHeaderList;
class MailMessageList;

class MailMessage
{
public:
    MailMessage(AbstractMultiLineString *full_text);
    MailMessage(AbstractMultiLineString *head_text,
                AbstractMultiLineString *body_text,
                AbstractMultiLineString *full_text);
    ~MailMessage();

    const AbstractMultiLineString *headText()
    {
        return m_headText.get();
    }

    const AbstractMultiLineString *bodyText()
    {
        return m_bodyText.get();
    }

    const AbstractMultiLineString *fullText()
    {
        return m_fullText.get();
    }

    const MessageHeaderList *head();
    const MailMessageList *body();

    bool isMultiPart();
    bool hasParts();

    const AbstractMultiLineString *asText(bool &is_html);

private:
    bool isMultiPartType();
    bool isHtml(const AbstractMultiLineString *text);

private:
    RCPtr<AbstractMultiLineString> m_headText;
    RCPtr<AbstractMultiLineString> m_bodyText;
    RCPtr<AbstractMultiLineString> m_fullText;
    NewPtr<MessageHeaderList> m_head;
    NewPtr<MailMessageList> m_body;

    RCPtr<AbstractMultiLineString> m_decodedText;
    bool m_isHtml;
};

#endif

