///###////////////////////////////////////////////////////////////////////////
//
// Burton Computer Corporation
// http://www.burton-computer.com
// http://www.cooldevtools.com
// $Id: IstreamCharReader.cc 93 2004-11-13 13:53:20Z brian $
//
// Copyright (C) 2000 Burton Computer Corporation
// ALL RIGHTS RESERVED
//
// This program is open source software; you can redistribute it
// and/or modify it under the terms of the Q Public License (QPL)
// version 1.0. Use of this software in whole or in part, including
// linking it (modified or unmodified) into other programs is
// subject to the terms of the QPL.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// Q Public License for more details.
//
// You should have received a copy of the Q Public License
// along with this program; see the file LICENSE.txt.  If not, visit
// the Burton Computer Corporation or CoolDevTools web site
// QPL pages at:
//
//    http://www.burton-computer.com/qpl.html
//    http://www.cooldevtools.com/qpl.html
//

#include "IstreamCharReader.h"

class IstreamReaderPosition : public AbstractCharReaderPosition
{
public:
  IstreamReaderPosition(streampos _position) : position(_position)
  {
  }

  virtual ~IstreamReaderPosition()
  {
  }

  streampos position;
};

IstreamCharReader::IstreamCharReader(istream *stream,
                                     bool can_seek)
  : m_stream(stream), m_canSeek(can_seek)
{
}

IstreamCharReader::~IstreamCharReader()
{
}

bool IstreamCharReader::forward()
{
  setCurrentChar(safe_char(m_stream->get()));
  return *m_stream;
}

bool IstreamCharReader::hasChar()
{
  return !m_stream->eof();
}

bool IstreamCharReader::atEnd()
{
  return m_stream->eof();
}

bool IstreamCharReader::skip(int nchars)
{
  while (nchars-- > 0) {
    if (!forward()) {
      return false;
    }
  }
  return true;
}

OWNED AbstractCharReaderPosition *IstreamCharReader::createMark()
{
  return m_canSeek ? new IstreamReaderPosition(m_stream->tellg()) : 0;
}

void IstreamCharReader::returnToMark(AbstractCharReaderPosition *pos)
{
  if (m_canSeek && pos) {
    m_stream->seekg(dynamic_cast<IstreamReaderPosition*>(pos)->position);
  }
}
