pragma abicoder v2;
contract C {
	function f0() public pure returns (bytes memory) {
		return abi.encodeWithSelector(0x12345678);
	}
	function f1() public pure returns (bytes memory) {
		return abi.encodeWithSelector(0x12345678, "abc");
	}
	function f2() public pure returns (bytes memory) {
		bytes4 x = 0x12345678;
		return abi.encodeWithSelector(x, "abc");
	}
	function f3() public pure returns (bytes memory) {
		bytes4 x = 0x12345678;
		return abi.encodeWithSelector(x, type(uint).max);
	}
	struct S { uint a; string b; uint16 c; }
	function f4() public pure returns (bytes memory) {
		bytes4 x = 0x12345678;
		S memory s;
		s.a = 0x1234567;
		s.b = "Lorem ipsum dolor sit ethereum........";
		s.c = 0x1234;
		return abi.encodeWithSelector(x, type(uint).max, s, uint(3));
	}
}
// ====
// compileToEwasm: also
// ----
// f0() -> 0x20, 4, 8234104107246695022420661102507966550300666591269321702959126607540084801536
// f1() -> 0x20, 0x64, 8234104107246695022420661102507966550300666591269321702959126607540084801536, 862718293348820473429344482784628181556388621521298319395315527974912, 91135606241822717681769169345594720818313984248279388438121731325952, 0
// f2() -> 0x20, 0x64, 8234104107246695022420661102507966550300666591269321702959126607540084801536, 862718293348820473429344482784628181556388621521298319395315527974912, 91135606241822717681769169345594720818313984248279388438121731325952, 0
// f3() -> 0x20, 0x24, 0x12345678ffffffffffffffffffffffffffffffffffffffffffffffffffffffff, -26959946667150639794667015087019630673637144422540572481103610249216
// f4() -> 0x20, 292, 0x12345678ffffffffffffffffffffffffffffffffffffffffffffffffffffffff, -26959946667150639794667015087019630673637144422540572481103610249216, 2588154880046461420288033448353884544669165864563894958185946583924736, 80879840001451919384001045261058892020911433267621717443310830747648, 514631493222945105325971421573240365883976325135760395164659172419450175488, 2588154880046461420288033448353884544669165864563894958185946583924736, 125633351468921981443148290305511478939149093009039067761942823761346560, 0x264c6f72656d20697073756d20646f6c6f722073697420657468657265, 53113508339655873314659021564971517366334151400493876485713881232784043802624, 0
