/*
 * VRT RULES
 *
 * Copyright (C) 2014-2021 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule2528eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow:established, to_server; */
static FlowFlags rule2528flow0 =
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule2528option0 =
{
    OPTION_TYPE_FLOWFLAGS,
    { &rule2528flow0 }
};
/* flowbits:isset "starttls.attempt"; */
static FlowBitsInfo rule2528flowbits1 =
{
    "starttls.attempt",
    FLOWBIT_ISSET,
    0,
    0, /* flags */
    NULL, /*group name*/
    0,/*eval*/
    NULL, /*ids*/
    0 /*num_ids*/
};

static RuleOption rule2528option1 =
{
    OPTION_TYPE_FLOWBIT,
    { &rule2528flowbits1 }
};
/* flowbits:isnotset "sslv2.server_hello.request"; */
static FlowBitsInfo rule2528flowbits2 =
{
    "sslv2.server_hello.request",
    FLOWBIT_ISNOTSET,
    0,
    0, /* flags */
    NULL, /*group name*/
    0,/*eval*/
    NULL, /*ids*/
    0 /*num_ids*/
};

static RuleOption rule2528option2 =
{
    OPTION_TYPE_FLOWBIT,
    { &rule2528flowbits2 }
};
/* flowbits:isnotset "sslv3.server_hello.request"; */
static FlowBitsInfo rule2528flowbits3 =
{
    "sslv3.server_hello.request",
    FLOWBIT_ISNOTSET,
    0,
    0, /* flags */
    NULL, /*group name*/
    0,/*eval*/
    NULL, /*ids*/
    0 /*num_ids*/
};

static RuleOption rule2528option3 =
{
    OPTION_TYPE_FLOWBIT,
    { &rule2528flowbits3 }
};
/* flowbits:isnotset "tlsv1.server_hello.request"; */
static FlowBitsInfo rule2528flowbits4 =
{
    "tlsv1.server_hello.request",
    FLOWBIT_ISNOTSET,
    0,
    0, /* flags */
    NULL, /*group name*/
    0,/*eval*/
    NULL, /*ids*/
    0 /*num_ids*/
};

static RuleOption rule2528option4 =
{
    OPTION_TYPE_FLOWBIT,
    { &rule2528flowbits4 }
};
// content:"|01|", offset 2, depth 1;
static ContentInfo rule2528content5 =
{
    (u_int8_t *)("|01|"), /* pattern (now in snort content format) */
    1, /* depth */
    2, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2528option5 =
{
    OPTION_TYPE_CONTENT,
    { &rule2528content5 }
};
/* byte_test:size 2, value 0, operator >, offset 5; */
static ByteData rule2528byte_test6 =
{
    2, /* size */
    CHECK_GT, /* operator */
    0, /* value */
    5, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2528option6 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2528byte_test6 }
};
/* byte_test:size 2, value 0, offset 7; */
static ByteData rule2528byte_test7 =
{
    2, /* size */
    CHECK_EQ, /* operator */
    0, /* value */
    7, /* offset */
    0, /*multiplier */
    NOT_FLAG|BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2528option7 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2528byte_test7 }
};
/* byte_test:size 2, value 16, offset 7; */
static ByteData rule2528byte_test8 =
{
    2, /* size */
    CHECK_EQ, /* operator */
    16, /* value */
    7, /* offset */
    0, /*multiplier */
    NOT_FLAG|BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2528option8 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2528byte_test8 }
};
/* byte_test:size 2, value 20, operator >, offset 9; */
static ByteData rule2528byte_test9 =
{
    2, /* size */
    CHECK_GT, /* operator */
    20, /* value */
    9, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2528option9 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2528byte_test9 }
};
// content:"|8F|", offset 11, depth 1;
static ContentInfo rule2528content10 =
{
    (u_int8_t *)("|8F|"), /* pattern (now in snort content format) */
    1, /* depth */
    11, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2528option10 =
{
    OPTION_TYPE_CONTENT,
    { &rule2528content10 }
};
/* byte_test:size 2, value 32768, operator >, relative; */
static ByteData rule2528byte_test11 =
{
    2, /* size */
    CHECK_GT, /* operator */
    32768, /* value */
    0, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_RELATIVE|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2528option11 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2528byte_test11 }
};

/* references for sid 2528 */
/* reference: bugtraq "10116"; */
static RuleReference rule2528ref1 =
{
    "bugtraq", /* type */
    "10116" /* value */
};

/* reference: cve "2003-0719"; */
static RuleReference rule2528ref2 =
{
    "cve", /* type */
    "2003-0719" /* value */
};

/* reference: url "www.microsoft.com/technet/security/bulletin/MS04-011.mspx"; */
static RuleReference rule2528ref3 =
{
    "url", /* type */
    "www.microsoft.com/technet/security/bulletin/MS04-011.mspx" /* value */
};

static RuleReference *rule2528refs[] =
{
    &rule2528ref1,
    &rule2528ref2,
    &rule2528ref3,
    NULL
};
RuleOption *rule2528options[] =
{
    &rule2528option0,
    &rule2528option1,
    &rule2528option2,
    &rule2528option3,
    &rule2528option4,
    &rule2528option5,
    &rule2528option6,
    &rule2528option7,
    &rule2528option8,
    &rule2528option9,
    &rule2528option10,
    &rule2528option11,
    NULL
};

Rule rule2528 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       1, /* DIRECTION */
       "$SMTP_SERVERS", /* DSTIP     */
       "25", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       2528, /* sigid */
       13, /* revision */

       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "SMTP PCT Client_Hello overflow attempt",     /* message */
       rule2528refs, /* ptr to references */
       NULL /* Meta data */
   },
   rule2528options, /* ptr to rule options */
   &rule2528eval, /* use the built in detection function */
   0, /* am I initialized yet? */
   0,                                  /* Rule option count, used internally */
   0,                                  /* Flag with no alert, used internally */
   NULL /* ptr to internal data... setup during rule registration */
};


/* detection functions */
int rule2528eval(void *p) {
    //const u_int8_t *cursor_uri = 0;
    //const u_int8_t *cursor_raw = 0;
    const u_int8_t *cursor_normal = 0;


    // flow:established, to_server;
    if (checkFlow(p, rule2528options[0]->option_u.flowFlags) > 0 ) {
        // flowbits:isset "starttls.attempt";
        if (processFlowbits(p, rule2528options[1]->option_u.flowBit) > 0) {
                // flowbits:isnotset "sslv2.server_hello.request";
            if (processFlowbits(p, rule2528options[2]->option_u.flowBit) > 0) {
                    // flowbits:isnotset "sslv3.server_hello.request";
                if (processFlowbits(p, rule2528options[3]->option_u.flowBit) > 0) {
                        // flowbits:isnotset "tlsv1.server_hello.request";
                    if (processFlowbits(p, rule2528options[4]->option_u.flowBit) > 0) {
                            // content:"|01|", offset 2, depth 1;
                        if (contentMatch(p, rule2528options[5]->option_u.content, &cursor_normal) > 0) {
                            // byte_test:size 2, value 0, operator >, offset 5;
                            if (byteTest(p, rule2528options[6]->option_u.byte, cursor_normal) > 0) {
                                // byte_test:size 2, value 0, offset 7;
                                if (!(byteTest(p, rule2528options[7]->option_u.byte, cursor_normal) > 0)) {
                                    // byte_test:size 2, value 16, offset 7;
                                    if (!(byteTest(p, rule2528options[8]->option_u.byte, cursor_normal) > 0)) {
                                        // byte_test:size 2, value 20, operator >, offset 9;
                                        if (byteTest(p, rule2528options[9]->option_u.byte, cursor_normal) > 0) {
                                            // content:"|8F|", offset 11, depth 1;
                                            if (contentMatch(p, rule2528options[10]->option_u.content, &cursor_normal) > 0) {
                                                // byte_test:size 2, value 32768, operator >, relative;
                                                if (byteTest(p, rule2528options[11]->option_u.byte, cursor_normal) > 0) {
                                                    return RULE_MATCH;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    return RULE_NOMATCH;
}
