/*
 * VRT RULES
 *
 * Copyright (C) 2014-2021 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"
#include "detection_lib_meta.h"

/* declare detection functions */
int rule2044eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
/* flow for sid 2044 */
/* flow:established, no_stream, to_server; */
static FlowFlags rule2044flow1 =
{
    FLOW_ESTABLISHED|FLOW_TO_SERVER
};

static RuleOption rule2044option1 =
{
    OPTION_TYPE_FLOWFLAGS,
    { &rule2044flow1 }
};

/* content for sid 2044 */
// content:"|00 01|", offset 2, depth 2;
static ContentInfo rule2044content2 =
{
    (u_int8_t *)("|00 01|"), /* pattern (now in snort content format) */
    2, /* depth */
    2, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2044option2 =
{
    OPTION_TYPE_CONTENT,
    { &rule2044content2 }
};

// content:"|00 01|", offset 8, depth 2;
static ContentInfo rule2044content3 =
{
    (u_int8_t *)("|00 01|"), /* pattern (now in snort content format) */
    2, /* depth */
    8, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2044option3 =
{
    OPTION_TYPE_CONTENT,
    { &rule2044content3 }
};


/* references for sid 2044 */
static RuleReference *rule2044refs[] =
{
    NULL
};

RuleOption *rule2044options[] =
{
    &rule2044option1,
    &rule2044option2,
    &rule2044option3,
    NULL
};

Rule rule2044 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_TCP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       0, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "1723", /* DSTPORT   */
   },
   /* metadata */
   {
       RULE_GID,  /* genid (HARDCODED!!!) */
       2044, /* sigid */
       5, /* revision */

       "attempted-admin", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "POLICY PPTP Start Control Request attempt",     /* message */
       rule2044refs, /* ptr to references */
       NULL /* Meta data */
   },
   rule2044options, /* ptr to rule options */
    NULL,                               /* Use internal eval func */
    0,                                  /* Not initialized */
    0,                                  /* Rule option count, used internally */
    0,                                  /* Flag with no alert, used internally */
    NULL /* ptr to internal data... setup during rule registration */
};



/* detection functions */

int rule2044eval(void *p) {
    /* cursors, formally known as doe_ptr */
    const u_int8_t *cursor_normal = 0;

    // flow:established, no_stream, to_server;
    if (checkFlow(p, rule2044options[0]->option_u.flowFlags) > 0 ) {
        // content:"|00 01|", offset 2, depth 2;
        if (contentMatch(p, rule2044options[1]->option_u.content, &cursor_normal) > 0) {
            // content:"|00 01|", offset 8, depth 2;
            if (contentMatch(p, rule2044options[2]->option_u.content, &cursor_normal) > 0) {
                return RULE_MATCH;
            }
        }
    }
    return RULE_NOMATCH;
}
