/*   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <pthread.h>
#include <glib.h>
#include <unistd.h>
#include <signal.h>


#include "snoopynox.h"



void finished_digging()
{
  printf("[OK]\n");
}

void ping_finished_cb()
{
  brain_place_in_cb(BRAIN.ping_list);
  printf("%s\n", BRAIN.ping_list);
}

void print_info()
{
  printf("\n\nSnoopy is sniffing on the network device %s\
\nClient is%s hosting%s					 \
\nClient uses port %u to host			\
\n%s%s						\
\nThere are %i players in the game		\
\nThe refresher is%s going, timeout: %i		\
\n\n", 
	 BRAIN.network_device, 
	 CLIENT_HOSTING==1 ? "" : " not",
	 BRAIN.in_game_lobby==TRUE? " and in the game lobby" : "",
	 BRAIN.hosting_port,
	 strcmp(BRAIN.friend_follow, "") == 0 ? "Client is not following a friend" : "Client is following friend: ",
	 strcmp(BRAIN.friend_follow, "") == 0 ? "" : BRAIN.friend_follow,
	 GAME_NUMBER_OF_PLAYERS,
	 BRAIN.refreshing==TRUE ? "" : " not",BRAIN.refreshing==TRUE ?  BRAIN.refresher_to : -1);
}


void init_callback(char* line)
{
  if(strcmp(line, "version") == 0)
    {
      printf("Version: %s", PACKAGE_VERSION);
      printf("\n");
    }
  else if(strncmp(line, "refresh", 7) == 0)
    {
     
      if(strncmp(line+8, "start", 5) == 0)
	{
	  int to = atoi(line+8+6);
	  brain_start_refreshing("|rSnoopyOnLinux", to);
	}
      else if(strncmp(line+8, "stop", 4) == 0)
	brain_stop_refreshing();
    }
  else if(strcmp(line, "info") == 0)
    {
      print_info();
    }
  else if(strncmp(line, "blupdate", 8) == 0)
    {
      printf("Updating banlist %s . . . ", line+9);
      fflush(stdout);
      if(strcmp(line+9, "azeroth") == 0)
	{
	  banlist_update(AZEROTH);
	  printf("[OK]\n");
	}
      else if(strcmp(line+9, "lordaeron") == 0)
	{
	  banlist_update(LORDAERON);
	  printf("[OK]\n");
	}
      else if(strcmp(line+9, "kalimdor") == 0)
	{
	  banlist_update(KALIMDOR);
	  printf("[OK]\n");
	}
      else  if(strcmp(line+9, "northrend") == 0)
	{
	  banlist_update(NORTHREND);
	  printf("[OK]\n");
	}
      else 
	{
	  printf("[FAILED]\nblupdate found, but realm is not correct\n\n");
	}
    }
  else if(strncmp(line, "bluse", 5) == 0)
    {
      char file[100];
      if(strcmp(line+6, "azeroth") == 0)
	{
	  sprintf(file, "%s/.snoopy/snoopy_global_azeroth.bl", getenv("HOME"));
	  brain_add_banlist_file(file);
	}
      else if(strcmp(line+6, "lordaeron") == 0)
	{
	  sprintf(file, "%s/.snoopy/snoopy_global_lordaeron.bl", getenv("HOME"));
	  brain_add_banlist_file(file);
	}
      else if(strcmp(line+6, "kalimdor") == 0)
	{
	  sprintf(file, "%s/.snoopy/snoopy_global_kalimdor.bl", getenv("HOME"));
	  brain_add_banlist_file(file);
	}
      else  if(strcmp(line+6, "northrend") == 0)
	{
	  sprintf(file, "%s/.snoopy/snoopy_global_northren.bl", getenv("HOME"));
	  brain_add_banlist_file(file);
	}
      else 
	{
	  printf("bluse found, but realm is not correct\n\n");
	}
    }
   else if(strncmp(line, "message", 7) == 0)
    {
      memmove(BRAIN.start_message, line+8, strlen(line+8));
    }
   else if(strncmp(line, "getdota", 7) == 0)
     {
       if(strstr(line, " "))
	 update_dota(line + 8);
       else
	 update_dota(NULL);
     }
   else if(strncmp(line, "realm", 5) == 0)
     {
       memmove(BRAIN.realm, line+6, strlen(line+6));
     }
   else if(strncmp(line, "follow", 6) == 0)
     {
       memmove(BRAIN.friend_follow, line+7, strlen(line+7));
       lowercase_string(BRAIN.friend_follow);
     }
   else if(strncmp(line, "port", 4) == 0)
     {
       BRAIN.hosting_port = atoi(line + 5);
     }
  if(strcmp(BRAIN.realm, "") == 0)
    memmove(BRAIN.realm, "Azeroth\0", 8);
}

/* This should be obvious O_O */
int main(int argc, char **argv)
{ 
  if(argc == 1)
    {
      printf("Snoopy needs to know what to sniff: `snoopy [network dev]`\n");
      return 1;
    }
  if(argc == 2)
    {
      printf("Snoopy needs to know the effective user id. Since it needs to be ran as root, it is impossible to tell who you are (you can use the shell script, pass echo $UID, or `id -u`: `snoopy [network dev] [uid]`\n");
      return 1;
    }
  if(argc == 3)
    {
      printf("Snoopy needs to know your effective group id. Since it needs to be ran as root, it is impossible to tell who you are (you can use the shell script, pass echo $GROUPS, or `id -g`: `snoopy [network dev] [uid] [gid]`\n");
      return 1;
    }
  if(getuid() != 0)
    {
      printf("Snoopy wants to dig in the yard; he needs root privledges.\n");
      return 1;
    }

  if(strcmp(TCPKILL, "NOTFOUND") == 0)
    {
      printf("I could not find tcpkill on $PATH.  To see what $PATH is do `echo\
$PATH`.  Make sure, if you know you have the package dsniff, that\
tcpkill is in in $PATH; otherwise, install dsniff.\n");
    }
  if(strcmp(XCLIP, "NOTFOUND") == 0 && strcmp(PBCOPY, "NOTFOUND") == 0)
    {
      printf("I could not find a suitable program on $PATH to access the\
clipboard. To see what $PATH is do `echo $PATH`.  You should install\
the package xclip if you are on linux or pbcopy if you use mac.");
    }
  


  printf("Digging then dropping root privileges . . . ");
  fflush(stdout);
  brain_start(argv[1], finished_digging);

  /* INIT */
  BRAIN.uid = atoi(argv[2]);
  BRAIN.gid = atoi(argv[3]);

  system("mkdir -p ~/.snoopy; touch ~/.snoopy/snoopy-rc; touch ~/.snoopy/snoopy_local.bl");
  char folder[500];
  sprintf(folder, "%s/.snoopy", getenv("HOME"));
  brain_perm_set_file_to_user(folder); /* fix the permission of the .snoopy folder */

  char initloc[500];
  sprintf(initloc, "%s/.snoopy/snoopy-rc", getenv("HOME"));
  parse_init_file(initloc, init_callback);
  char bl[100];
  sprintf(bl, "%s/.snoopy/snoopy_local.bl", getenv("HOME"));
  brain_add_banlist_file(bl);

  char pfix[500];
  sprintf(pfix, "chown %i:%i ~/.snoopy/*; chmod ug+rw ~/.snoopy/*", BRAIN.uid, BRAIN.gid);
  system(pfix);


  printf("\nSnoopy is a Warcraft III host's best friend (but still likes clients).  Let him help you: \
\n\nping \t\t Display the pings of everyone in game\
\nip \t\t List the ip addresses of everyone in the game\
\nkick \t\t Pick a player from the player list to kick\
\ninfo \t\t Show info of snoopy's current state\
\nrefresh (start|stop) timeout \t Start or stop the refresher\
\nfollow account \t Follow friend--snoopy copies game names that they join\
\nversion \t Shows the version of snoopy\
\nexit \t\t Exit snoopy\
\nTo run a command while in Warcraft, prepend the command with /. The output will be put into your copy buffer.\
\nTo see a full list of what snoopy does go to http://snoopy.tuxfamily.org.\
\n\n");


  char pinger[500];
  char* dir = (char*)PREFIX;
  if(PREFIX == "NONE")
    {
      dir = "/usr/local";
    }
  sprintf(pinger, "%s/bin/snoopy-ping", dir);
  brain_set_ping_program(pinger);


  char input[500];
  while(1)
    {
      scanf("%s", input);
      if(strcmp(input, "exit") == 0)
	break;
      else if(strcmp(input, "ping") == 0)
      	{
	  printf("\n");
	  brain_speak_pings(ping_finished_cb);
      	}
      else if(strcmp(input, "ip") == 0)
	{
	  printf("\n");
	  /* brain_speak_ips(); */
	  brain_speak_ips_with_lanning_players();
	  printf("%s\n", BRAIN.ip_list);
	  printf("\n\n");
	}
      else if(strcmp(input, "kick") == 0)
	{
	  brain_speak_player_info();
	  printf("%s", BRAIN.player_info);
	  printf("Kick PID:  ");
	  int pid;
	  scanf("%i", &pid);
	  player* p = brain_get_player_pid(pid);
	  if(p)
	    brain_kill_connection(argv[1], -1, p->ext_addr.sin_addr, p->ext_addr.sin_port);
	  printf("\n");
	}
      else if(strcmp(input, "info") == 0)
	{
	  print_info();
	}
      else if(strcmp(input, "refresh") == 0)
      	{
	  char refargs[10];
	  scanf("%s", refargs);
	    if(strcmp(refargs, "start") == 0)
	      {
		int to;
		scanf("%i", &to);
		brain_start_refreshing("|rSnoopyOnLinux", to);
	      }
	    else if(strcmp(refargs, "stop") == 0)
	      brain_stop_refreshing();
      	}
      else if(strcmp(input, "version") == 0)
      	{
           printf(PACKAGE_VERSION);
	   printf("\n\n");
	}
      else if(strncmp(input, "follow", 6) == 0)
	{
	  char name[100];
	  scanf("%s", name);
	  memset(BRAIN.friend_follow, '\0', 100);
	  memmove(BRAIN.friend_follow, name, strlen(name));
	  printf("You are now following %s\n\n", name);
	}
      else if(strcmp(input, "test") == 0)
      	{
	}
      else
      	{
      	}
    } 
  brain_kill();
  return 0;
}
