/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "slot.h"
#include <stdlib.h>
#include <stdio.h>

void slots_loop_through(const slot* slots, slot_loop_callback handler, const void* args)
{
  slot* curr = (slot*)slots;
  while(1)
    {
      if(curr == NULL)
	break;
      
      handler(curr, args);
      
      curr = curr->next;
    }
}


int construct_slot_list(const u_char* data, slot* node, size_t number_of_slots)
{
  slot* curr = node;
  int i = 0;
  for(i = 0; i < number_of_slots; i++)
    {
    curr->data = (slot_data*)(data + i*9);
    curr->index = i;   
    if(i == number_of_slots- 1)
      {
	curr->next = NULL;
	break;
      }
    curr->next = (slot*)malloc(sizeof(slot));
    curr = curr->next;
  }
}
