/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* This packet is sent to every client connected for each client in
   game when someone joins except the person who joined. Only use this
   if you are a client and not the host: if you are host the person
   you send this to will not be in the list, and thus this packet is
   not realiable for such a circumstance. */

#ifndef __PACKET_PLAYER_JOINED_H_
#define __PACKET_PLAYER_JOINED_H_ 1

#include "warcraft_info.h"

/* TYPE: F7 */
#define SIG_PLAYER_JOINED 0x06

typedef struct{
#define PPJH_SIZE 5
  u_long jc_counter; /* player join/create counter */
  u_char pid; /* player id */
}player_joined_packet_header;


typedef struct{
#define PPJC_SIZE 36
  u_short ip_tag;
  struct sockaddr_in ext_addr; /* 0 for host */
  struct sockaddr_in unknown3;
}player_joined_packet_closer;

typedef struct{
#define PPJ_PN_SIZE(wp) (WP_SIZE(wp) - WPH_SIZE - PPJH_SIZE - PPJC_SIZE)
  player_joined_packet_header* header;
  u_char* player_name;
  player_joined_packet_closer* closer;
}player_joined_packet;


void construct_player_joined_packet(const warcraft_packet* wp, 
				    player_joined_packet* output);

#endif /* __PACKET_PLAYER_JOINED_H_ */

