/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __PACKET_MESSAGE_H_
#define __PACKET_MESSAGE_H_ 1
#include <sys/types.h>
#include "warcraft_info.h"

/* TYPE 0xF7 */
#define SIG_MESSAGE_HOST 0x0F


typedef struct
{
  u_char amount_of_information; 
  u_char* information;		/* the length of this is `amount_of_information' */
  u_char pid_of_sender;
  u_char type_of_message;	/* 10 = chat message; 11 = slot change  */
  u_char* rest_of_message; 	/* may not necessarily be any more */
} generic_message_packet;


void construct_generic_message_packet(const warcraft_packet* wp, 
				      generic_message_packet* out);



/* TYPE 0xFF */
#define SIG_MESSAGE_BNET 0x0E
typedef struct
{
  u_char* message;
}bnet_message_packet;

void construct_bnet_message_packet(const warcraft_packet* wp, 
				   bnet_message_packet* out);

#endif /* __PACKET_MESSAGE_H_ */

