/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* This packet is sent to the host by someone attempting to join his
   game.  Note that they my not nessaccarily be able to join. The type
   of packet is 0xF7 (GAME) */


#ifndef __PACKET_JOIN_REQUEST_H_
#define __PACKET_JOIN_REQUEST_H_ 1

#include "warcraft_info.h"
#include "packet_player_joined.h"


/* TYPE: F7 */
#define SIG_PLAYER_JOIN_REQUEST 0x1E /* a player requests to join the game */



typedef struct{
#define PJRH_SIZE 15
  u_long game_count;
  u_long tick_count;
  u_char unknown1;
  u_short ext_port;
  u_long jc_counter;
}player_join_request_packet_header;



typedef struct{
#define PJRC_SIZE 18
  u_short tag;
  struct sockaddr_in int_addr;
}player_join_request_packet_closer;


typedef struct{
#define PJR_PN_SIZE(wp) (WP_SIZE(wp) - WPH_SIZE - PJRH_SIZE - PJRC_SIZE)
#define PJR_SIZE(pjrp) (strlen((pjrp)->player_name) + PJRH_SIZE + PJRC_SIZE + sizeof(struct sockaddr_in))
  player_join_request_packet_header* header;
  u_char* player_name;
  player_join_request_packet_closer* closer;
  struct sockaddr_in ext_addr; 	/* Not part of the packet, but added by me for ease.*/
} player_join_request_packet;


void construct_player_join_request_packet(const warcraft_packet* wp, 
					  player_join_request_packet* output, 
					  const tcpip_packet* for_ip_info);
#endif /* __PACKET_JOIN_REQUEST_H_ */

