/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __PACKET_CREATE_GAME_H_
#define __PACKET_CREATE_GAME_H_ 1

#include "warcraft_info.h"
#include <stdlib.h>

#define SIG_CREATE_GAME 0x1C


typedef struct
{
#define CGPH_SIZE 20
  u_long unknown1;
  u_long unknown2;
  u_long game_type;
  u_long unknown3;
  u_long unknown4;
}create_game_packet_header;


long host_count_to_long(char* hc);
long slot_count_to_long(char sc);

typedef struct
{
  u_char zero;
  char free_slot_count; 		/* text formated: 39 = 9 slots, solved by using char */
#define CGP_FREE_SLOT_COUNT_LONG(cgp) (slot_count_to_long((cgp)->closer->free_slot_count))
  char host_count[8];
#define CGP_HOST_COUNT_LONG(cgp) (host_count_to_long((cgp)->closer->host_count))
  /* The rest of the packet I dont really care about */
}create_game_packet_closer;


typedef struct
{
  create_game_packet_header* header;
  u_char* game_name;
  create_game_packet_closer* closer;
}create_game_packet;



void construct_create_game_packet(const warcraft_packet* wp, 
				  create_game_packet* output, 
				  const tcpip_packet* for_ip_info);

#endif /* __PACKET_CREATE_GAME_H_ */

