/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __PACKET_ACCPET_JOIN_REQUEST_H_
#define __PACKET_ACCPET_JOIN_REQUEST_H_ 1

#include "warcraft_info.h"
#include "packet_slot_info.h"

/* TYPE: F7 */
#define SIG_ACCEPT_JOIN_REQUEST 0x04

/* A slot info packet with closing info about joining */

typedef struct
{
  u_char  pid;
  struct sockaddr_in ext_addr;
} accept_join_request_packet_closer;

typedef struct
{
  slot_info_packet sip;
  accept_join_request_packet_closer* closer;
}accept_join_request_packet;


void construct_accept_join_request_packet(const warcraft_packet* wp, 
					  accept_join_request_packet* out,
					  const tcpip_packet* for_ip_info);


#endif /* __PACKET_ACCPET_JOIN_REQUEST_H_ */

