/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __NOSE_H_
#define __NOSE_H_ 1

#include <pcap.h>
#include "warcraft_info.h"

typedef void (*_wcp_handler) (warcraft_packets* wp, tcpip_packet* p, void* args);


pcap_t* handle;

struct smelling_args
{
  _wcp_handler callback;
  void* args;
};


/* initialize the nose */
void nose_start(char* dev); 	

/* start sniffing */
void nose_sniff(); /* sniff on the calling thread */
pthread_t nose_sniff_thread(); /* sniff on a seperate thread */

/* quit sniffing, shutdown nose */
void nose_stop(); 		


void nose_smelled(u_char* args, const struct pcap_pkthdr* header,
		  const u_char* packet);














/* developmental */
void nose_send(const u_char* data, int size);
/* Methods to construct packet headers */
u_char* new_eth_header(u_char src_mac[6], u_char dest_mac[6], u_short type);
/* Does not allow options and always ip4, so version/length = 0x45 */
u_char* new_ip_header(struct in_addr src, struct in_addr dest);
u_char* new_tcp_header(u_short src_port, u_short dest_port, u_char flags);


#endif /* __NOSE_H_ */

