/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "nose.h"
#include "utilities.h"
#include "tcpip_packet.h"
#include "warcraft_info.h"
#include "packet_join_request.h"
#include "packet_player_joined.h"
#include "packet_create_game.h"
#include "packet_game_quit.h"
#include "client_state.h"
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <glib.h>
#include "brain.h"
#include <stdlib.h>


void nose_start(char* dev)
{
  handle = open_any_device(handle, dev);
  assert(handle != NULL);
}


void nose_sniff(_wcp_handler handler)
{
  struct smelling_args sa = {handler, NULL};
  int e = pcap_loop(handle, -1, nose_smelled, (u_char*)(&sa));
  assert(e != -1);
}


void* nose_sniff_thread_start(void* args)
{
  int e = pcap_loop(handle, -1, nose_smelled, (u_char*)args);
  assert(e != -1);
}

pthread_t nose_sniff_thread(_wcp_handler handler)
{
  struct smelling_args* sa = g_slice_new(struct smelling_args);
  sa->callback = handler;
  sa->args = NULL;
  pthread_t sniff_thread;
  int e = pthread_create(&sniff_thread, NULL, nose_sniff_thread_start, (u_char*)(sa));
  assert(e == 0);
  return sniff_thread;
}


void nose_stop()
{
  pcap_close(handle);
}


void nose_smelled(u_char* args, 
		  const struct pcap_pkthdr* header,
		  const u_char* packet)
{
  struct smelling_args* sa = (struct smelling_args*)args;
  tcpip_packet* p = (tcpip_packet*)malloc(sizeof(tcpip_packet));
  int e = construct_packet(packet,  p);


  if(check_if_known(p) != -1 && e != -1)
    {
      warcraft_packets* wp = new_warcraft_packets();
      construct_warcraft_packets(p, wp);
      sa->callback(wp, p, sa->args);
      free_packets(wp);           /* It is expected that before wp is
  				   freed every needed will be copied
  				   in the call to wcph.  This is to
  				   free everything undeed to prevent
  				   allocated massive amounts of memory */
    }
  free(p);
  /* libpcap handles freeing the packet, so I do not have to */
} 

















void nose_send(const u_char* data, int size)
{
  pcap_inject(handle, data, size);
}


u_char* new_eth_header(u_char* src_mac, u_char* dest_mac, u_short type)
{
  eth_header* eh = (eth_header*)malloc(14);
  memmove(eh->dest_mac, g_strdup(dest_mac), 6);
  memmove(eh->src_mac, g_strdup(src_mac), 6);
  eh->type = type;
  return (u_char*)eh;
}

u_char* new_ip_header(struct in_addr src, struct in_addr dest)
{
  ip_header* ih = (ip_header*)malloc(20);
  ih->ver_hlen = 0x45;
  ih->tos = 0;
  ih->length_of_packet = 20;
  ih->id = 0;
  ih->offset = 0;
  ih->ttl = 64;
  ih->protocol = IPPROTO_TCP;
  ih->csum = 0;
  ih->src = src;
  ih->dest = dest;

  /* ih->csum = (u_short)*g_compute_checksum_for_data(G_CHECKSUM_MD5, (u_char*)ih, 20); */
  return (u_char*)ih;
}


u_char* new_tcp_header(u_short src_port, u_short dest_port, u_char flags)
{
  tcp_header* th = (tcp_header*)malloc(20);
  th->src_port = src_port;
  th->dest_port = dest_port;
  /* th->sequence_number = 0; */
  /* th->ack_number = 0; */
  th->data_offset_reserved = 0x50;
  th->flags = flags;
  th->window_size = 0;
  th->csum = 0;
  th->urg_p = 0;

  /* th->csum = (u_short)*g_compute_checksum_for_data(G_CHECKSUM_MD5, (u_char*)th, 20); */
  return (u_char*)th;
}
