/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "init.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void 
parse_init_file(char* file_name, init_file_callback cb)
{
  FILE* fd = fopen(file_name, "r");
  if(!fd)
    return;
  /* go through the file */
  while(!feof(fd))
    {
      char line[500];
      char* s = fgets(line, 500, fd);
      if(s)
	{
	  /* get rid of \n */
	  char* loc = strchr(line, '\n');
	  while(loc)
	    {
	      *loc = '\0';
	      loc = strchr(line, '\n');
	    }
	  cb(line);
	}
    }
}
