/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/* THIS IS THE BRAIN OF SNOOPY.  EVERYTHING WILL BE ACCESSED FROM
   HERE.  THIS HANDLES EVERYTHING. EVERYTHING IS DONE ON SEPERATE THREADS. */

#ifndef __BRAIN_H_
#define __BRAIN_H_ 1
#include "snoopy.h" 		/* Include everything in libsnoopy */
#include <glib.h>
#include <pcap.h>

#define SNOOPY_RIGHTS getuid() 	/* 0 if root */


/* OS X COMPATIBILITY (from Ufar) */
#ifdef PT_ATTACH
#define PTRACE_ATTACH PT_ATTACH
#define PTRACE_CONT PT_CONTINUE
#endif


/* Holds everything, the memory of snoopy */
struct _brain
{
  char* network_device;		/* the device that I am sniffing on */
  int uid;
  int gid;
  GTimer* internal_clock; 	/* internal clock */
  pthread_t brain_thread; 	/* the thread that the brain runs on */
  player_list* players; 	/* a list of players, this should be updated as much as possible */
  _wcp_handler packet_callback; /* a function to be called each time a packet is received */
  char* ping_program;
  int kick_wait;
  int warcraft_pid;
  int attached;
  u_long host_count;
  u_short hosting_port;
  u_long free_slot_count; 	/*  at the beginning of the game */
  u_long open_slot_count;
  gboolean in_game;
  gboolean in_game_lobby;
  pthread_t refresher_thread;
  gboolean refreshing;
  gboolean refresher_thread_alive;
  int refresher_to;
  struct in_addr host_ip;
  struct in_addr my_int_ip;
  u_short host_port;
  char host_name[100];
  char my_name[100]; 		/* for client */
  char ping_list[500];
  char ip_list[500];
  char player_info[500];
  struct sockaddr_in message_player_fallback; /* Since there are multiple
						 packets sent when host
						 messages, only care about
						 the one sent to this guy*/
  GList* banlist_files;
  char start_message[500];
  char realm[50];
  gdouble game_start_time; 	/* set when game starts */
  char friend_follow[100];
};

struct _brain BRAIN; 


/* PUBLIC METHODS */
/* init */
typedef void (*def_function_type)();
void brain_start(char* network_dev, def_function_type on_finished); 	/* starts the brain */	

/* denit */
void brain_kill();

/* internal clock */
gdouble brain_get_time();

/* priviledges */
void brain_drop_root(); 	/* drop root priviledges */
void brain_gain_root();	        /* gain root priviledges */

/* pings */
typedef void (*ping_finished)(void* args);
void brain_ping_finished_cb(void* args);
void brain_set_ping_program(char* program); /* expects simple `program ip` return ping to stdout when running the program*/
void brain_speak_pings(ping_finished cb);
float brain_try_ping(struct in_addr ip); /* uses the set ping program */

/* ips */
void brain_speak_ips();
/* print lanners */
void brain_speak_ips_with_lanning_players();

/* kicking */
void brain_kill_connection(char* net_dev, int wait, struct in_addr ip, short port);

/* list all player info */
void brain_speak_player_info();


/* getting info */
player* brain_get_player_pid(int pid);
player_list* brain_get_player_list_copy();


/* autorefresher */
void brain_refresh(char* name);
void brain_start_refreshing(char *name, int to);
void brain_stop_refreshing();


/* access to the copy buffer using xclip */
void brain_place_in_cb(char* s);

/* banlist */
void brain_add_banlist_file(char* file_name);
int brain_check_banlists(char* account); /* -1 = not found */


/* permissions */
void brain_perm_set_file_to_user(char* file); /* takes * since it uses system() */

/* PRIVATE METHODS */
/* packet handlers */
/* DEPRECATED */
static void client_state_hosting_changed(int hosting); /* called when the hosting state of the client has changed */
/*  */

static void* packet_callback(warcraft_packets* wp, tcpip_packet* p, void* args); /* called when i receive a warcraft 
										    packet */
static void* warcraft_packets_looper(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);

static void handle_slot_info(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);  
static void handle_game_loading(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);
static void handle_game_loaded(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);
static void handle_create_game(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);	
static void handle_quit_game(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);						      
static void handle_player_request(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);
static void handle_player_accepted(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);
static void handle_player_joined(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);
static void handle_player_left(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);
static void handle_host_echo_request(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);
static void handle_host_echo_response(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);
static void handle_message_packet(warcraft_packet* wp, tcpip_packet* tcpipp,  void* args);

/* MESSAGES */
static void brain_pick_random_player_fallback();

/* Get stuff */
static int brain_get_port(); 	/* Get's port from wine's registry. THIS ASSUMES YOU'RE ON LINUX */
static void brain_get_my_int_ip();


/* NON-OPERATIONAL METHODS */
/* Reading Warcraft's memory.  There is a problem since it is ran with wine.  The process is actually wine-preload and I have no idea where to start looking for warcraft's memory.  Perhaps /proc/<pid>/mem using open() and read() */
#define WC_ADDR_PORT           0x6F87E654
#define WC_ADDR_HOST_COUNTER   0x6F87EE78
#define WC_ADDR_GAME_CHECKSUM  0x6F87E60C
void brain_mind_meld(); 		/* Searches /proc/ for the pid of warcraft, then becomes its parent */
void brain_read_memory(off_t offset, size_t length, void* out);
#define BRAIN_READ_MEMORY(offset, type, out) brain_read_memory(offset, sizeof(type), out)


#endif /* __BRAIN_H_ */

