/***************************************************************************
 *   Copyright (C) 2008 by Devin Smittle   *
 *   pandagoat@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/**
 * @file   banlist.h
 * @author Devin Smittle <pandagoat@gmail.com>
 * @date   Sat Aug 16 01:44:26 2008
 * 
 * @brief This will handle a banlist--represented as a file.
 * Functions will check if a player is on it, etc.  It will not store
 * the entire file in memory for obvious reasons.
 * 
 * 
 */

#ifndef __BANLIST_H_
#define __BANLIST_H_ 1
#include <glib.h>

enum realm {AZEROTH, LORDAERON, KALIMDOR, NORTHREND};

int banlist_update(enum realm r);

/* -1 not found */
int banlist_check_account(const char* bl_file_name, const char* account, char* reason, unsigned short reason_size);

void banlist_ban(const char* file_name, const char* account, gdouble time_of_ban, const char* banner, char* reason, char* realm, char* output);





#endif /* __BANLIST_H_ */

