/* $Id: pml.h,v 1.50 2020-12-24 05:54:18 phil Exp $ */

/*
 * ``Poor Man's LOAD''
 * list of functions loaded with snobol4 image.
 *
 * NOTE!! After version 1.5, all new functionality being built/installed
 * in dynamicly loadable files!!
 *
 * See lib/snolib *.c for example functions
 */

/*
 * NOTE!! PMLFUNC2 used for entry points renamed due to 
 * name collisions (many due to VMS config.h define games)
 */

PMLFUNC(HOST)				/* SPITBOL compat */
PMPROTO("HOST()")			/* two polymorphic params */

PMLFUNC2("EXIT",EXIT)			/* SPITBOL compat */
PMPROTO("EXIT()")			/* one polymorphic param */

PMLFUNC2("SQRT",SQRT)
PMPROTO("SQRT(REAL)REAL")

PMLFUNC2("EXP",EXP)
PMPROTO("EXP(REAL)REAL")

PMLFUNC2("LOG",LOG)

/* 1/23/2011 */
PMLFUNC2("LN",LOG)
PMPROTO("LN(REAL)REAL")

PMLFUNC(CHOP)
PMPROTO("CHOP(REAL)REAL")

PMLFUNC2("SIN",SIN)
PMPROTO("SIN(REAL)REAL")

PMLFUNC2("COS",COS)
PMPROTO("COS(REAL)REAL")

PMLFUNC2("TAN",TAN)
PMPROTO("TAN(REAL)REAL")

/* 1/23/2011 */
PMLFUNC2("ATAN",ATAN)
PMPROTO("ATAN(REAL)REAL")

PMLFUNC2("FILE",FILE2)			/* SITBOL compat */
PMPROTO("FILE(STRING)STRING")

/* 2/14/2012 -- extensions */
PMLFUNC(FILE_ISDIR)
PMPROTO("FILE_ISDIR(STRING)STRING")
PMLFUNC(FILE_ABSPATH)
PMPROTO("FILE_ABSPATH(STRING)STRING")

PMLFUNC2("DELETE",DELETE)		/* SITBOL compat */
PMPROTO("DELETE(STRING)STRING")

PMLFUNC2("RENAME",RENAME)		/* SITBOL compat */
PMPROTO("RENAME(STRING)STRING")

/* 4/7/97; */
PMLFUNC2("IO_FINDUNIT",IO_FINDUNIT)
PMPROTO("IO_FINDUNIT()INTEGER")

/* experimental 3/12/99; */
PMLFUNC(SSET)
PMPROTO("SSET(INTEGER,INTEGER,INTEGER,INTEGER)INTEGER")

/* 4/27/2001; */
#ifdef PML_SERV
PMLFUNC(SERV_LISTEN)
PMPROTO("SERV_LISTEN(STRING,STRING,STRING)INTEGER")
#endif /* PML_SERV defined */

/* 12/6/2001; */
PMLFUNC(ORD)
PMPROTO("ORD(STRING)INTEGER")

/* 1/22/2011 */
/* prototypes moved to readline.sno 1/3/2011 */
#ifdef PML_READLINE
PMLFUNC(READLINE)
PMLFUNC(ADD_HISTORY)
PMLFUNC(HISTORY_EXPAND)
#endif

/* 8/31/2013 */
PMLFUNC(BREAKPOINT)
PMPROTO("BREAKPOINT(INTEGER,INTEGER)INTEGER")

/* 10/21/2020 */
PMLFUNC(FILE_NEWER)
PMPROTO("FILE_NEWER(STRING,STRING)INTEGER")

/* 11/8/2020 */
PMLFUNC(EXTERNAL_DATATYPE)
PMPROTO("EXTERNAL_DATATYPE(EXTERNAL)STRING")

/* 11/11/2020 */
PMLFUNC(EXTERNAL_MODULE_NAME)
PMPROTO("EXTERNAL_MODULE_NAME(EXTERNAL)STRING")
PMLFUNC(EXTERNAL_MODULE_PATH)
PMPROTO("EXTERNAL_MODULE_PATH(EXTERNAL)STRING")

/* 12/23/2020 */
PMLFUNC(FILE_LIB_FIND)
PMPROTO("FILE_LIB_FIND(STRING,STRING,STRING)STRING")
