/* $Id: spcint.c,v 1.9 2020-11-19 02:31:31 phil Exp $ */

/*
 * convert from string to integer
 *
 * generic version
 * using scanf to detect whether we've matched the whole string.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H defined */

#include <stdio.h>

#include "h.h"
#include "snotypes.h"
#include "macros.h"
#include "lib.h"
#include "str.h"

#include "equ.h"			/* for I and R */
#include "res.h"
#include "data.h"			/* for SPITCL */

#define TC '|'
#define EXTRA 2				/* NUL + terminator */

int
spcint(struct descr *dp, struct spec *sp) {
    char buffer[64];			/* ??? */
    size_t len;
    char *cp;
    long l;
    char t;

    len = S_L(sp);
    cp = S_SP(sp);

    if (D_A(SPITCL)) {			/* SPITBOL features? */
	/* strip leading whitespace */
	while (len > 0 && (*cp == ' ' || *cp == '\t')) {
	    cp++;
	    len--;
	}
    }
    
    if (len == 0) {
	D_A(dp) = 0;
	D_F(dp) = 0;			/* clear flags */
	D_V(dp) = I;			/* set type */
	return TRUE;
    }
    
    if (len > sizeof(buffer)-EXTRA)
	len = sizeof(buffer)-EXTRA;
    
    memcpy(buffer, cp, len);
    
    buffer[len++] = TC;
    buffer[len] = '\0';
    if (sscanf(buffer, "%ld%c", &l, &t) != 2 || t != TC)
	return FALSE;
    D_A(dp) = l;
    D_F(dp) = 0;			/* clear flags */
    D_V(dp) = I;			/* set type */
    
    return TRUE;			/* success */
}
