/* $Id: expops.c,v 1.19 2020-10-13 04:47:53 phil Exp $ */

/*
 * support for exponentiation, using pow() function.
 *
 * pow exists in v6 (buth math.h didn't), SVID2, XPG2, XPG3, POSIX.1, ANSI C
 *
 * see dummy/expops.c for dummy version of this file
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H defined */

# include <math.h>
# include <stdio.h>

# include "h.h"
# include "snotypes.h"
# include "macros.h"
# include "lib.h"			/* own prototypes */

int
expint(struct descr *result, struct descr *x, struct descr *y) {
    int_t ix, iy;
    int_t p;

    ix = D_A(x);
    iy = D_A(y);

    if (ix == 0 && iy < 0)		/* by definition of EXPINT macro */
	return 0;			/* fail */

#if 1
    if (iy < 0) {
	p = 0;
    }
    else {
/* perform X *= Y, checking for overflow */
#define SIGN (((unsigned INT_T)1)<<(sizeof(int_t)*8-1))
#define MULT(X,Y) { \
    register int_t temp = (X) * (Y); \
    if (((X) ^ (Y) ^ temp) & SIGN) return 0; \
    X = temp; \
}

	p = 1;
	for (;;) {
	    if (iy & 1)
		MULT(p,ix);
	    iy >>= 1;
	    if (iy == 0)
		break;
	    MULT(ix,ix);
	}
    }
    D(result) = D(x);			/* XXX copy F&V */
    D_A(result) = (int_t) p;
#else
    CLR_MATH_ERROR();
    p = pow( (double)ix, (double)iy );
    D(result) = D(x);			/* XXX copy F&V */
    D_A(result) = (int_t) p;
    if (MATH_ERROR())
	return 0;			/* fail */
#endif
    return 1;				/* succeed */
}

int
exreal(struct descr *result, struct descr *x, struct descr *y) {
    real_t r;

    /* XXX use repeated mutiplies? */
    CLR_MATH_ERROR();
    r = pow( D_RV(x), D_RV(y) );
    if (MATH_ERROR())
	return 0;			/* fail */
    D(result) = D(x);			/* XXX copy F&V */
    D_RV(result) = r;
    return 1;				/* succeed */
}
