
/*

    File: smtp.h
    
    Copyright (C) 1999,2000 by Wolfgang Zekoll <wzk@quietsche-entchen.de>

    This source is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This source is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _SMTP_INCLUDED
#define	_SMTP_INCLUDED



#define	SENDMAIL	"/usr/sbin/sendmail"
#define	SMTP_TIMEOUT	300
#define	SMTP_ACCEPTTIME	600



extern char *program;
extern char progname[80];
extern int debug;


#define	WAITING		1
#define	MAIL_SEEN	2
#define	RCPT_SEEN	3
#define	DATA_SEEN	4
#define	SEND_QUIT	5
#define	NO_SENDMAIL	6



typedef struct _config {
    char	hostname[200];

    int		etrn;
    int		droppath;
    int		timeout;

    char	*senderlist;
    char	*rcptlist;
    char	senderdomain[200];

    char	server[200];
    char	**argv;

    char	varname[80];
    char	acp[200];
    char	ccp[200];

    char	clientdir[200];
    int		accepttime;
    } config_t;



typedef struct _bio {
    int		fd;

    int		here, len;
    char	buffer[512];
    } bio_t;


typedef struct _smtp {
    config_t	*config;

    char	servername[200];

    char	hostname[200];
    int		sin, sout;

    bio_t	cbuf, sbuf;

    char	ipnum[80];
    char	client[80];

    int		helloseen;
    int		state;
    int		mailcount;


	/*
	 * Mail-spezifische Daten
	 */

    char	origsender[80];
    char	sender[80];
    int		nrcpt;
    struct {
	int	here, max;
	char	*list;
	} rcpt;

    char	jobid[80];
    char	msgid[200];
    long	size;

    char	spoolfile[200];
    } smtp_t;


extern int proxy_request(config_t *config);


#endif

