; Install SLIB on Windows for current user
; Basic script generated by the HM NIS Edit Script Wizard.
; Augmented by Jerry van Dijk, february 2007
; placed in the public domain

; *** version numbers ***
!define PRODUCT_VERSION "3b7-1"

; ----------------[ NO CHANGES BELOW ]----------------

; *** unless files are added or removed ***
; *** remember to edit both 'file' and 'delete' sections!

; *** registry settings ***
!define KEY_VERSION "version"
!define SLIB_KEY "Software\Voluntocracy\slib"

; *** environment variables ***
!define SlibEnvVar "SCHEME_LIBRARY_PATH"

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "SLIB"
!define PRODUCT_COMPANY "Voluntocracy"
!define PRODUCT_PUBLISHER "Aubrey Jaffer"
!define PRODUCT_WEB_SITE "http://people.csail.mit.edu/jaffer/SLIB"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\slib-${PRODUCT_VERSION}.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_STARTMENU_REGVAL "NSIS:StartMenuDir"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "SLIB.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME

; License page
!insertmacro MUI_PAGE_LICENSE "COPYING"

; Directory page
!insertmacro MUI_PAGE_DIRECTORY

; Start menu page
var ICONS_GROUP
!define MUI_STARTMENUPAGE_NODISABLE
!define MUI_STARTMENUPAGE_DEFAULTFOLDER "slib"
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "${PRODUCT_STARTMENU_REGVAL}"
!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "slib-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\slib"
InstallDirRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

; Check for existing older install
Function .onInit
  ReadRegStr $0 ${PRODUCT_UNINST_ROOT_KEY} "${SLIB_KEY}" "${KEY_VERSION}"
  StrCmp $0 '' +5 0
  StrCmp $0 ${PRODUCT_VERSION} +4 0
  MessageBox MB_OK|MB_ICONSTOP "You already have SLIB version $0 installed. Please uninstall this first."
  Abort
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File "alist.scm"
  File "alist.txi"
  File "alistab.scm"
  File "ANNOUNCE"
  File "array.scm"
  File "array.txi"
  File "arraymap.scm"
  File "arraymap.txi"
  File "batch.scm"
  File "Bev2slib.scm"
  File "break.scm"
  File "byte.scm"
  File "byte.txi"
  File "bytenumb.scm"
  File "bytenumb.txi"
  File "ChangeLog"
  File "chap.scm"
  File "chap.txi"
  File "charplot.scm"
  File "cie1931.xyz"
  File "cie1964.xyz"
  File "ciesia.dat"
  File "ciesid65.dat"
  File "clrnamdb.scm"
  File "cltime.scm"
  File "coerce.scm"
  File "coerce.txi"
  File "collect.scm"
  File "collectx.scm"
  File "color.scm"
  File "color.txi"
  File "colornam.scm"
  File "colornam.txi"
  File "colorspc.scm"
  File "comlist.scm"
  File "comparse.scm"
  File "comparse.txi"
  File "COPYING"
  File "crc.scm"
  File "cring.scm"
  File "cvs.scm"
  File "cvs.txi"
  File "daylight.scm"
  File "daylight.txi"
  File "db2html.scm"
  File "db2html.txi"
  File "dbcom.scm"
  File "dbinterp.scm"
  File "dbrowse.scm"
  File "dbsyn.scm"
  File "dbutil.scm"
  File "dbutil.txi"
  File "debug.scm"
  File "defmacex.scm"
  File "determ.scm"
  File "determ.txi"
  File "dft.scm"
  File "dft.txi"
  File "differ.scm"
  File "differ.txi"
  File "dirs.scm"
  File "dirs.txi"
  File "dwindtst.scm"
  File "dynamic.scm"
  File "dynwind.scm"
  File "eval.scm"
  File "factor.scm"
  File "factor.txi"
  File "FAQ"
  File "fdl.texi"
  File "fluidlet.scm"
  File "fluid-let.scm"
  File "format.scm"
  File "format.texi"
  File "formatst.scm"
  File "genwrite.scm"
  File "getopt.scm"
  File "getparam.scm"
  File "getparam.txi"
  File "glob.scm"
  File "glob.txi"
  File "grapheps.ps"
  File "grapheps.scm"
  File "grapheps.txi"
  File "hash.scm"
  File "hashtab.scm"
  File "hashtab.txi"
  File "html4each.scm"
  File "html4each.txi"
  File "htmlform.scm"
  File "htmlform.txi"
  File "http-cgi.scm"
  File "http-cgi.txi"
  File "indexes.texi"
  File "limit.scm"
  File "limit.texi"
  File "lineio.scm"
  File "lineio.txi"
  File "linterp.scm"
  File "linterp.txi"
  File "logical.scm"
  File "macrotst.scm"
  File "macwork.scm"
  File "Makefile"
  File "manifest.scm"
  File "manifest.txi"
  File "matfile.scm"
  File "matfile.txi"
  File "math-integer.scm"
  File "math-integer.txi"
  File "math-real.scm"
  File "mbe.scm"
  File "minimize.scm"
  File "minimize.txi"
  File "mkclrnam.scm"
  File "mkclrnam.txi"
  File "mklibcat.scm"
  File "modular.scm"
  File "modular.txi"
  File "mulapply.scm"
  File "mularg.scm"
  File "mwdenote.scm"
  File "mwexpand.scm"
  File "mwsynrul.scm"
  File "nbs-iscc.txt"
  File "ncbi-dna.scm"
  File "ncbi-dna.txi"
  File "null.scm"
  File "obj2str.scm"
  File "obj2str.txi"
  File "object.scm"
  File "object.texi"
  File "paramlst.scm"
  File "peanosfc.scm"
  File "peanosfc.txi"
  File "phil-spc.scm"
  File "phil-spc.txi"
  File "pnm.scm"
  File "pnm.txi"
  File "pp.scm"
  File "ppfile.scm"
  File "prec.scm"
  File "printf.scm"
  File "priorque.scm"
  File "priorque.txi"
  File "process.scm"
  File "promise.scm"
  File "psxtime.scm"
  File "qp.scm"
  File "queue.scm"
  File "queue.txi"
  File "r4rsyn.scm"
  File "randinex.scm"
  File "randinex.txi"
  File "random.scm"
  File "random.txi"
  File "ratize.scm"
  File "ratize.txi"
  File "rdms.scm"
  File "README"
  File "recobj.scm"
  File "record.scm"
  File "repl.scm"
  File "require.scm"
  File "resenecolours.txt"
  File "root.scm"
  File "saturate.txt"
  File "sc2.scm"
  File "sc4opt.scm"
  File "sc4sc3.scm"
  File "scaexpp.scm"
  File "scaglob.scm"
  File "scainit.scm"
  File "scamacr.scm"
  File "scanf.scm"
  File "scaoutp.scm"
  File "schmooz.scm"
  File "schmooz.texi"
  File "bigloo.init"
  File "chez.init"
  File "elk.init"
  File "gambit.init"
  File "guile.init"
  File "guile-2.init"
  File "jscheme.init"
  File "kawa.init"
  File "macscheme.init"
  File "mitscheme.init"
  File "mzscheme.init"
  File "pscheme.init"
  File "RScheme.init"
  File "scheme2c.init"
  File "scheme48.init"
  File "scm.init"
  File "scsh.init"
  File "sisc.init"
  File "s7.init"
  File "STk.init"
  File "t3.init"
  File "umbscheme.init"
  File "vscm.init"
  File "scmacro.scm"
  File "selfset.scm"
  File "sierpinski.scm"
  File "simetrix.scm"
  File "slib.html"
  File "slib.nsi"
  File "slib.spec"
  File "slib.texi"
  File "solid.scm"
  File "solid.txi"
  File "sort.scm"
  File "soundex.scm"
  File "srfi-1.scm"
  File "srfi-1.txi"
  File "srfi-2.scm"
  File "srfi-23.scm"
  File "srfi-61.scm"
  File "srfi-8.scm"
  File "srfi-9.scm"
  File "srfi.scm"
  File "srfi.txi"
  File "stdio.scm"
  File "strcase.scm"
  File "strport.scm"
  File "strsrch.scm"
  File "structure.scm"
  File "subarray.scm"
  File "subarray.txi"
  File "syncase.sh"
  File "synchk.scm"
  File "synclo.scm"
  File "synrul.scm"
  File "Template.scm"
  File "timecore.scm"
  File "timezone.scm"
  File "top-refs.scm"
  File "top-refs.txi"
  File "trace.scm"
  File "transact.scm"
  File "transact.txi"
  File "tree.scm"
  File "tree.txi"
  File "trnscrpt.scm"
  File "tsort.scm"
  File "tsort.txi"
  File "tzfile.scm"
  File "uri.scm"
  File "uri.txi"
  File "values.scm"
  File "version.txi"
  File "vet.scm"
  File "vet.txi"
  File "withfile.scm"
  File "wttree.scm"
  File "wttree-test.scm"
  File "yasyn.scm"

; Shortcuts
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\SLIB Manual.lnk" "$INSTDIR\slib.html"
  !insertmacro MUI_STARTMENU_WRITE_END

; Jaffer slib registry settings
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${SLIB_KEY}" "${KEY_VERSION}" "${PRODUCT_VERSION}"

; Jaffer slib environment variables
  Push ${SlibEnvVar}
  Push "$INSTDIR\"
  Call WriteEnvStr

SectionEnd

Section -AdditionalIcons
  !insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk" "$INSTDIR\uninst.exe"
  !insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\slib-${PRODUCT_VERSION}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\slib-${PRODUCT_VERSION}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Function .onInstSuccess
  IfRebootFlag 0 noreboot
    MessageBox MB_YESNO|MB_ICONQUESTION|MB_DEFBUTTON1 "A reboot is required to finish the installation. Do you wish to reboot now?" IDNO noreboot
      Reboot
  noreboot:
FunctionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  !insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\yasyn.scm"
  Delete "$INSTDIR\wttree-test.scm"
  Delete "$INSTDIR\wttree.scm"
  Delete "$INSTDIR\withfile.scm"
  Delete "$INSTDIR\vet.txi"
  Delete "$INSTDIR\vet.scm"
  Delete "$INSTDIR\version.txi"
  Delete "$INSTDIR\values.scm"
  Delete "$INSTDIR\uri.txi"
  Delete "$INSTDIR\uri.scm"
  Delete "$INSTDIR\tzfile.scm"
  Delete "$INSTDIR\tsort.txi"
  Delete "$INSTDIR\tsort.scm"
  Delete "$INSTDIR\trnscrpt.scm"
  Delete "$INSTDIR\tree.txi"
  Delete "$INSTDIR\tree.scm"
  Delete "$INSTDIR\transact.txi"
  Delete "$INSTDIR\transact.scm"
  Delete "$INSTDIR\trace.scm"
  Delete "$INSTDIR\top-refs.txi"
  Delete "$INSTDIR\top-refs.scm"
  Delete "$INSTDIR\timezone.scm"
  Delete "$INSTDIR\timecore.scm"
  Delete "$INSTDIR\Template.scm"
  Delete "$INSTDIR\synrul.scm"
  Delete "$INSTDIR\synclo.scm"
  Delete "$INSTDIR\synchk.scm"
  Delete "$INSTDIR\syncase.sh"
  Delete "$INSTDIR\subarray.txi"
  Delete "$INSTDIR\subarray.scm"
  Delete "$INSTDIR\structure.scm"
  Delete "$INSTDIR\strsrch.scm"
  Delete "$INSTDIR\strport.scm"
  Delete "$INSTDIR\strcase.scm"
  Delete "$INSTDIR\stdio.scm"
  Delete "$INSTDIR\srfi.txi"
  Delete "$INSTDIR\srfi.scm"
  Delete "$INSTDIR\srfi-9.scm"
  Delete "$INSTDIR\srfi-8.scm"
  Delete "$INSTDIR\srfi-61.scm"
  Delete "$INSTDIR\srfi-23.scm"
  Delete "$INSTDIR\srfi-2.scm"
  Delete "$INSTDIR\srfi-1.txi"
  Delete "$INSTDIR\srfi-1.scm"
  Delete "$INSTDIR\soundex.scm"
  Delete "$INSTDIR\sort.scm"
  Delete "$INSTDIR\solid.txi"
  Delete "$INSTDIR\solid.scm"
  Delete "$INSTDIR\slib.texi"
  Delete "$INSTDIR\slib.spec"
  Delete "$INSTDIR\slib.nsi"
  Delete "$INSTDIR\slib.html"
  Delete "$INSTDIR\simetrix.scm"
  Delete "$INSTDIR\sierpinski.scm"
  Delete "$INSTDIR\selfset.scm"
  Delete "$INSTDIR\scmacro.scm"
  Delete "$INSTDIR\bigloo.init"
  Delete "$INSTDIR\chez.init"
  Delete "$INSTDIR\elk.init"
  Delete "$INSTDIR\gambit.init"
  Delete "$INSTDIR\guile.init"
  Delete "$INSTDIR\guile-2.init"
  Delete "$INSTDIR\jscheme.init"
  Delete "$INSTDIR\kawa.init"
  Delete "$INSTDIR\macscheme.init"
  Delete "$INSTDIR\mitscheme.init"
  Delete "$INSTDIR\mzscheme.init"
  Delete "$INSTDIR\pscheme.init"
  Delete "$INSTDIR\RScheme.init"
  Delete "$INSTDIR\scheme2c.init"
  Delete "$INSTDIR\scheme48.init"
  Delete "$INSTDIR\scm.init"
  Delete "$INSTDIR\scsh.init"
  Delete "$INSTDIR\sisc.init"
  Delete "$INSTDIR\s7.init"
  Delete "$INSTDIR\STk.init"
  Delete "$INSTDIR\t3.init"
  Delete "$INSTDIR\umbscheme.init"
  Delete "$INSTDIR\vscm.init"
  Delete "$INSTDIR\schmooz.texi"
  Delete "$INSTDIR\schmooz.scm"
  Delete "$INSTDIR\scaoutp.scm"
  Delete "$INSTDIR\scanf.scm"
  Delete "$INSTDIR\scamacr.scm"
  Delete "$INSTDIR\scainit.scm"
  Delete "$INSTDIR\scaglob.scm"
  Delete "$INSTDIR\scaexpp.scm"
  Delete "$INSTDIR\sc4sc3.scm"
  Delete "$INSTDIR\sc4opt.scm"
  Delete "$INSTDIR\sc2.scm"
  Delete "$INSTDIR\saturate.txt"
  Delete "$INSTDIR\root.scm"
  Delete "$INSTDIR\resenecolours.txt"
  Delete "$INSTDIR\require.scm"
  Delete "$INSTDIR\repl.scm"
  Delete "$INSTDIR\record.scm"
  Delete "$INSTDIR\recobj.scm"
  Delete "$INSTDIR\README"
  Delete "$INSTDIR\rdms.scm"
  Delete "$INSTDIR\ratize.txi"
  Delete "$INSTDIR\ratize.scm"
  Delete "$INSTDIR\random.txi"
  Delete "$INSTDIR\random.scm"
  Delete "$INSTDIR\randinex.txi"
  Delete "$INSTDIR\randinex.scm"
  Delete "$INSTDIR\r4rsyn.scm"
  Delete "$INSTDIR\queue.txi"
  Delete "$INSTDIR\queue.scm"
  Delete "$INSTDIR\qp.scm"
  Delete "$INSTDIR\psxtime.scm"
  Delete "$INSTDIR\promise.scm"
  Delete "$INSTDIR\process.scm"
  Delete "$INSTDIR\priorque.txi"
  Delete "$INSTDIR\priorque.scm"
  Delete "$INSTDIR\printf.scm"
  Delete "$INSTDIR\prec.scm"
  Delete "$INSTDIR\ppfile.scm"
  Delete "$INSTDIR\pp.scm"
  Delete "$INSTDIR\pnm.txi"
  Delete "$INSTDIR\pnm.scm"
  Delete "$INSTDIR\phil-spc.txi"
  Delete "$INSTDIR\phil-spc.scm"
  Delete "$INSTDIR\peanosfc.txi"
  Delete "$INSTDIR\peanosfc.scm"
  Delete "$INSTDIR\paramlst.scm"
  Delete "$INSTDIR\object.texi"
  Delete "$INSTDIR\object.scm"
  Delete "$INSTDIR\obj2str.txi"
  Delete "$INSTDIR\obj2str.scm"
  Delete "$INSTDIR\null.scm"
  Delete "$INSTDIR\ncbi-dna.txi"
  Delete "$INSTDIR\ncbi-dna.scm"
  Delete "$INSTDIR\nbs-iscc.txt"
  Delete "$INSTDIR\mwsynrul.scm"
  Delete "$INSTDIR\mwexpand.scm"
  Delete "$INSTDIR\mwdenote.scm"
  Delete "$INSTDIR\mularg.scm"
  Delete "$INSTDIR\mulapply.scm"
  Delete "$INSTDIR\modular.txi"
  Delete "$INSTDIR\modular.scm"
  Delete "$INSTDIR\mklibcat.scm"
  Delete "$INSTDIR\mkclrnam.txi"
  Delete "$INSTDIR\mkclrnam.scm"
  Delete "$INSTDIR\minimize.txi"
  Delete "$INSTDIR\minimize.scm"
  Delete "$INSTDIR\mbe.scm"
  Delete "$INSTDIR\math-real.scm"
  Delete "$INSTDIR\math-integer.txi"
  Delete "$INSTDIR\math-integer.scm"
  Delete "$INSTDIR\matfile.txi"
  Delete "$INSTDIR\matfile.scm"
  Delete "$INSTDIR\manifest.txi"
  Delete "$INSTDIR\manifest.scm"
  Delete "$INSTDIR\Makefile"
  Delete "$INSTDIR\macwork.scm"
  Delete "$INSTDIR\macrotst.scm"
  Delete "$INSTDIR\logical.scm"
  Delete "$INSTDIR\linterp.txi"
  Delete "$INSTDIR\linterp.scm"
  Delete "$INSTDIR\lineio.txi"
  Delete "$INSTDIR\lineio.scm"
  Delete "$INSTDIR\limit.texi"
  Delete "$INSTDIR\limit.scm"
  Delete "$INSTDIR\indexes.texi"
  Delete "$INSTDIR\http-cgi.txi"
  Delete "$INSTDIR\http-cgi.scm"
  Delete "$INSTDIR\htmlform.txi"
  Delete "$INSTDIR\htmlform.scm"
  Delete "$INSTDIR\html4each.txi"
  Delete "$INSTDIR\html4each.scm"
  Delete "$INSTDIR\hashtab.txi"
  Delete "$INSTDIR\hashtab.scm"
  Delete "$INSTDIR\hash.scm"
  Delete "$INSTDIR\grapheps.txi"
  Delete "$INSTDIR\grapheps.scm"
  Delete "$INSTDIR\grapheps.ps"
  Delete "$INSTDIR\glob.txi"
  Delete "$INSTDIR\glob.scm"
  Delete "$INSTDIR\getparam.txi"
  Delete "$INSTDIR\getparam.scm"
  Delete "$INSTDIR\getopt.scm"
  Delete "$INSTDIR\genwrite.scm"
  Delete "$INSTDIR\formatst.scm"
  Delete "$INSTDIR\format.texi"
  Delete "$INSTDIR\format.scm"
  Delete "$INSTDIR\fluid-let.scm"
  Delete "$INSTDIR\fluidlet.scm"
  Delete "$INSTDIR\fdl.texi"
  Delete "$INSTDIR\FAQ"
  Delete "$INSTDIR\factor.txi"
  Delete "$INSTDIR\factor.scm"
  Delete "$INSTDIR\eval.scm"
  Delete "$INSTDIR\dynwind.scm"
  Delete "$INSTDIR\dynamic.scm"
  Delete "$INSTDIR\dwindtst.scm"
  Delete "$INSTDIR\dirs.txi"
  Delete "$INSTDIR\dirs.scm"
  Delete "$INSTDIR\differ.txi"
  Delete "$INSTDIR\differ.scm"
  Delete "$INSTDIR\dft.txi"
  Delete "$INSTDIR\dft.scm"
  Delete "$INSTDIR\determ.txi"
  Delete "$INSTDIR\determ.scm"
  Delete "$INSTDIR\defmacex.scm"
  Delete "$INSTDIR\debug.scm"
  Delete "$INSTDIR\dbutil.txi"
  Delete "$INSTDIR\dbutil.scm"
  Delete "$INSTDIR\dbsyn.scm"
  Delete "$INSTDIR\dbrowse.scm"
  Delete "$INSTDIR\dbinterp.scm"
  Delete "$INSTDIR\dbcom.scm"
  Delete "$INSTDIR\db2html.txi"
  Delete "$INSTDIR\db2html.scm"
  Delete "$INSTDIR\daylight.txi"
  Delete "$INSTDIR\daylight.scm"
  Delete "$INSTDIR\cvs.txi"
  Delete "$INSTDIR\cvs.scm"
  Delete "$INSTDIR\cring.scm"
  Delete "$INSTDIR\crc.scm"
  Delete "$INSTDIR\COPYING"
  Delete "$INSTDIR\comparse.txi"
  Delete "$INSTDIR\comparse.scm"
  Delete "$INSTDIR\comlist.scm"
  Delete "$INSTDIR\colorspc.scm"
  Delete "$INSTDIR\colornam.txi"
  Delete "$INSTDIR\colornam.scm"
  Delete "$INSTDIR\color.txi"
  Delete "$INSTDIR\color.scm"
  Delete "$INSTDIR\collectx.scm"
  Delete "$INSTDIR\collect.scm"
  Delete "$INSTDIR\coerce.txi"
  Delete "$INSTDIR\coerce.scm"
  Delete "$INSTDIR\cltime.scm"
  Delete "$INSTDIR\clrnamdb.scm"
  Delete "$INSTDIR\ciesid65.dat"
  Delete "$INSTDIR\ciesia.dat"
  Delete "$INSTDIR\cie1964.xyz"
  Delete "$INSTDIR\cie1931.xyz"
  Delete "$INSTDIR\charplot.scm"
  Delete "$INSTDIR\chap.txi"
  Delete "$INSTDIR\chap.scm"
  Delete "$INSTDIR\ChangeLog"
  Delete "$INSTDIR\bytenumb.txi"
  Delete "$INSTDIR\bytenumb.scm"
  Delete "$INSTDIR\byte.txi"
  Delete "$INSTDIR\byte.scm"
  Delete "$INSTDIR\break.scm"
  Delete "$INSTDIR\Bev2slib.scm"
  Delete "$INSTDIR\batch.scm"
  Delete "$INSTDIR\arraymap.txi"
  Delete "$INSTDIR\arraymap.scm"
  Delete "$INSTDIR\array.txi"
  Delete "$INSTDIR\array.scm"
  Delete "$INSTDIR\ANNOUNCE"
  Delete "$INSTDIR\alistab.scm"
  Delete "$INSTDIR\alist.txi"
  Delete "$INSTDIR\alist.scm"

  Delete "$SMPROGRAMS\$ICONS_GROUP\Uninstall.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\Website.lnk"
  Delete "$SMPROGRAMS\$ICONS_GROUP\SLIB Manual.lnk"

  RMDir "$SMPROGRAMS\$ICONS_GROUP"
  RMDir "$INSTDIR"

  ; remove Jaffer registry entries
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${SLIB_KEY}"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true

  # remove the slib environment variables
  Push ${SlibEnvVar}
  Call un.DeleteEnvStr

SectionEnd

; ----------------[ ENVIRONMENT MANIPULATION ]----------------

!ifndef WriteEnvStr_RegKey
  !ifdef ALL_USERS
    !define WriteEnvStr_RegKey 'HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"'
  !else
    !define WriteEnvStr_RegKey 'HKCU "Environment"'
  !endif
!endif

#
# WriteEnvStr - Writes an environment variable
# Note: Win9x systems requires reboot
#
# Example:
#  Push "HOMEDIR"           # name
#  Push "C:\New Home Dir\"  # value
#  Call WriteEnvStr
#
Function WriteEnvStr
  Exch $1 ; $1 has environment variable value
  Exch
  Exch $0 ; $0 has environment variable name
  Push $2

  Call IsNT
  Pop $2
  StrCmp $2 1 WriteEnvStr_NT
    ; Not on NT
    StrCpy $2 $WINDIR 2 ; Copy drive of windows (c:)
    FileOpen $2 "$2\autoexec.bat" a
    FileSeek $2 0 END
    FileWrite $2 "$\r$\nSET $0=$1$\r$\n"
    FileClose $2
    SetRebootFlag true
    Goto WriteEnvStr_done

  WriteEnvStr_NT:
      WriteRegExpandStr ${WriteEnvStr_RegKey} $0 $1
      SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000

  WriteEnvStr_done:
    Pop $2
    Pop $0
    Pop $1
FunctionEnd

#
# un.DeleteEnvStr - Removes an environment variable
# Note: Win9x systems requires reboot
#
# Example:
#  Push "HOMEDIR"           # name
#  Call un.DeleteEnvStr
#
Function un.DeleteEnvStr
  Exch $0 ; $0 now has the name of the variable
  Push $1
  Push $2
  Push $3
  Push $4
  Push $5

  Call un.IsNT
  Pop $1
  StrCmp $1 1 DeleteEnvStr_NT
    ; Not on NT
    StrCpy $1 $WINDIR 2
    FileOpen $1 "$1\autoexec.bat" r
    GetTempFileName $4
    FileOpen $2 $4 w
    StrCpy $0 "SET $0="
    SetRebootFlag true

    DeleteEnvStr_dosLoop:
      FileRead $1 $3
      StrLen $5 $0
      StrCpy $5 $3 $5
      StrCmp $5 $0 DeleteEnvStr_dosLoop
      StrCmp $5 "" DeleteEnvStr_dosLoopEnd
      FileWrite $2 $3
      Goto DeleteEnvStr_dosLoop

    DeleteEnvStr_dosLoopEnd:
      FileClose $2
      FileClose $1
      StrCpy $1 $WINDIR 2
      Delete "$1\autoexec.bat"
      CopyFiles /SILENT $4 "$1\autoexec.bat"
      Delete $4
      Goto DeleteEnvStr_done

  DeleteEnvStr_NT:
    DeleteRegValue ${WriteEnvStr_RegKey} $0
    SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000

  DeleteEnvStr_done:
    Pop $5
    Pop $4
    Pop $3
    Pop $2
    Pop $1
    Pop $0
FunctionEnd

; ----------------[ OS TYPE DETERMINATION ]----------------

#
# [un.]IsNT - Pushes 1 if running on NT, 0 if not
#
# Example:
#   Call IsNT
#   Pop $0
#   StrCmp $0 1 +3
#     MessageBox MB_OK "Not running on NT!"
#     Goto +2
#     MessageBox MB_OK "Running on NT!"
#
!macro IsNT UN
Function ${UN}IsNT
  Push $0
  ReadRegStr $0 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
  StrCmp $0 "" 0 IsNT_yes
  ; we are not NT.
  Pop $0
  Push 0
  Return

  IsNT_yes:
    ; NT!!!
    Pop $0
    Push 1
FunctionEnd
!macroend
!insertmacro IsNT ""
!insertmacro IsNT "un."
