---
title: "CLI"
linkTitle: "CLI"
weight: 1
---

Skaffold command-line interface provides the following commands:


End-to-end pipelines:

* [skaffold run](#skaffold-run) - to build & deploy once
* [skaffold dev](#skaffold-dev) - to trigger the watch loop build & deploy workflow with cleanup on exit
* [skaffold debug](#skaffold-debug) - to run a pipeline in debug mode

Pipeline building blocks for CI/CD:

* [skaffold build](#skaffold-build) - to just build and tag your image(s)
* [skaffold deploy](#skaffold-deploy) - to deploy the given image(s)
* [skaffold delete](#skaffold-delete) - to cleanup the deployed artifacts
* [skaffold render](#skaffold-render) - build and tag images, and output templated Kubernetes manifests

Getting started with a new project:

* [skaffold init](#skaffold-init) - to bootstrap Skaffold config
* [skaffold fix](#skaffold-fix) - to upgrade from

Other Commands:

* [skaffold help](#skaffold-help) - print help
* [skaffold version](#skaffold-version) - get Skaffold version
* [skaffold completion](#skaffold-completion) - setup tab completion for the CLI
* [skaffold config](#skaffold-config) - manage context specific parameters
* [skaffold credits](#skaffold-credits) - export third party notices to given path (./skaffold-credits by default)
* [skaffold diagnose](#skaffold-diagnose) - diagnostics of Skaffold works in your project
* [skaffold schema](#skaffold-schema) - list and print json schemas used to validate skaffold.yaml configuration


## Global flags

| Flag | Description |
|------- |---------------|
|`-h, --help`| Prints the HELP file for the current command.|
|`-v, --verbosity LOG-LEVEL` | Uses a specific log level. Available log levels are `info`, `warn`, `error`, `fatal`, `debug` and `trace`. Default value is `warn`.|


## Global environment variables

| Flag | Description |
|------- |---------------|
|`SKAFFOLD_UPDATE_CHECK`|Enables checking for latest version of the Skaffold binary. By default it's `true`. |


## Skaffold commands

<!--
******
To edit this file above edit index_header - the rest of the file is autogenerated by cmd/skaffold/man
******
-->

### skaffold



```


End-to-end pipelines:
  run               Run a pipeline
  dev               Run a pipeline in development mode
  debug             [beta] Run a pipeline in debug mode

Pipeline building blocks for CI/CD:
  build             Build the artifacts
  test              Run tests against your built application images
  deploy            Deploy pre-built artifacts
  delete            Delete the deployed application
  render            [alpha] Perform all image builds, and output rendered Kubernetes manifests
  apply             Apply hydrated manifests to a cluster

Getting started with a new project:
  init              [alpha] Generate configuration for deploying an application
  fix               Update old configuration to a newer schema version

Other Commands:
  completion        Output shell completion for the given shell (bash or zsh)
  config            Interact with the global skaffold config file (defaults to `$HOME/.skaffold/config`)
  credits           Export third party notices to given path (./skaffold-credits by default)
  diagnose          Run a diagnostic on Skaffold
  schema            List and print json schemas used to validate skaffold.yaml configuration
  survey            Opens a web browser to fill out the Skaffold survey
  version           Print the version information

Use "skaffold <command> --help" for more information about a given command.
Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_COLOR` (same as `--color`)
* `SKAFFOLD_INTERACTIVE` (same as `--interactive`)
* `SKAFFOLD_TIMESTAMPS` (same as `--timestamps`)
* `SKAFFOLD_UPDATE_CHECK` (same as `--update-check`)
* `SKAFFOLD_VERBOSITY` (same as `--verbosity`)

### skaffold apply

Apply hydrated manifests to a cluster

```


Examples:
  # Hydrate Kubernetes pod manifest first
  skaffold render --output rendered-pod.yaml

  # Then create resources on your cluster from that hydrated manifest
  skaffold apply rendered-pod.yaml

Options:
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Recreate Kubernetes resources if necessary for deployment, warning: might cause downtime!
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
  -n, --namespace='': Run deployments in the specified namespace
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)
      --status-check=true: Wait for deployed resources to stabilize
      --tail=false: Stream logs from deployed objects
      --v2=false: Next skaffold config (v2). Use kpt to render/hydrate and deploy manifests.

Usage:
  skaffold apply [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)
* `SKAFFOLD_STATUS_CHECK` (same as `--status-check`)
* `SKAFFOLD_TAIL` (same as `--tail`)
* `SKAFFOLD_V2` (same as `--v2`)

### skaffold build

Build the artifacts

```


Examples:
  # Build all the artifacts
  skaffold build

  # Build artifacts with a profile activated
  skaffold build -p <profile>

  # Build artifacts whose image name contains <db>
  skaffold build -b <db>

  # Quietly build artifacts and output the image names as json
  skaffold build -q > build_result.json

  # Build the artifacts and then deploy them
  skaffold build -q | skaffold deploy --build-artifacts -

  # Print the final image names
  skaffold build -q --dry-run

Options:
      --build-concurrency=-1: Number of concurrently running builds. Set to 0 to run all builds in parallel. Doesn't violate build order among dependencies.
  -b, --build-image=[]: Only build artifacts with image names that contain the given substring. Default is to build sources for all artifacts
      --cache-artifacts=true: Set to false to disable default caching of artifacts
      --cache-file='': Specify the location of the cache file (default $HOME/.skaffold/cache)
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --detect-minikube=true: Use heuristics to detect a minikube cluster
      --dry-run=false: Don't build images, just compute the tag for each artifact.
      --enable-rpc=false: Enable gRPC for exposing Skaffold events
      --event-log-file='': Save Skaffold events to the provided file after skaffold has finished executing, requires --enable-rpc=true
      --file-output='': Filename to write build images to
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --insecure-registry=[]: Target registries for built images which are not secure
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
      --mute-logs=[]: mute logs for specified stages in pipeline (build, deploy, status-check, none, all)
  -n, --namespace='': Run deployments in the specified namespace
  -o, --output={{json .}}: Used in conjunction with --quiet flag. Format output with go-template. For full struct documentation, see https://godoc.org/github.com/GoogleContainerTools/skaffold/cmd/skaffold/app/flags#BuildOutput
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --push=: Push the built images to the specified image repository.
  -q, --quiet=false: Suppress the build output and print image built on success. See --output to format output.
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --skip-tests=false: Whether to skip the tests after building
  -t, --tag='': The optional custom tag to use for images which overrides the current Tagger configuration
      --toot=false: Emit a terminal beep after the deploy is complete

Usage:
  skaffold build [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_BUILD_CONCURRENCY` (same as `--build-concurrency`)
* `SKAFFOLD_BUILD_IMAGE` (same as `--build-image`)
* `SKAFFOLD_CACHE_ARTIFACTS` (same as `--cache-artifacts`)
* `SKAFFOLD_CACHE_FILE` (same as `--cache-file`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_DETECT_MINIKUBE` (same as `--detect-minikube`)
* `SKAFFOLD_DRY_RUN` (same as `--dry-run`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_EVENT_LOG_FILE` (same as `--event-log-file`)
* `SKAFFOLD_FILE_OUTPUT` (same as `--file-output`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_INSECURE_REGISTRY` (same as `--insecure-registry`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_MUTE_LOGS` (same as `--mute-logs`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_OUTPUT` (same as `--output`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_PUSH` (same as `--push`)
* `SKAFFOLD_QUIET` (same as `--quiet`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_SKIP_TESTS` (same as `--skip-tests`)
* `SKAFFOLD_TAG` (same as `--tag`)
* `SKAFFOLD_TOOT` (same as `--toot`)

### skaffold completion

Output shell completion for the given shell (bash or zsh)

```


Usage:
  skaffold completion SHELL [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```

### skaffold config

Interact with the global skaffold config file (defaults to `$HOME/.skaffold/config`)

```


Available Commands:
  list        List all values set in the global Skaffold config
  set         Set a value in the global Skaffold config
  unset       Unset a value in the global Skaffold config

Use "skaffold <command> --help" for more information about a given command.


```

### skaffold config list

List all values set in the global Skaffold config

```


Options:
  -a, --all=false: Show values for all kubecontexts
  -c, --config='': Path to Skaffold config
  -k, --kube-context='': Kubectl context to set values against

Usage:
  skaffold config list [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_ALL` (same as `--all`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)

### skaffold config set

Set a value in the global Skaffold config

```


Examples:
  # Mark a registry as insecure
  skaffold config set insecure-registries <insecure1.io>

  # Globally set the default image repository
  skaffold config set default-repo <myrepo>

  # Disable pushing images for a given Kubernetes context
  skaffold config set --kube-context <mycluster> local-cluster true

Options:
  -c, --config='': Path to Skaffold config
  -g, --global=false: Set value for global config
  -k, --kube-context='': Kubectl context to set values against

Usage:
  skaffold config set [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_GLOBAL` (same as `--global`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)

### skaffold config unset

Unset a value in the global Skaffold config

```


Options:
  -c, --config='': Path to Skaffold config
  -g, --global=false: Set value for global config
  -k, --kube-context='': Kubectl context to set values against

Usage:
  skaffold config unset [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_GLOBAL` (same as `--global`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)

### skaffold credits

Export third party notices to given path (./skaffold-credits by default)

```


Examples:
  # export third party licenses to ~/skaffold-credits
  skaffold credits -d ~/skaffold-credits

Options:
  -d, --dir='./skaffold-credits': destination directory to place third party licenses

Usage:
  skaffold credits [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_DIR` (same as `--dir`)

### skaffold debug

[beta] Run a pipeline in debug mode

```


Examples:
  # Launch with port-forwarding
  skaffold debug --port-forward

Options:
      --assume-yes=false: If true, skaffold will skip yes/no confirmation from the user and default to yes
      --auto-build=false: When set to false, builds wait for API request instead of running automatically
      --auto-create-config=true: If true, skaffold will try to create a config for the user's run if it doesn't find one
      --auto-deploy=false: When set to false, deploys wait for API request instead of running automatically
      --auto-sync=false: When set to false, syncs wait for API request instead of running automatically
      --build-concurrency=-1: Number of concurrently running builds. Set to 0 to run all builds in parallel. Doesn't violate build order among dependencies.
      --cache-artifacts=true: Set to false to disable default caching of artifacts
      --cache-file='': Specify the location of the cache file (default $HOME/.skaffold/cache)
      --cleanup=true: Delete deployments after dev or debug mode is interrupted
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --detect-minikube=true: Use heuristics to detect a minikube cluster
      --enable-rpc=true: Enable gRPC for exposing Skaffold events
      --event-log-file='': Save Skaffold events to the provided file after skaffold has finished executing, requires --enable-rpc=true
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Recreate Kubernetes resources if necessary for deployment, warning: might cause downtime!
      --insecure-registry=[]: Target registries for built images which are not secure
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
      --mute-logs=[]: mute logs for specified stages in pipeline (build, deploy, status-check, none, all)
  -n, --namespace='': Run deployments in the specified namespace
      --no-prune=false: Skip removing images and containers built by Skaffold
      --no-prune-children=false: Skip removing layers reused by Skaffold
      --port-forward=user,debug: Port-forward exposes service ports and container ports within pods and other resources (off, user, services, debug, pods)
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --skip-tests=false: Whether to skip the tests after building
      --status-check=true: Wait for deployed resources to stabilize
  -t, --tag='': The optional custom tag to use for images which overrides the current Tagger configuration
      --tail=true: Stream logs from deployed objects
      --toot=false: Emit a terminal beep after the deploy is complete
      --trigger='notify': How is change detection triggered? (polling, notify, or manual)
      --v2=false: Next skaffold config (v2). Use kpt to render/hydrate and deploy manifests.
      --wait-for-deletions=true: Wait for pending deletions to complete before a deployment
      --wait-for-deletions-delay=2s: Delay between two checks for pending deletions
      --wait-for-deletions-max=1m0s: Max duration to wait for pending deletions
  -w, --watch-image=[]: Choose which artifacts to watch. Artifacts with image names that contain the expression will be watched only. Default is to watch sources for all artifacts
  -i, --watch-poll-interval=1000: Interval (in ms) between two checks for file changes

Usage:
  skaffold debug [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_ASSUME_YES` (same as `--assume-yes`)
* `SKAFFOLD_AUTO_BUILD` (same as `--auto-build`)
* `SKAFFOLD_AUTO_CREATE_CONFIG` (same as `--auto-create-config`)
* `SKAFFOLD_AUTO_DEPLOY` (same as `--auto-deploy`)
* `SKAFFOLD_AUTO_SYNC` (same as `--auto-sync`)
* `SKAFFOLD_BUILD_CONCURRENCY` (same as `--build-concurrency`)
* `SKAFFOLD_CACHE_ARTIFACTS` (same as `--cache-artifacts`)
* `SKAFFOLD_CACHE_FILE` (same as `--cache-file`)
* `SKAFFOLD_CLEANUP` (same as `--cleanup`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_DETECT_MINIKUBE` (same as `--detect-minikube`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_EVENT_LOG_FILE` (same as `--event-log-file`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_INSECURE_REGISTRY` (same as `--insecure-registry`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_MUTE_LOGS` (same as `--mute-logs`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_NO_PRUNE` (same as `--no-prune`)
* `SKAFFOLD_NO_PRUNE_CHILDREN` (same as `--no-prune-children`)
* `SKAFFOLD_PORT_FORWARD` (same as `--port-forward`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_SKIP_TESTS` (same as `--skip-tests`)
* `SKAFFOLD_STATUS_CHECK` (same as `--status-check`)
* `SKAFFOLD_TAG` (same as `--tag`)
* `SKAFFOLD_TAIL` (same as `--tail`)
* `SKAFFOLD_TOOT` (same as `--toot`)
* `SKAFFOLD_TRIGGER` (same as `--trigger`)
* `SKAFFOLD_V2` (same as `--v2`)
* `SKAFFOLD_WAIT_FOR_DELETIONS` (same as `--wait-for-deletions`)
* `SKAFFOLD_WAIT_FOR_DELETIONS_DELAY` (same as `--wait-for-deletions-delay`)
* `SKAFFOLD_WAIT_FOR_DELETIONS_MAX` (same as `--wait-for-deletions-max`)
* `SKAFFOLD_WATCH_IMAGE` (same as `--watch-image`)
* `SKAFFOLD_WATCH_POLL_INTERVAL` (same as `--watch-poll-interval`)

### skaffold delete

Delete the deployed application

```


Options:
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --detect-minikube=true: Use heuristics to detect a minikube cluster
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
  -n, --namespace='': Run deployments in the specified namespace
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)

Usage:
  skaffold delete [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_DETECT_MINIKUBE` (same as `--detect-minikube`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)

### skaffold deploy

Deploy pre-built artifacts

```


Examples:
  # Build the artifacts and collect the tags into a file
  skaffold build --file-output=tags.json

  # Deploy those tags
  skaffold deploy --build-artifacts=tags.json

  # Build the artifacts and then deploy them
  skaffold build -q | skaffold deploy --build-artifacts -

  # Deploy without first rendering the manifests
  skaffold deploy --skip-render

Options:
  -a, --build-artifacts=: File containing build result from a previous 'skaffold build --file-output'
      --build-concurrency=-1: Number of concurrently running builds. Set to 0 to run all builds in parallel. Doesn't violate build order among dependencies.
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --detect-minikube=true: Use heuristics to detect a minikube cluster
      --enable-rpc=false: Enable gRPC for exposing Skaffold events
      --event-log-file='': Save Skaffold events to the provided file after skaffold has finished executing, requires --enable-rpc=true
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Recreate Kubernetes resources if necessary for deployment, warning: might cause downtime!
  -i, --images=: A list of pre-built images to deploy
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
      --mute-logs=[]: mute logs for specified stages in pipeline (build, deploy, status-check, none, all)
  -n, --namespace='': Run deployments in the specified namespace
      --port-forward=off: Port-forward exposes service ports and container ports within pods and other resources (off, user, services, debug, pods)
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --skip-render=false: Don't render the manifests, just deploy them
      --status-check=true: Wait for deployed resources to stabilize
  -t, --tag='': The optional custom tag to use for images which overrides the current Tagger configuration
      --tail=false: Stream logs from deployed objects
      --toot=false: Emit a terminal beep after the deploy is complete
      --v2=false: Next skaffold config (v2). Use kpt to render/hydrate and deploy manifests.
      --wait-for-deletions=true: Wait for pending deletions to complete before a deployment
      --wait-for-deletions-delay=2s: Delay between two checks for pending deletions
      --wait-for-deletions-max=1m0s: Max duration to wait for pending deletions

Usage:
  skaffold deploy [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_BUILD_ARTIFACTS` (same as `--build-artifacts`)
* `SKAFFOLD_BUILD_CONCURRENCY` (same as `--build-concurrency`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_DETECT_MINIKUBE` (same as `--detect-minikube`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_EVENT_LOG_FILE` (same as `--event-log-file`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_IMAGES` (same as `--images`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_MUTE_LOGS` (same as `--mute-logs`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_PORT_FORWARD` (same as `--port-forward`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_SKIP_RENDER` (same as `--skip-render`)
* `SKAFFOLD_STATUS_CHECK` (same as `--status-check`)
* `SKAFFOLD_TAG` (same as `--tag`)
* `SKAFFOLD_TAIL` (same as `--tail`)
* `SKAFFOLD_TOOT` (same as `--toot`)
* `SKAFFOLD_V2` (same as `--v2`)
* `SKAFFOLD_WAIT_FOR_DELETIONS` (same as `--wait-for-deletions`)
* `SKAFFOLD_WAIT_FOR_DELETIONS_DELAY` (same as `--wait-for-deletions-delay`)
* `SKAFFOLD_WAIT_FOR_DELETIONS_MAX` (same as `--wait-for-deletions-max`)

### skaffold dev

Run a pipeline in development mode

```


Options:
      --assume-yes=false: If true, skaffold will skip yes/no confirmation from the user and default to yes
      --auto-build=true: When set to false, builds wait for API request instead of running automatically
      --auto-create-config=true: If true, skaffold will try to create a config for the user's run if it doesn't find one
      --auto-deploy=true: When set to false, deploys wait for API request instead of running automatically
      --auto-sync=true: When set to false, syncs wait for API request instead of running automatically
      --build-concurrency=-1: Number of concurrently running builds. Set to 0 to run all builds in parallel. Doesn't violate build order among dependencies.
      --cache-artifacts=true: Set to false to disable default caching of artifacts
      --cache-file='': Specify the location of the cache file (default $HOME/.skaffold/cache)
      --cleanup=true: Delete deployments after dev or debug mode is interrupted
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --detect-minikube=true: Use heuristics to detect a minikube cluster
      --digest-source='remote': Set to 'remote' to skip builds and resolve the digest of images by tag from the remote registry. Set to 'local' to build images locally and use digests from built images. Set to 'tag' to use tags directly from the build. Set to 'none' to use tags directly from the Kubernetes manifests.
      --enable-rpc=true: Enable gRPC for exposing Skaffold events
      --event-log-file='': Save Skaffold events to the provided file after skaffold has finished executing, requires --enable-rpc=true
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Recreate Kubernetes resources if necessary for deployment, warning: might cause downtime!
      --insecure-registry=[]: Target registries for built images which are not secure
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
      --mute-logs=[]: mute logs for specified stages in pipeline (build, deploy, status-check, none, all)
  -n, --namespace='': Run deployments in the specified namespace
      --no-prune=false: Skip removing images and containers built by Skaffold
      --no-prune-children=false: Skip removing layers reused by Skaffold
      --port-forward=user: Port-forward exposes service ports and container ports within pods and other resources (off, user, services, debug, pods)
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --skip-tests=false: Whether to skip the tests after building
      --status-check=true: Wait for deployed resources to stabilize
  -t, --tag='': The optional custom tag to use for images which overrides the current Tagger configuration
      --tail=true: Stream logs from deployed objects
      --toot=false: Emit a terminal beep after the deploy is complete
      --trigger='notify': How is change detection triggered? (polling, notify, or manual)
      --v2=false: Next skaffold config (v2). Use kpt to render/hydrate and deploy manifests.
      --wait-for-deletions=true: Wait for pending deletions to complete before a deployment
      --wait-for-deletions-delay=2s: Delay between two checks for pending deletions
      --wait-for-deletions-max=1m0s: Max duration to wait for pending deletions
  -w, --watch-image=[]: Choose which artifacts to watch. Artifacts with image names that contain the expression will be watched only. Default is to watch sources for all artifacts
  -i, --watch-poll-interval=1000: Interval (in ms) between two checks for file changes

Usage:
  skaffold dev [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_ASSUME_YES` (same as `--assume-yes`)
* `SKAFFOLD_AUTO_BUILD` (same as `--auto-build`)
* `SKAFFOLD_AUTO_CREATE_CONFIG` (same as `--auto-create-config`)
* `SKAFFOLD_AUTO_DEPLOY` (same as `--auto-deploy`)
* `SKAFFOLD_AUTO_SYNC` (same as `--auto-sync`)
* `SKAFFOLD_BUILD_CONCURRENCY` (same as `--build-concurrency`)
* `SKAFFOLD_CACHE_ARTIFACTS` (same as `--cache-artifacts`)
* `SKAFFOLD_CACHE_FILE` (same as `--cache-file`)
* `SKAFFOLD_CLEANUP` (same as `--cleanup`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_DETECT_MINIKUBE` (same as `--detect-minikube`)
* `SKAFFOLD_DIGEST_SOURCE` (same as `--digest-source`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_EVENT_LOG_FILE` (same as `--event-log-file`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_INSECURE_REGISTRY` (same as `--insecure-registry`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_MUTE_LOGS` (same as `--mute-logs`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_NO_PRUNE` (same as `--no-prune`)
* `SKAFFOLD_NO_PRUNE_CHILDREN` (same as `--no-prune-children`)
* `SKAFFOLD_PORT_FORWARD` (same as `--port-forward`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_SKIP_TESTS` (same as `--skip-tests`)
* `SKAFFOLD_STATUS_CHECK` (same as `--status-check`)
* `SKAFFOLD_TAG` (same as `--tag`)
* `SKAFFOLD_TAIL` (same as `--tail`)
* `SKAFFOLD_TOOT` (same as `--toot`)
* `SKAFFOLD_TRIGGER` (same as `--trigger`)
* `SKAFFOLD_V2` (same as `--v2`)
* `SKAFFOLD_WAIT_FOR_DELETIONS` (same as `--wait-for-deletions`)
* `SKAFFOLD_WAIT_FOR_DELETIONS_DELAY` (same as `--wait-for-deletions-delay`)
* `SKAFFOLD_WAIT_FOR_DELETIONS_MAX` (same as `--wait-for-deletions-max`)
* `SKAFFOLD_WATCH_IMAGE` (same as `--watch-image`)
* `SKAFFOLD_WATCH_POLL_INTERVAL` (same as `--watch-poll-interval`)

### skaffold diagnose

Run a diagnostic on Skaffold

```


Examples:
  # Search for configuration issues and print the effective configuration
  skaffold diagnose

  # Print the effective skaffold.yaml configuration for given profile
  skaffold diagnose --yaml-only --profile PROFILE

Options:
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)
      --yaml-only=false: Only prints the effective skaffold.yaml configuration

Usage:
  skaffold diagnose [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)
* `SKAFFOLD_YAML_ONLY` (same as `--yaml-only`)

### skaffold fix

Update old configuration to a newer schema version

```


Examples:
  # Update "skaffold.yaml" in the current folder to the latest version
  skaffold fix

  # Update "skaffold.yaml" in the current folder to version "skaffold/v1"
  skaffold fix --version skaffold/v1

Options:
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
      --overwrite=false: Overwrite original config with fixed config
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)
      --version='skaffold/v2beta16': Target schema version to upgrade to

Usage:
  skaffold fix [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_OVERWRITE` (same as `--overwrite`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)
* `SKAFFOLD_VERSION` (same as `--version`)

### skaffold init

[alpha] Generate configuration for deploying an application

```


Options:
      --analyze=false: Print all discoverable Dockerfiles and images in JSON format to stdout
  -a, --artifact=[]: '='-delimited Dockerfile/image pair, or JSON string, to generate build artifact
(example: --artifact='{"builder":"Docker","payload":{"path":"/web/Dockerfile.web"},"image":"gcr.io/web-project/image"}')
      --compose-file='': Initialize from a docker-compose file
      --default-kustomization='': Default Kustomization overlay path (others will be added as profiles)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Force the generation of the Skaffold config
      --generate-manifests=false: Allows skaffold to try and generate basic kubernetes resources to get your project started
  -k, --kubernetes-manifest=[]: A path or a glob pattern to kubernetes manifests (can be non-existent) to be added to the kubectl deployer (overrides detection of kubernetes manifests). Repeat the flag for multiple entries. E.g.: skaffold init -k pod.yaml -k k8s/*.yml
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)
      --skip-build=false: Skip generating build artifacts in Skaffold config

Usage:
  skaffold init [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_ANALYZE` (same as `--analyze`)
* `SKAFFOLD_ARTIFACT` (same as `--artifact`)
* `SKAFFOLD_COMPOSE_FILE` (same as `--compose-file`)
* `SKAFFOLD_DEFAULT_KUSTOMIZATION` (same as `--default-kustomization`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_GENERATE_MANIFESTS` (same as `--generate-manifests`)
* `SKAFFOLD_KUBERNETES_MANIFEST` (same as `--kubernetes-manifest`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)
* `SKAFFOLD_SKIP_BUILD` (same as `--skip-build`)

### skaffold options



```
The following options can be passed to any command:

      --color=34: Specify the default output color in ANSI escape codes
      --interactive=true: Allow user prompts for more information
      --timestamps=false: Print timestamps in logs.
      --update-check=true: Check for a more recent version of Skaffold
  -v, --verbosity='warning': Log level (debug, info, warn, error, fatal, panic)


```

### skaffold render

[alpha] Perform all image builds, and output rendered Kubernetes manifests

```


Examples:
  # Hydrate Kubernetes manifests without building the images, using digest resolved from tag in remote registry 
  skaffold render --digest-source=remote

Options:
  -a, --build-artifacts=: File containing build result from a previous 'skaffold build --file-output'
      --cache-artifacts=true: Set to false to disable default caching of artifacts
  -d, --default-repo='': Default repository value (overrides global config)
      --digest-source='remote': Set to 'remote' to skip builds and resolve the digest of images by tag from the remote registry. Set to 'local' to build images locally and use digests from built images. Set to 'tag' to use tags directly from the build. Set to 'none' to use tags directly from the Kubernetes manifests.
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
      --loud=false: Show the build logs and output
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
  -n, --namespace='': Run deployments in the specified namespace
      --offline=false: Do not connect to Kubernetes API server for manifest creation and validation. This is helpful when no Kubernetes cluster is available (e.g. GitOps model). No metadata.namespace attribute is injected in this case - the manifest content does not get changed.
  -o, --output='': file to write rendered manifests to
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)

Usage:
  skaffold render [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_BUILD_ARTIFACTS` (same as `--build-artifacts`)
* `SKAFFOLD_CACHE_ARTIFACTS` (same as `--cache-artifacts`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_DIGEST_SOURCE` (same as `--digest-source`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_LOUD` (same as `--loud`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_OFFLINE` (same as `--offline`)
* `SKAFFOLD_OUTPUT` (same as `--output`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)

### skaffold run

Run a pipeline

```


Examples:
  # Build, test, deploy and tail the logs
  skaffold run --tail

  # Run with a given profile
  skaffold run -p <profile>

Options:
      --assume-yes=false: If true, skaffold will skip yes/no confirmation from the user and default to yes
      --auto-create-config=true: If true, skaffold will try to create a config for the user's run if it doesn't find one
      --build-concurrency=-1: Number of concurrently running builds. Set to 0 to run all builds in parallel. Doesn't violate build order among dependencies.
  -b, --build-image=[]: Only build artifacts with image names that contain the given substring. Default is to build sources for all artifacts
      --cache-artifacts=true: Set to false to disable default caching of artifacts
      --cache-file='': Specify the location of the cache file (default $HOME/.skaffold/cache)
      --cleanup=true: Delete deployments after dev or debug mode is interrupted
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --detect-minikube=true: Use heuristics to detect a minikube cluster
      --digest-source='remote': Set to 'remote' to skip builds and resolve the digest of images by tag from the remote registry. Set to 'local' to build images locally and use digests from built images. Set to 'tag' to use tags directly from the build. Set to 'none' to use tags directly from the Kubernetes manifests.
      --enable-rpc=false: Enable gRPC for exposing Skaffold events
      --event-log-file='': Save Skaffold events to the provided file after skaffold has finished executing, requires --enable-rpc=true
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Recreate Kubernetes resources if necessary for deployment, warning: might cause downtime!
      --insecure-registry=[]: Target registries for built images which are not secure
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
      --mute-logs=[]: mute logs for specified stages in pipeline (build, deploy, status-check, none, all)
  -n, --namespace='': Run deployments in the specified namespace
      --no-prune=false: Skip removing images and containers built by Skaffold
      --no-prune-children=false: Skip removing layers reused by Skaffold
      --port-forward=off: Port-forward exposes service ports and container ports within pods and other resources (off, user, services, debug, pods)
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --skip-tests=false: Whether to skip the tests after building
      --status-check=true: Wait for deployed resources to stabilize
  -t, --tag='': The optional custom tag to use for images which overrides the current Tagger configuration
      --tail=false: Stream logs from deployed objects
      --toot=false: Emit a terminal beep after the deploy is complete
      --v2=false: Next skaffold config (v2). Use kpt to render/hydrate and deploy manifests.
      --wait-for-deletions=true: Wait for pending deletions to complete before a deployment
      --wait-for-deletions-delay=2s: Delay between two checks for pending deletions
      --wait-for-deletions-max=1m0s: Max duration to wait for pending deletions

Usage:
  skaffold run [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_ASSUME_YES` (same as `--assume-yes`)
* `SKAFFOLD_AUTO_CREATE_CONFIG` (same as `--auto-create-config`)
* `SKAFFOLD_BUILD_CONCURRENCY` (same as `--build-concurrency`)
* `SKAFFOLD_BUILD_IMAGE` (same as `--build-image`)
* `SKAFFOLD_CACHE_ARTIFACTS` (same as `--cache-artifacts`)
* `SKAFFOLD_CACHE_FILE` (same as `--cache-file`)
* `SKAFFOLD_CLEANUP` (same as `--cleanup`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_DETECT_MINIKUBE` (same as `--detect-minikube`)
* `SKAFFOLD_DIGEST_SOURCE` (same as `--digest-source`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_EVENT_LOG_FILE` (same as `--event-log-file`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_INSECURE_REGISTRY` (same as `--insecure-registry`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_MUTE_LOGS` (same as `--mute-logs`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_NO_PRUNE` (same as `--no-prune`)
* `SKAFFOLD_NO_PRUNE_CHILDREN` (same as `--no-prune-children`)
* `SKAFFOLD_PORT_FORWARD` (same as `--port-forward`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_SKIP_TESTS` (same as `--skip-tests`)
* `SKAFFOLD_STATUS_CHECK` (same as `--status-check`)
* `SKAFFOLD_TAG` (same as `--tag`)
* `SKAFFOLD_TAIL` (same as `--tail`)
* `SKAFFOLD_TOOT` (same as `--toot`)
* `SKAFFOLD_V2` (same as `--v2`)
* `SKAFFOLD_WAIT_FOR_DELETIONS` (same as `--wait-for-deletions`)
* `SKAFFOLD_WAIT_FOR_DELETIONS_DELAY` (same as `--wait-for-deletions-delay`)
* `SKAFFOLD_WAIT_FOR_DELETIONS_MAX` (same as `--wait-for-deletions-max`)

### skaffold schema

List and print json schemas used to validate skaffold.yaml configuration

```


Available Commands:
  get         Print a given skaffold.yaml's json schema
  list        List skaffold.yaml's json schema versions

Use "skaffold <command> --help" for more information about a given command.


```

### skaffold schema get

Print a given skaffold.yaml's json schema

```


Examples:
  # Print the schema in version `skaffold/v1`
  skaffold schema get skaffold/v1

Usage:
  skaffold schema get [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```

### skaffold schema list

List skaffold.yaml's json schema versions

```


Examples:
  # List all the versions
  skaffold schema list

  # List all the versions, in json format
  skaffold schema list -o json

Options:
  -o, --output='plain': Type of output: `plain` or `json`.

Usage:
  skaffold schema list [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_OUTPUT` (same as `--output`)

### skaffold survey

Opens a web browser to fill out the Skaffold survey

```


Usage:
  skaffold survey [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```

### skaffold test

Run tests against your built application images

```


Examples:
  # Build the artifacts and collect the tags into a file
  skaffold build --file-output=tags.json

  # Run test against images previously built by Skaffold into a 'tags.json' file
  skaffold test --build-artifacts=tags.json

Options:
  -a, --build-artifacts=: File containing build result from a previous 'skaffold build --file-output'
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
  -m, --module=[]: Filter Skaffold configs to only the provided named modules
      --remote-cache-dir='': Specify the location of the git repositories cache (default $HOME/.skaffold/repos)

Usage:
  skaffold test [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_BUILD_ARTIFACTS` (same as `--build-artifacts`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_MODULE` (same as `--module`)
* `SKAFFOLD_REMOTE_CACHE_DIR` (same as `--remote-cache-dir`)

### skaffold version

Print the version information

```


Options:
  -o, --output={{.Version}}
: Format output with go-template. For full struct documentation, see https://godoc.org/github.com/GoogleContainerTools/skaffold/pkg/skaffold/version#Info

Usage:
  skaffold version [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_OUTPUT` (same as `--output`)
