---
title: "CLI"
linkTitle: "CLI"
weight: 1
---

Skaffold command-line interface provides the following commands:


End-to-end pipelines:

* [skaffold run](#skaffold-run) - to build & deploy once
* [skaffold dev](#skaffold-dev) - to trigger the watch loop build & deploy workflow with cleanup on exit
* [skaffold debug](#skaffold-debug) - to run a pipeline in debug mode

Pipeline building blocks for CI/CD:

* [skaffold build](#skaffold-build) - to just build and tag your image(s)
* [skaffold deploy](#skaffold-deploy) - to deploy the given image(s)
* [skaffold delete](#skaffold-delete) - to cleanup the deployed artifacts
* [skaffold render](#skaffold-render) - build and tag images, and output templated Kubernetes manifests

Getting started with a new project:

* [skaffold init](#skaffold-init) - to bootstrap Skaffold config
* [skaffold fix](#skaffold-fix) - to upgrade from

Other Commands:

* [skaffold help](#skaffold-help) - print help
* [skaffold version](#skaffold-version) - get Skaffold version
* [skaffold completion](#skaffold-completion) - setup tab completion for the CLI
* [skaffold config](#skaffold-config) - manage context specific parameters
* [skaffold credits](#skaffold-credits) - export third party notices to given path (./skaffold-credits by default)
* [skaffold diagnose](#skaffold-diagnose) - diagnostics of Skaffold works in your project
* [skaffold schema](#skaffold-schema) - list and print json schemas used to validate skaffold.yaml configuration


## Global flags

| Flag | Description |
|------- |---------------|
|`-h, --help`| Prints the HELP file for the current command.|
|`-v, --verbosity LOG-LEVEL` | Uses a specific log level. Available log levels are `info`, `warn`, `error`, `fatal`, `debug` and `trace`. Default value is `warn`.|


## Global environment variables

| Flag | Description |
|------- |---------------|
|`SKAFFOLD_UPDATE_CHECK`|Enables checking for latest version of the Skaffold binary. By default it's `true`. |


## Skaffold commands

<!--
******
To edit this file above edit index_header - the rest of the file is autogenerated by cmd/skaffold/man
******
-->

### skaffold



```


End-to-end pipelines:
  run               Run a pipeline
  dev               Run a pipeline in development mode
  debug             [beta] Run a pipeline in debug mode

Pipeline building blocks for CI/CD:
  build             Build the artifacts
  deploy            Deploy pre-built artifacts
  delete            Delete the deployed application
  render            [alpha] Perform all image builds, and output rendered Kubernetes manifests

Getting started with a new project:
  init              [alpha] Generate configuration for deploying an application
  fix               Update old configuration to a newer schema version

Other Commands:
  completion        Output shell completion for the given shell (bash or zsh)
  config            Interact with the Skaffold configuration
  credits           Export third party notices to given path (./skaffold-credits by default)
  diagnose          Run a diagnostic on Skaffold
  schema            List and print json schemas used to validate skaffold.yaml configuration
  survey            Show Skaffold survey url
  version           Print the version information

Use "skaffold <command> --help" for more information about a given command.
Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_COLOR` (same as `--color`)
* `SKAFFOLD_VERBOSITY` (same as `--verbosity`)

### skaffold build

Build the artifacts

```


Examples:
  # Build all the artifacts
  skaffold build

  # Build artifacts with a profile activated
  skaffold build -p <profile>

  # Build artifacts whose image name contains <db>
  skaffold build -b <db>

  # Quietly build artifacts and output the image names as json
  skaffold build -q > build_result.json

  # Build the artifacts and then deploy them
  skaffold build -q | skaffold deploy --build-artifacts -

  # Print the final image names
  skaffold build -q --dry-run

Options:
  -b, --build-image=[]: Choose which artifacts to build. Artifacts with image names that contain the expression will be built only. Default is to build sources for all artifacts
      --cache-artifacts=true: Set to false to disable default caching of artifacts
      --cache-file='': Specify the location of the cache file (default $HOME/.skaffold/cache)
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --dry-run=false: Don't build images, just compute the tag for each artifact.
      --enable-rpc=false: Enable gRPC for exposing Skaffold events (true by default for `skaffold dev`)
      --file-output='': Filename to write build images to
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --insecure-registry=[]: Target registries for built images which are not secure
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -n, --namespace='': Run deployments in the specified namespace
  -o, --output={{json .}}: Used in conjunction with --quiet flag. Format output with go-template. For full struct documentation, see https://godoc.org/github.com/GoogleContainerTools/skaffold/cmd/skaffold/app/flags#BuildOutput
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
  -q, --quiet=false: Suppress the build output and print image built on success. See --output to format output.
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --skip-tests=false: Whether to skip the tests after building
  -t, --tag='': The optional custom tag to use for images which overrides the current Tagger configuration
      --toot=false: Emit a terminal beep after the deploy is complete

Usage:
  skaffold build [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_BUILD_IMAGE` (same as `--build-image`)
* `SKAFFOLD_CACHE_ARTIFACTS` (same as `--cache-artifacts`)
* `SKAFFOLD_CACHE_FILE` (same as `--cache-file`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_DRY_RUN` (same as `--dry-run`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_FILE_OUTPUT` (same as `--file-output`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_INSECURE_REGISTRY` (same as `--insecure-registry`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_OUTPUT` (same as `--output`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_QUIET` (same as `--quiet`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_SKIP_TESTS` (same as `--skip-tests`)
* `SKAFFOLD_TAG` (same as `--tag`)
* `SKAFFOLD_TOOT` (same as `--toot`)

### skaffold completion

Output shell completion for the given shell (bash or zsh)

```


Usage:
  skaffold completion SHELL [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```

### skaffold config

Interact with the Skaffold configuration

```


Available Commands:
  list        List all values set in the global Skaffold config
  set         Set a value in the global Skaffold config
  unset       Unset a value in the global Skaffold config

Use "skaffold <command> --help" for more information about a given command.


```

### skaffold config list

List all values set in the global Skaffold config

```


Options:
  -a, --all=false: Show values for all kubecontexts
  -c, --config='': Path to Skaffold config
  -k, --kube-context='': Kubectl context to set values against

Usage:
  skaffold config list [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_ALL` (same as `--all`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)

### skaffold config set

Set a value in the global Skaffold config

```


Examples:
  # Mark a registry as insecure
  skaffold config set insecure-registries <insecure1.io>

  # Globally set the default image repository
  skaffold config set default-repo <myrepo>

  # Disable pushing images for a given Kubernetes context
  skaffold config set --kube-context <mycluster> local-cluster true

Options:
  -c, --config='': Path to Skaffold config
  -g, --global=false: Set value for global config
  -k, --kube-context='': Kubectl context to set values against

Usage:
  skaffold config set [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_GLOBAL` (same as `--global`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)

### skaffold config unset

Unset a value in the global Skaffold config

```


Options:
  -c, --config='': Path to Skaffold config
  -g, --global=false: Set value for global config
  -k, --kube-context='': Kubectl context to set values against

Usage:
  skaffold config unset [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_GLOBAL` (same as `--global`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)

### skaffold credits

Export third party notices to given path (./skaffold-credits by default)

```


Examples:
  # export third party licenses to ~/skaffold-credits
  skaffold credits -d ~/skaffold-credits

Options:
  -d, --dir='./skaffold-credits': destination directory to place third party licenses

Usage:
  skaffold credits [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_DIR` (same as `--dir`)

### skaffold debug

[beta] Run a pipeline in debug mode

```


Options:
      --cache-artifacts=true: Set to false to disable default caching of artifacts
      --cache-file='': Specify the location of the cache file (default $HOME/.skaffold/cache)
      --cleanup=true: Delete deployments after dev or debug mode is interrupted
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --enable-rpc=false: Enable gRPC for exposing Skaffold events (true by default for `skaffold dev`)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Recreate Kubernetes resources if necessary for deployment, warning: might cause downtime! (true by default for `skaffold dev`)
      --insecure-registry=[]: Target registries for built images which are not secure
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
  -n, --namespace='': Run deployments in the specified namespace
      --no-prune=false: Skip removing images and containers built by Skaffold
      --no-prune-children=false: Skip removing layers reused by Skaffold
      --port-forward=false: Port-forward exposed container ports within pods
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --skip-tests=false: Whether to skip the tests after building
      --status-check=true: Wait for deployed resources to stabilize
  -t, --tag='': The optional custom tag to use for images which overrides the current Tagger configuration
      --tail=false: Stream logs from deployed objects (true by default for `skaffold dev` and `skaffold debug`)
      --toot=false: Emit a terminal beep after the deploy is complete

Usage:
  skaffold debug [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CACHE_ARTIFACTS` (same as `--cache-artifacts`)
* `SKAFFOLD_CACHE_FILE` (same as `--cache-file`)
* `SKAFFOLD_CLEANUP` (same as `--cleanup`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_INSECURE_REGISTRY` (same as `--insecure-registry`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_NO_PRUNE` (same as `--no-prune`)
* `SKAFFOLD_NO_PRUNE_CHILDREN` (same as `--no-prune-children`)
* `SKAFFOLD_PORT_FORWARD` (same as `--port-forward`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_SKIP_TESTS` (same as `--skip-tests`)
* `SKAFFOLD_STATUS_CHECK` (same as `--status-check`)
* `SKAFFOLD_TAG` (same as `--tag`)
* `SKAFFOLD_TAIL` (same as `--tail`)
* `SKAFFOLD_TOOT` (same as `--toot`)

### skaffold delete

Delete the deployed application

```


Options:
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -n, --namespace='': Run deployments in the specified namespace
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation

Usage:
  skaffold delete [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)

### skaffold deploy

Deploy pre-built artifacts

```


Examples:
  # Build the artifacts and collect the tags into a file
  skaffold build --file-output=tags.json

  # Deploy those tags
  skaffold deploy --build-artifacts=tags.json

  # Build the artifacts and then deploy them
  skaffold build -q | skaffold deploy --build-artifacts -

Options:
  -a, --build-artifacts=: Filepath containing build output.
E.g. build.out created by running skaffold build --quiet -o "{{json .}}" > build.out
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --enable-rpc=false: Enable gRPC for exposing Skaffold events (true by default for `skaffold dev`)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Recreate Kubernetes resources if necessary for deployment, warning: might cause downtime! (true by default for `skaffold dev`)
  -i, --images=: A list of pre-built images to deploy
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
  -n, --namespace='': Run deployments in the specified namespace
      --port-forward=false: Port-forward exposed container ports within pods
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --status-check=true: Wait for deployed resources to stabilize
      --tail=false: Stream logs from deployed objects (true by default for `skaffold dev` and `skaffold debug`)
      --toot=false: Emit a terminal beep after the deploy is complete

Usage:
  skaffold deploy [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_BUILD_ARTIFACTS` (same as `--build-artifacts`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_IMAGES` (same as `--images`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_PORT_FORWARD` (same as `--port-forward`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_STATUS_CHECK` (same as `--status-check`)
* `SKAFFOLD_TAIL` (same as `--tail`)
* `SKAFFOLD_TOOT` (same as `--toot`)

### skaffold dev

Run a pipeline in development mode

```


Options:
      --cache-artifacts=true: Set to false to disable default caching of artifacts
      --cache-file='': Specify the location of the cache file (default $HOME/.skaffold/cache)
      --cleanup=true: Delete deployments after dev or debug mode is interrupted
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --enable-rpc=false: Enable gRPC for exposing Skaffold events (true by default for `skaffold dev`)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Recreate Kubernetes resources if necessary for deployment, warning: might cause downtime! (true by default for `skaffold dev`)
      --insecure-registry=[]: Target registries for built images which are not secure
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
  -n, --namespace='': Run deployments in the specified namespace
      --no-prune=false: Skip removing images and containers built by Skaffold
      --no-prune-children=false: Skip removing layers reused by Skaffold
      --port-forward=false: Port-forward exposed container ports within pods
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --render-only=false: Print rendered Kubernetes manifests instead of deploying them
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --skip-tests=false: Whether to skip the tests after building
      --status-check=true: Wait for deployed resources to stabilize
  -t, --tag='': The optional custom tag to use for images which overrides the current Tagger configuration
      --tail=false: Stream logs from deployed objects (true by default for `skaffold dev` and `skaffold debug`)
      --toot=false: Emit a terminal beep after the deploy is complete
      --trigger='notify': How is change detection triggered? (polling, notify, or manual)
  -w, --watch-image=[]: Choose which artifacts to watch. Artifacts with image names that contain the expression will be watched only. Default is to watch sources for all artifacts
  -i, --watch-poll-interval=1000: Interval (in ms) between two checks for file changes

Usage:
  skaffold dev [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CACHE_ARTIFACTS` (same as `--cache-artifacts`)
* `SKAFFOLD_CACHE_FILE` (same as `--cache-file`)
* `SKAFFOLD_CLEANUP` (same as `--cleanup`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_INSECURE_REGISTRY` (same as `--insecure-registry`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_NO_PRUNE` (same as `--no-prune`)
* `SKAFFOLD_NO_PRUNE_CHILDREN` (same as `--no-prune-children`)
* `SKAFFOLD_PORT_FORWARD` (same as `--port-forward`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_RENDER_ONLY` (same as `--render-only`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_SKIP_TESTS` (same as `--skip-tests`)
* `SKAFFOLD_STATUS_CHECK` (same as `--status-check`)
* `SKAFFOLD_TAG` (same as `--tag`)
* `SKAFFOLD_TAIL` (same as `--tail`)
* `SKAFFOLD_TOOT` (same as `--toot`)
* `SKAFFOLD_TRIGGER` (same as `--trigger`)
* `SKAFFOLD_WATCH_IMAGE` (same as `--watch-image`)
* `SKAFFOLD_WATCH_POLL_INTERVAL` (same as `--watch-poll-interval`)

### skaffold diagnose

Run a diagnostic on Skaffold

```


Examples:
  # Search for configuration issues and print the effective configuration
  skaffold diagnose

  # Print the effective skaffold.yaml configuration for given profile
  skaffold diagnose --yaml-only --profile PROFILE

Options:
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --yaml-only=false: Only prints the effective skaffold.yaml configuration

Usage:
  skaffold diagnose [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_YAML_ONLY` (same as `--yaml-only`)

### skaffold fix

Update old configuration to a newer schema version

```


Examples:
  # Update "skaffold.yaml" in the current folder to the latest version
  skaffold fix

  # Update "skaffold.yaml" in the current folder to version "skaffold/v1"
  skaffold fix --version skaffold/v1

Options:
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --overwrite=false: Overwrite original config with fixed config
      --version='skaffold/v2beta4': Target schema version to upgrade to

Usage:
  skaffold fix [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_OVERWRITE` (same as `--overwrite`)
* `SKAFFOLD_VERSION` (same as `--version`)

### skaffold init

[alpha] Generate configuration for deploying an application

```


Options:
      --analyze=false: Print all discoverable Dockerfiles and images in JSON format to stdout
  -a, --artifact=[]: '='-delimited Dockerfile/image pair, or JSON string, to generate build artifact
(example: --artifact='{"builder":"Docker","payload":{"path":"/web/Dockerfile.web"},"image":"gcr.io/web-project/image"}')
      --compose-file='': Initialize from a docker-compose file
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Force the generation of the Skaffold config
  -k, --kubernetes-manifest=[]: a path or a glob pattern to kubernetes manifests (can be non-existent) to be added to the kubectl deployer (overrides detection of kubernetes manifests). Repeat the flag for multiple entries. E.g.: skaffold init -k pod.yaml -k k8s/*.yml
      --skip-build=false: Skip generating build artifacts in Skaffold config

Usage:
  skaffold init [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_ANALYZE` (same as `--analyze`)
* `SKAFFOLD_ARTIFACT` (same as `--artifact`)
* `SKAFFOLD_COMPOSE_FILE` (same as `--compose-file`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_KUBERNETES_MANIFEST` (same as `--kubernetes-manifest`)
* `SKAFFOLD_SKIP_BUILD` (same as `--skip-build`)

### skaffold options



```
The following options can be passed to any command:

      --color=34: Specify the default output color in ANSI escape codes
  -v, --verbosity='warning': Log level (debug, info, warn, error, fatal, panic)


```

### skaffold render

[alpha] Perform all image builds, and output rendered Kubernetes manifests

```


Options:
  -d, --default-repo='': Default repository value (overrides global config)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
      --loud=false: Show the build logs and output
  -n, --namespace='': Run deployments in the specified namespace
      --output='': file to write rendered manifests to
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation

Usage:
  skaffold render [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_LOUD` (same as `--loud`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_OUTPUT` (same as `--output`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)

### skaffold run

Run a pipeline

```


Examples:
  # Build, test, deploy and tail the logs
  skaffold run --tail

  # Run with a given profile
  skaffold run -p <profile>

Options:
      --cache-artifacts=true: Set to false to disable default caching of artifacts
      --cache-file='': Specify the location of the cache file (default $HOME/.skaffold/cache)
      --cleanup=true: Delete deployments after dev or debug mode is interrupted
  -c, --config='': File for global configurations (defaults to $HOME/.skaffold/config)
  -d, --default-repo='': Default repository value (overrides global config)
      --enable-rpc=false: Enable gRPC for exposing Skaffold events (true by default for `skaffold dev`)
  -f, --filename='skaffold.yaml': Path or URL to the Skaffold config file
      --force=false: Recreate Kubernetes resources if necessary for deployment, warning: might cause downtime! (true by default for `skaffold dev`)
      --insecure-registry=[]: Target registries for built images which are not secure
      --kube-context='': Deploy to this Kubernetes context
      --kubeconfig='': Path to the kubeconfig file to use for CLI requests.
  -l, --label=[]: Add custom labels to deployed objects. Set multiple times for multiple labels
  -n, --namespace='': Run deployments in the specified namespace
      --no-prune=false: Skip removing images and containers built by Skaffold
      --no-prune-children=false: Skip removing layers reused by Skaffold
      --port-forward=false: Port-forward exposed container ports within pods
  -p, --profile=[]: Activate profiles by name (prefixed with `-` to disable a profile)
      --profile-auto-activation=true: Set to false to disable profile auto activation
      --render-only=false: Print rendered Kubernetes manifests instead of deploying them
      --rpc-http-port=50052: tcp port to expose event REST API over HTTP
      --rpc-port=50051: tcp port to expose event API
      --skip-tests=false: Whether to skip the tests after building
      --status-check=true: Wait for deployed resources to stabilize
  -t, --tag='': The optional custom tag to use for images which overrides the current Tagger configuration
      --tail=false: Stream logs from deployed objects (true by default for `skaffold dev` and `skaffold debug`)
      --toot=false: Emit a terminal beep after the deploy is complete

Usage:
  skaffold run [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_CACHE_ARTIFACTS` (same as `--cache-artifacts`)
* `SKAFFOLD_CACHE_FILE` (same as `--cache-file`)
* `SKAFFOLD_CLEANUP` (same as `--cleanup`)
* `SKAFFOLD_CONFIG` (same as `--config`)
* `SKAFFOLD_DEFAULT_REPO` (same as `--default-repo`)
* `SKAFFOLD_ENABLE_RPC` (same as `--enable-rpc`)
* `SKAFFOLD_FILENAME` (same as `--filename`)
* `SKAFFOLD_FORCE` (same as `--force`)
* `SKAFFOLD_INSECURE_REGISTRY` (same as `--insecure-registry`)
* `SKAFFOLD_KUBE_CONTEXT` (same as `--kube-context`)
* `SKAFFOLD_KUBECONFIG` (same as `--kubeconfig`)
* `SKAFFOLD_LABEL` (same as `--label`)
* `SKAFFOLD_NAMESPACE` (same as `--namespace`)
* `SKAFFOLD_NO_PRUNE` (same as `--no-prune`)
* `SKAFFOLD_NO_PRUNE_CHILDREN` (same as `--no-prune-children`)
* `SKAFFOLD_PORT_FORWARD` (same as `--port-forward`)
* `SKAFFOLD_PROFILE` (same as `--profile`)
* `SKAFFOLD_PROFILE_AUTO_ACTIVATION` (same as `--profile-auto-activation`)
* `SKAFFOLD_RENDER_ONLY` (same as `--render-only`)
* `SKAFFOLD_RPC_HTTP_PORT` (same as `--rpc-http-port`)
* `SKAFFOLD_RPC_PORT` (same as `--rpc-port`)
* `SKAFFOLD_SKIP_TESTS` (same as `--skip-tests`)
* `SKAFFOLD_STATUS_CHECK` (same as `--status-check`)
* `SKAFFOLD_TAG` (same as `--tag`)
* `SKAFFOLD_TAIL` (same as `--tail`)
* `SKAFFOLD_TOOT` (same as `--toot`)

### skaffold schema

List and print json schemas used to validate skaffold.yaml configuration

```


Available Commands:
  get         Print a given skaffold.yaml's json schema
  list        List skaffold.yaml's json schema versions

Use "skaffold <command> --help" for more information about a given command.


```

### skaffold schema get

Print a given skaffold.yaml's json schema

```


Examples:
  # Print the schema in version `skaffold/v1`
  skaffold schema get skaffold/v1

Usage:
  skaffold schema get [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```

### skaffold schema list

List skaffold.yaml's json schema versions

```


Examples:
  # List all the versions
  skaffold schema list

Usage:
  skaffold schema list [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```

### skaffold survey

Show Skaffold survey url

```


Usage:
  skaffold survey [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```

### skaffold version

Print the version information

```


Options:
  -o, --output={{.Version}}
: Format output with go-template. For full struct documentation, see https://godoc.org/github.com/GoogleContainerTools/skaffold/pkg/skaffold/version#Info

Usage:
  skaffold version [options]

Use "skaffold options" for a list of global command-line options (applies to all commands).


```
Env vars:

* `SKAFFOLD_OUTPUT` (same as `--output`)
