/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import java.io.Serializable;
import jv.number.PuString;
import jv.object.PsDebug;
import jv.vecmath.PdVector;

public class PdMatrix
implements Serializable {
    private int m_size = 0;
    protected int m_iSize = 0;
    protected int m_jSize = 0;
    public double[][] m_data;

    public static PdMatrix[] realloc(PdMatrix[] data, int arraySize) {
        if (data != null && data.length == arraySize) {
            return data;
        }
        PdMatrix[] newData = new PdMatrix[arraySize];
        int commonSize = data == null ? 0 : Math.min(data.length, arraySize);
        int i = 0;
        while (i < commonSize) {
            newData[i] = data[i];
            ++i;
        }
        i = commonSize;
        while (i < arraySize) {
            newData[i] = new PdMatrix();
            ++i;
        }
        return newData;
    }

    public boolean isSquare() {
        return this.m_iSize == this.m_jSize;
    }

    public void leftMult(PdMatrix m) {
        int j;
        if (m == null || m.m_iSize != m.m_jSize || m.m_iSize != this.m_iSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int iSize = m.m_iSize;
        double[][] tmp = new double[iSize][this.m_jSize];
        int i = 0;
        while (i < iSize) {
            j = 0;
            while (j < this.m_jSize) {
                tmp[i][j] = 0.0;
                int k = 0;
                while (k < this.m_iSize) {
                    double[] dArray = tmp[i];
                    int n = j;
                    dArray[n] = dArray[n] + m.m_data[i][k] * this.m_data[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < iSize) {
            j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j] = tmp[i][j];
                ++j;
            }
            ++i;
        }
    }

    public double[][] getEntries() {
        double[][] newData = new double[this.m_iSize][];
        int i = 0;
        while (i < this.m_iSize) {
            newData[i] = (double[])this.m_data[i].clone();
            ++i;
        }
        return newData;
    }

    public void rightMult(PdMatrix m) {
        int j;
        if (m == null || m.m_iSize != m.m_jSize || m.m_iSize != this.m_jSize) {
            PsDebug.warning("argument not square or incompatible sizes");
            return;
        }
        int jSize = m.m_jSize;
        double[][] tmp = new double[this.m_iSize][jSize];
        int i = 0;
        while (i < this.m_iSize) {
            j = 0;
            while (j < jSize) {
                tmp[i][j] = 0.0;
                int k = 0;
                while (k < this.m_jSize) {
                    double[] dArray = tmp[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.m_data[i][k] * m.m_data[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_iSize) {
            j = 0;
            while (j < jSize) {
                this.m_data[i][j] = tmp[i][j];
                ++j;
            }
            ++i;
        }
    }

    public boolean invertTopLeft(PdMatrix m, int aSubSize) {
        int j;
        if (this.m_size < aSubSize || m.m_size < aSubSize) {
            PsDebug.warning("method 'invertTopLeft' not applicable", this);
            return false;
        }
        PdMatrix tmp = new PdMatrix(aSubSize);
        int i = 0;
        while (i < aSubSize) {
            j = 0;
            while (j < aSubSize) {
                tmp.m_data[i][j] = m.m_data[i][j];
                ++j;
            }
            ++i;
        }
        if (!tmp.invert()) {
            PsDebug.error("matrix singular", this);
            this.setIdentity();
            return false;
        }
        this.copy(m);
        i = 0;
        while (i < aSubSize) {
            j = 0;
            while (j < aSubSize) {
                this.m_data[i][j] = tmp.m_data[i][j];
                ++j;
            }
            ++i;
        }
        return true;
    }

    public double det() {
        double[][] m = this.m_data;
        switch (this.m_size) {
            case 1: {
                return m[0][0];
            }
            case 2: {
                return m[0][0] * m[1][1] - m[0][1] * m[1][0];
            }
            case 3: {
                return m[0][0] * (m[1][1] * m[2][2] - m[2][1] * m[1][2]) - m[0][1] * (m[1][0] * m[2][2] - m[2][0] * m[1][2]) + m[0][2] * (m[1][0] * m[2][1] - m[2][0] * m[1][1]);
            }
        }
        PsDebug.warning("not implemented for m_size>3");
        return 1.0;
    }

    public double getEntry(int i, int j) {
        if (i < 0 || this.m_iSize <= i) {
            PsDebug.warning("index i out of range, index=" + i);
            return 0.0;
        }
        if (j < 0 || this.m_jSize <= j) {
            PsDebug.warning("index j out of range, index=" + j);
            return 0.0;
        }
        return this.m_data[i][j];
    }

    public void setEntry(int i, int j, double value) {
        if (this.m_iSize <= i || this.m_jSize <= j) {
            this.setSize(i + 1, j + 1);
        }
        this.m_data[i][j] = value;
    }

    public void add(PdMatrix m) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                double[] dArray = this.m_data[i];
                int n = j;
                dArray[n] = dArray[n] + m.m_data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void add(PdMatrix m1, PdMatrix m2) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j] = m1.m_data[i][j] + m2.m_data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public String toShortString() {
        StringBuffer strBuf = new StringBuffer("");
        if (this.m_data == null) {
            strBuf.append("\t m_data = null\n");
        } else {
            int i = 0;
            while (i < this.m_iSize) {
                strBuf.append("\t [" + PuString.intToString(i, 3) + "] = {");
                strBuf.append(" " + String.valueOf(this.m_data[i][0]));
                int j = 1;
                while (j < this.m_jSize) {
                    strBuf.append(", " + String.valueOf(this.m_data[i][j]));
                    ++j;
                }
                strBuf.append("}\n");
                ++i;
            }
        }
        return strBuf.toString();
    }

    public boolean adjoint(PdVector v) {
        if (this.m_size != v.m_data.length) {
            this.setSize(v.m_data.length);
        }
        int i = 0;
        while (i < this.m_size) {
            int j = 0;
            while (j < this.m_size) {
                this.m_data[i][j] = v.m_data[i] * v.m_data[j];
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean adjoint(PdVector v, PdVector w) {
        if (this.m_size != v.m_data.length) {
            this.setSize(v.m_data.length);
        }
        int i = 0;
        while (i < this.m_size) {
            int j = 0;
            while (j < this.m_size) {
                this.m_data[i][j] = v.m_data[i] * w.m_data[j];
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void setDiagonal(PdVector diag) {
        if (diag == null) {
            PsDebug.warning("missing argument vector");
            return;
        }
        if (diag.getSize() < this.m_size) {
            PsDebug.warning("vector too small");
            return;
        }
        int i = 0;
        while (i < this.m_size) {
            this.m_data[i][i] = diag.m_data[i];
            ++i;
        }
    }

    public static PdMatrix[] copyNew(PdMatrix[] data) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        return PdMatrix.copyNew(data, data.length);
    }

    public static PdMatrix[] copyNew(PdMatrix[] data, int size) {
        if (data == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdMatrix[] newData = new PdMatrix[size];
        int i = 0;
        while (i < size) {
            newData[i] = new PdMatrix(data[i].m_iSize, data[i].m_jSize);
            newData[i].copy(data[i]);
            ++i;
        }
        return newData;
    }

    public static PdMatrix copyNew(PdMatrix mat) {
        if (mat == null) {
            PsDebug.warning("missing argument");
            return null;
        }
        PdMatrix newMatrix = new PdMatrix(mat.m_iSize, mat.m_jSize);
        newMatrix.copy(mat);
        return newMatrix;
    }

    public void mult(PdMatrix m1, PdMatrix m2) {
        if (this == m1 || this == m2) {
            PsDebug.warning("'this' must be different from argument");
            return;
        }
        int iSize = m1.m_iSize;
        int jSize = m2.m_jSize;
        int kSize = m1.m_jSize;
        if (this.m_iSize != iSize || this.m_jSize != jSize) {
            this.setSize(iSize, jSize);
        }
        int i = 0;
        while (i < iSize) {
            int j = 0;
            while (j < jSize) {
                this.m_data[i][j] = 0.0;
                int k = 0;
                while (k < kSize) {
                    double[] dArray = this.m_data[i];
                    int n = j;
                    dArray[n] = dArray[n] + m1.m_data[i][k] * m2.m_data[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean invert() {
        PdMatrix tmp = new PdMatrix(this.m_size);
        tmp.copy(this);
        return this.invert(tmp);
    }

    public boolean invert(PdMatrix m) {
        double det = 1.0;
        if (1 <= this.m_size && this.m_size <= 3 && (det = m.det()) == 0.0) {
            PsDebug.error("matrix singular", m);
            this.setIdentity();
            return false;
        }
        this.setIdentity();
        switch (this.m_size) {
            case 1: {
                this.m_data[0][0] = 1.0 / det;
                break;
            }
            case 2: {
                this.m_data[0][0] = m.m_data[1][1] / det;
                this.m_data[0][1] = -m.m_data[0][1] / det;
                this.m_data[1][0] = -m.m_data[1][0] / det;
                this.m_data[1][1] = m.m_data[0][0] / det;
                break;
            }
            case 3: {
                this.m_data[0][0] = (m.m_data[1][1] * m.m_data[2][2] - m.m_data[2][1] * m.m_data[1][2]) / det;
                this.m_data[0][1] = (m.m_data[0][2] * m.m_data[2][1] - m.m_data[0][1] * m.m_data[2][2]) / det;
                this.m_data[0][2] = (m.m_data[0][1] * m.m_data[1][2] - m.m_data[0][2] * m.m_data[1][1]) / det;
                this.m_data[1][0] = (m.m_data[1][2] * m.m_data[2][0] - m.m_data[1][0] * m.m_data[2][2]) / det;
                this.m_data[1][1] = (m.m_data[0][0] * m.m_data[2][2] - m.m_data[0][2] * m.m_data[2][0]) / det;
                this.m_data[1][2] = (m.m_data[0][2] * m.m_data[1][0] - m.m_data[0][0] * m.m_data[1][2]) / det;
                this.m_data[2][0] = (m.m_data[1][0] * m.m_data[2][1] - m.m_data[1][1] * m.m_data[2][0]) / det;
                this.m_data[2][1] = (m.m_data[0][1] * m.m_data[2][0] - m.m_data[0][0] * m.m_data[2][1]) / det;
                this.m_data[2][2] = (m.m_data[0][0] * m.m_data[1][1] - m.m_data[0][1] * m.m_data[1][0]) / det;
                break;
            }
            case 4: {
                int j;
                double[] r = new double[4];
                double[][] tmp = new double[4][4];
                int i = 0;
                while (i < 4) {
                    j = 0;
                    while (j < 4) {
                        tmp[i][j] = m.m_data[i][j];
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < 4) {
                    int k;
                    int max_row = i;
                    j = i + 1;
                    while (j < 4) {
                        if (Math.abs(tmp[j][i]) > Math.abs(tmp[max_row][i])) {
                            max_row = j;
                        }
                        ++j;
                    }
                    if (tmp[max_row][i] == 0.0) {
                        return false;
                    }
                    if (max_row != i) {
                        j = 0;
                        while (j < 4) {
                            r[j] = tmp[max_row][j];
                            tmp[max_row][j] = tmp[i][j];
                            tmp[i][j] = r[j];
                            ++j;
                        }
                        j = 0;
                        while (j < 4) {
                            r[j] = this.m_data[max_row][j];
                            this.m_data[max_row][j] = this.m_data[i][j];
                            this.m_data[i][j] = r[j];
                            ++j;
                        }
                    }
                    j = 0;
                    while (j < 4) {
                        r[j] = tmp[j][i] / tmp[i][i];
                        ++j;
                    }
                    j = 0;
                    while (j < i) {
                        k = 0;
                        while (k < 4) {
                            double[] dArray = tmp[j];
                            int n = k;
                            dArray[n] = dArray[n] - tmp[i][k] * r[j];
                            ++k;
                        }
                        k = 0;
                        while (k < 4) {
                            double[] dArray = this.m_data[j];
                            int n = k;
                            dArray[n] = dArray[n] - this.m_data[i][k] * r[j];
                            ++k;
                        }
                        ++j;
                    }
                    j = i + 1;
                    while (j < 4) {
                        k = 0;
                        while (k < 4) {
                            double[] dArray = tmp[j];
                            int n = k;
                            dArray[n] = dArray[n] - tmp[i][k] * r[j];
                            ++k;
                        }
                        k = 0;
                        while (k < 4) {
                            double[] dArray = this.m_data[j];
                            int n = k;
                            dArray[n] = dArray[n] - this.m_data[i][k] * r[j];
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 0;
                while (i < 4) {
                    j = 0;
                    while (j < 4) {
                        double[] dArray = this.m_data[i];
                        int n = j++;
                        dArray[n] = dArray[n] / tmp[i][i];
                    }
                    ++i;
                }
                break;
            }
            default: {
                PsDebug.error("method 'invert' not completed", this);
                return false;
            }
        }
        return true;
    }

    public int getJSize() {
        return this.m_jSize;
    }

    public int getSize() {
        if (this.m_iSize == this.m_jSize) {
            return this.m_iSize;
        }
        return -1;
    }

    public void setSize(int aSize) {
        this.setSize(aSize, aSize);
    }

    public void setSize(int iSize, int jSize) {
        if (this.m_iSize == iSize && this.m_jSize == jSize) {
            return;
        }
        this.m_size = iSize;
        this.m_iSize = iSize;
        this.m_jSize = jSize;
        this.m_data = new double[this.m_iSize][this.m_jSize];
    }

    public void setColumns(PdVector[] aVector) {
        if (aVector == null || aVector.length < this.m_jSize) {
            PsDebug.warning("missing vector list, or invalid number of columns");
            return;
        }
        int j = 0;
        while (j < this.m_jSize) {
            this.setColumn(j, aVector[j]);
            ++j;
        }
    }

    public Object clone() {
        return PdMatrix.copyNew(this);
    }

    public void setIdentity() {
        int i = 0;
        while (i < this.m_size) {
            int j = 0;
            while (j < this.m_size) {
                this.m_data[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_size) {
            this.m_data[i][i] = 1.0;
            ++i;
        }
    }

    public static int getSpaceDim(double[][] point) {
        int numPoints = point.length;
        if (numPoints <= 1) {
            return 0;
        }
        if (numPoints > 4) {
            PsDebug.error("not implemented for more than four points");
            numPoints = 4;
        }
        double[][] d = new double[numPoints - 1][];
        int pointDim = point[0].length;
        int i = 0;
        while (i < numPoints - 1) {
            d[i] = new double[pointDim];
            int j = 0;
            while (j < pointDim) {
                d[i][j] = point[i][j] - point[numPoints - 1][j];
                ++j;
            }
            ++i;
        }
        PdMatrix m = new PdMatrix(numPoints - 1, pointDim);
        m.m_data = d;
        if (m.det() != 0.0) {
            return numPoints - 1;
        }
        PsDebug.warning("dimension could be greater than zero, but is not maximal, anyway zero returned");
        return 0;
    }

    public double det33() {
        double[][] m = this.m_data;
        if (this.m_size < 3) {
            PsDebug.warning("not implemented for m_size<3");
            return 1.0;
        }
        return m[0][0] * (m[1][1] * m[2][2] - m[2][1] * m[1][2]) - m[0][1] * (m[1][0] * m[2][2] - m[2][0] * m[1][2]) + m[0][2] * (m[1][0] * m[2][1] - m[2][0] * m[1][1]);
    }

    public void multScalar(double scalar) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                double[] dArray = this.m_data[i];
                int n = j++;
                dArray[n] = dArray[n] * scalar;
            }
            ++i;
        }
    }

    public void multScalar(PdMatrix m, double scalar) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j] = m.m_data[i][j] * scalar;
                ++j;
            }
            ++i;
        }
    }

    public void set(double[][] x) {
        if (x == null || x.length == 0) {
            this.setSize(0, 0);
            return;
        }
        if (x[0] == null) {
            this.setSize(x.length, 0);
            return;
        }
        this.setSize(x.length, x[0].length);
        int i = 0;
        while (i < x.length) {
            if (x[i] == null || x[i].length != x[0].length) {
                PsDebug.warning("non-matrix double array");
                return;
            }
            int j = 0;
            while (j < x[0].length) {
                this.m_data[i][j] = x[i][j];
                ++j;
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("");
        strBuf.append("PdMatrix \n");
        strBuf.append("\t m_iSize = " + this.m_iSize);
        strBuf.append(", m_jSize = " + this.m_jSize);
        strBuf.append(", m_size  = " + this.m_size + "\n");
        if (this.m_data == null) {
            strBuf.append("\t m_data = null\n");
        } else {
            int i = 0;
            while (i < this.m_iSize) {
                strBuf.append("\t [" + PuString.intToString(i, 3) + "] = {");
                strBuf.append(" " + String.valueOf(this.m_data[i][0]));
                int j = 1;
                while (j < this.m_jSize) {
                    strBuf.append(", " + String.valueOf(this.m_data[i][j]));
                    ++j;
                }
                strBuf.append("}\n");
                ++i;
            }
        }
        return strBuf.toString();
    }

    public PdMatrix() {
    }

    public PdMatrix(int aSize) {
        this.setSize(aSize, aSize);
    }

    public PdMatrix(int iSize, int jSize) {
        this.setSize(iSize, jSize);
    }

    public PdMatrix(double[][] x) {
        this();
        this.set(x);
    }

    public static PdMatrix expandComponents(PdMatrix mat, int dim) {
        if (mat == null) {
            PsDebug.warning("missing argument matrix");
            return null;
        }
        if (mat.m_iSize != mat.m_jSize) {
            PsDebug.warning("argument matrix not square");
            return null;
        }
        int size = mat.getSize();
        PdMatrix matExpand = new PdMatrix(size * dim);
        int i = 0;
        while (i < size) {
            int ipos = i * dim;
            int j = 0;
            while (j < size) {
                int jpos = j * dim;
                int k = 0;
                while (k < dim) {
                    double tNum;
                    matExpand.m_data[ipos + k][jpos + k] = tNum = mat.m_data[i][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return matExpand;
    }

    public void transpose() {
        int i = 0;
        while (i < this.m_size) {
            int j = i + 1;
            while (j < this.m_size) {
                double tmp = this.m_data[i][j];
                this.m_data[i][j] = this.m_data[j][i];
                this.m_data[j][i] = tmp;
                ++j;
            }
            ++i;
        }
    }

    public void transpose(PdMatrix m) {
        int i = 0;
        while (i < this.m_size) {
            this.m_data[i][i] = m.m_data[i][i];
            int j = i + 1;
            while (j < this.m_size) {
                this.m_data[i][j] = m.m_data[j][i];
                this.m_data[j][i] = m.m_data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void sub(PdMatrix m) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                double[] dArray = this.m_data[i];
                int n = j;
                dArray[n] = dArray[n] - m.m_data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void sub(PdMatrix m1, PdMatrix m2) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j] = m1.m_data[i][j] - m2.m_data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public static boolean copy(PdMatrix[] dataDest, int destInd, PdMatrix[] dataSrc, int srcInd, int size) {
        if (dataDest == null || dataDest.length < destInd + size) {
            PsDebug.error("missing space in dataDest", dataSrc);
            return false;
        }
        int i = 0;
        while (i < size) {
            dataDest[destInd + i].copy(dataSrc[srcInd + i]);
            ++i;
        }
        return true;
    }

    public void copy(PdMatrix m) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j] = m.m_data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public int getISize() {
        return this.m_iSize;
    }

    public void setRow(int aRow, PdVector aVector) {
        if (aRow < 0 || aRow >= this.m_iSize || aVector.getSize() != this.m_jSize) {
            PsDebug.error("invalid row or vector size", this);
            return;
        }
        int i = 0;
        while (i < this.m_jSize) {
            this.m_data[aRow][i] = aVector.m_data[i];
            ++i;
        }
    }

    public void setConstant(double aValue) {
        int i = 0;
        while (i < this.m_iSize) {
            int j = 0;
            while (j < this.m_jSize) {
                this.m_data[i][j] = aValue;
                ++j;
            }
            ++i;
        }
    }

    public boolean invert34(PdMatrix m) {
        if (!this.invertTopLeft(m, 3)) {
            PsDebug.error("matrix singular", this);
            this.setIdentity();
            return false;
        }
        int i = 0;
        while (i < 3) {
            this.m_data[i][3] = 0.0;
            int j = 0;
            while (j < 3) {
                double[] dArray = this.m_data[i];
                dArray[3] = dArray[3] - this.m_data[i][j] * m.m_data[j][3];
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void setRows(PdVector[] aVector) {
        if (aVector == null || aVector.length < this.m_iSize) {
            PsDebug.warning("missing vector list, or invalid number of rows");
            return;
        }
        int i = 0;
        while (i < this.m_iSize) {
            this.setRow(i, aVector[i]);
            ++i;
        }
    }

    public static PdMatrix[] realloc(PdMatrix[] data, int arraySize, int iSize, int jSize) {
        data = PdMatrix.realloc(data, arraySize);
        int i = 0;
        while (i < arraySize) {
            if (data[i].m_iSize != iSize || data[i].m_jSize != jSize) {
                data[i].setSize(iSize, jSize);
            }
            ++i;
        }
        return data;
    }

    public void setColumn(int aColumn, PdVector aVector) {
        if (aColumn < 0 || aColumn >= this.m_jSize || aVector.getSize() != this.m_iSize) {
            PsDebug.error("invalid Column or vector size", this);
            return;
        }
        int i = 0;
        while (i < this.m_iSize) {
            this.m_data[i][aColumn] = aVector.m_data[i];
            ++i;
        }
    }
}

