/*
 * Decompiled with CFR 0.152.
 */
package jv.rsrc;

import java.awt.Component;
import jv.loader.PsXmlLoader;
import jv.number.PdColor;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.rsrc.PsJavaView_IP;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jv.vecmath.PdVector;

public final class PsJavaView
extends PsObject {
    public static String m_version;
    public static String m_licenseType;
    public static String m_licenseUsage;
    public static String m_licenseId;
    public static String m_licenseExpire;
    public static String m_licenseeFirstName;
    public static String m_licenseeLastName;
    public static String m_licenseeOrganization;
    public static String m_licenseeEmail;
    public static String m_licenseeUrl;
    public static String m_userFirstName;
    public static String m_userLastName;
    public static String m_userOrganization;
    public static String m_userEmail;
    public static String m_userUrl;
    public static int MONITOR_XLARGE;
    public static int MONITOR_LARGE;
    public static int MONITOR_XCGA;
    public static int MONITOR_VGA;
    public static int MONITOR_DOS;
    public static int MONITOR_PALM;
    public static int MONITOR_USER;
    public static int m_monitorType;
    public static String m_monitorMouse;
    protected static int[][] m_monitorSize;
    protected static int[][] m_controlSize;
    protected static int[][] m_aboutSize;
    protected static int[][] m_helpSize;
    protected static int[][] m_consoleSize;
    protected static int[][] m_animationSize;
    protected static int[][] m_newProjectSize;
    protected static int[][] m_importModelSize;
    protected static int[][] m_exportBounds;
    public static final int MONITOR = 0;
    public static final int WINDOW_CONTROL = 1;
    public static final int WINDOW_ABOUT = 2;
    public static final int WINDOW_HELP = 3;
    public static final int WINDOW_CONSOLE = 4;
    public static final int WINDOW_ANIMATION = 5;
    public static final int WINDOW_NEW_PROJECT = 6;
    public static final int WINDOW_IMPORT_MODEL = 7;
    public static final int WINDOW_EXPORT_MODEL = 8;
    public static String m_viewerScreen;
    public static String m_viewerVisible;
    public static String m_controlVisible;
    public static String m_consoleVisible;
    public static String m_cameraProjection;
    public static PdVector m_view;
    public static PdVector m_interest;
    public static double m_cameraDistance;
    public static double m_cameraRoll;
    public static boolean m_transformEnable;
    public static String m_transformAmbient;
    public static String m_transformProjection;
    public static boolean m_cameraClip;
    public static double m_cameraClipNear;
    public static double m_cameraClipFar;
    public static int m_displayHeight;
    public static int m_displayWidth;
    public static boolean m_displayAutorotate;
    public static boolean m_displayBackside;
    public static boolean m_displayBackimage;
    public static boolean m_displayDepth;
    public static boolean m_displayEdgeAura;
    public static boolean m_displayXYGrid;
    public static boolean m_displaySorting;
    public static PdColor m_background;
    public static PdColor m_foreground;
    protected static String m_title;
    private static /* synthetic */ Class class$jv$rsrc$PsJavaView;

    public int[] getWindowSize(int windowId) {
        int[] size2;
        switch (windowId) {
            case 0: {
                size2 = m_monitorSize[m_monitorType];
                break;
            }
            case 1: {
                size2 = m_controlSize[m_monitorType];
                break;
            }
            case 2: {
                size2 = m_aboutSize[m_monitorType];
                break;
            }
            case 3: {
                size2 = m_helpSize[m_monitorType];
                break;
            }
            case 4: {
                size2 = m_consoleSize[m_monitorType];
                break;
            }
            case 5: {
                size2 = m_animationSize[m_monitorType];
                break;
            }
            case 6: {
                size2 = m_newProjectSize[m_monitorType];
                break;
            }
            case 7: {
                size2 = m_importModelSize[m_monitorType];
                break;
            }
            case 8: {
                size2 = m_exportBounds[m_monitorType];
                break;
            }
            default: {
                PsDebug.warning("unknown window identifier = " + windowId);
                Object size2 = null;
                return null;
            }
        }
        int[] dupSize = new int[]{size2[0], size2[1], size2[2], size2[3]};
        return dupSize;
    }

    public void showInfoPanel() {
        PsJavaView_IP dialog = new PsJavaView_IP();
        dialog.setParent(this);
        dialog.update(this);
        dialog.setLocation(20, 5);
        ((Component)dialog).setSize(600, 400);
        ((Component)dialog).setVisible(true);
    }

    public PsJavaView() {
        m_licenseType = "non-profit";
        m_licenseId = "100.100.10";
        m_licenseExpire = "unlimited";
        m_licenseeFirstName = "unknown";
        m_licenseeLastName = "unknown";
        m_licenseeOrganization = "unknown";
        m_licenseeEmail = "unknown";
        m_licenseeUrl = "unknown";
        m_userFirstName = "unknown";
        m_userLastName = "unknown";
        m_userOrganization = "unknown";
        m_userEmail = "unknown";
        m_userUrl = "unknown";
        m_view = new PdVector(3);
        m_interest = new PdVector(3);
        m_background = new PdColor();
        m_foreground = new PdColor();
        m_cameraClip = false;
        m_displayAutorotate = false;
        m_displayBackside = true;
        m_displayBackimage = false;
        m_displayDepth = true;
        m_displayEdgeAura = false;
        m_displayXYGrid = false;
        m_displaySorting = true;
        if (this.getClass() == (class$jv$rsrc$PsJavaView != null ? class$jv$rsrc$PsJavaView : (class$jv$rsrc$PsJavaView = PsJavaView.class$("jv.rsrc.PsJavaView")))) {
            this.init();
        }
    }

    public boolean read(String rsrcFile) {
        if (rsrcFile == null) {
            PsDebug.warning("missing argument file name.");
            return false;
        }
        PsXmlSrc src = PsXmlLoader.read(rsrcFile);
        if (src == null) {
            PsDebug.warning("could not read rsrc file = " + rsrcFile);
            return false;
        }
        this.setXml(src);
        return true;
    }

    private boolean parseFont(int os, PsXmlNode font) {
        int iType;
        String type = font.getContent();
        if (type == null) {
            PsDebug.warning("missing font type");
            return false;
        }
        if (type.equalsIgnoreCase("text")) {
            iType = 0;
        } else if (type.equalsIgnoreCase("fixed")) {
            iType = 1;
        } else if (type.equalsIgnoreCase("menu")) {
            iType = 2;
        } else if (type.equalsIgnoreCase("header2")) {
            iType = 3;
        } else if (type.equalsIgnoreCase("header4")) {
            iType = 4;
        } else {
            PsDebug.warning("invalid font type");
            return false;
        }
        String name = font.getAttribute("name");
        if (name != null && name.equals("")) {
            name = null;
        }
        int iStyle = -1;
        String style = font.getAttribute("style");
        if (style != null) {
            if (style.equalsIgnoreCase("bold")) {
                iStyle = 1;
            } else if (style.equalsIgnoreCase("plain")) {
                iStyle = 0;
            } else if (style.equalsIgnoreCase("italic")) {
                iStyle = 2;
            } else if (style.equalsIgnoreCase("")) {
                iStyle = -1;
            } else {
                PsDebug.warning("invalid font style = " + style);
                return false;
            }
        }
        int iSize = -1;
        String size = font.getAttribute("size");
        if (size != null) {
            if (size.equals("")) {
                iSize = -1;
            } else {
                try {
                    iSize = Integer.parseInt(size);
                }
                catch (NumberFormatException e) {
                    PsDebug.warning("invalid font size = " + size);
                    return false;
                }
            }
        }
        PsConfig.setFont(os, iType, name, iStyle, iSize);
        return true;
    }

    public PsXmlSrc getXml() {
        PsXmlSrc src = new PsXmlSrc();
        src.setDocName("javaview-rsrc");
        src.setDocType("http://www.javaview.de/rsrc/jv-rsrc.dtd");
        return this.fillRsrcTree(src);
    }

    public void setXml(PsXmlSrc src) {
        PsXmlNode display;
        PsXmlNode user;
        PsXmlNode windows;
        if (src == null) {
            PsDebug.warning("missing resource.");
            return;
        }
        PsXmlNode root = src.getRootNode();
        if (root == null) {
            PsDebug.warning("missing root node.");
            return;
        }
        m_title = src.getRsrcFile();
        PsXmlNode javaview = PsXmlSrc.getRsrcNode(root, "javaview-rsrc");
        if (javaview == null) {
            this.fillRsrcTree(src);
            javaview = PsXmlSrc.getRsrcNode(root, "javaview-rsrc");
        }
        m_version = PsXmlSrc.getRsrc(javaview, "version");
        PsXmlNode license = PsXmlSrc.getRsrcNode(javaview, "license");
        if (license != null) {
            m_licenseType = license.getAttribute("type");
            m_licenseUsage = license.getAttribute("usage");
            m_licenseId = PsXmlSrc.getRsrc(license, "license-id");
            m_licenseExpire = PsXmlSrc.getRsrc(license, "license-expire");
            PsXmlNode licensee = PsXmlSrc.getRsrcNode(license, "licensee");
            if (licensee != null) {
                m_licenseeFirstName = PsXmlSrc.getRsrc(licensee, "firstname");
                m_licenseeLastName = PsXmlSrc.getRsrc(licensee, "lastname");
                m_licenseeOrganization = PsXmlSrc.getRsrc(licensee, "organization");
                m_licenseeEmail = PsXmlSrc.getRsrc(licensee, "email");
                m_licenseeUrl = PsXmlSrc.getRsrc(licensee, "url");
            }
        }
        if ((windows = PsXmlSrc.getRsrcNode(javaview, "windows")) != null) {
            PsXmlNode fonts;
            PsXmlNode console;
            PsXmlNode control;
            PsXmlNode viewer;
            PsXmlNode monitor = PsXmlSrc.getRsrcNode(windows, "monitor");
            if (monitor != null) {
                String monitorMouse;
                String monitorType = monitor.getAttribute("size");
                if (monitorType != null) {
                    m_monitorType = monitorType.startsWith("1600") ? MONITOR_XLARGE : (monitorType.startsWith("1280") ? MONITOR_LARGE : (monitorType.startsWith("1024") ? MONITOR_XCGA : (monitorType.startsWith("800") ? MONITOR_VGA : (monitorType.startsWith("640") ? MONITOR_DOS : (monitorType.startsWith("320") ? MONITOR_PALM : MONITOR_USER)))));
                }
                if ((monitorMouse = monitor.getAttribute("mouse")) != null) {
                    m_monitorMouse = monitorMouse;
                }
            }
            if ((viewer = PsXmlSrc.getRsrcNode(windows, "viewer")) != null) {
                m_viewerScreen = viewer.getAttribute("show");
                m_viewerVisible = viewer.getAttribute("visible");
            }
            if ((control = PsXmlSrc.getRsrcNode(windows, "control")) != null) {
                m_controlVisible = control.getAttribute("visible");
            }
            if ((console = PsXmlSrc.getRsrcNode(windows, "console")) != null) {
                m_consoleVisible = console.getAttribute("visible");
            }
            if ((fonts = PsXmlSrc.getRsrcNode(windows, "fonts")) != null) {
                PsXmlNode linuxFont;
                PsXmlNode solarisFont;
                PsXmlNode irixFont;
                PsXmlNode winFont;
                int i;
                PsXmlNode[] font = fonts.getChildren("font");
                if (font != null) {
                    i = 0;
                    while (i < font.length) {
                        this.parseFont(PsConfig.getOSId(), font[i]);
                        ++i;
                    }
                }
                if ((winFont = PsXmlSrc.getRsrcNode(fonts, "oswin")) != null && (font = winFont.getChildren("font")) != null) {
                    i = 0;
                    while (i < font.length) {
                        this.parseFont(0, font[i]);
                        ++i;
                    }
                }
                if ((irixFont = PsXmlSrc.getRsrcNode(fonts, "osirix")) != null && (font = irixFont.getChildren("font")) != null) {
                    i = 0;
                    while (i < font.length) {
                        this.parseFont(1, font[i]);
                        ++i;
                    }
                }
                if ((solarisFont = PsXmlSrc.getRsrcNode(fonts, "ossolaris")) != null && (font = solarisFont.getChildren("font")) != null) {
                    i = 0;
                    while (i < font.length) {
                        this.parseFont(2, font[i]);
                        ++i;
                    }
                }
                if ((linuxFont = PsXmlSrc.getRsrcNode(fonts, "oslinux")) != null && (font = linuxFont.getChildren("font")) != null) {
                    i = 0;
                    while (i < font.length) {
                        this.parseFont(3, font[i]);
                        ++i;
                    }
                }
            }
        }
        if ((user = PsXmlSrc.getRsrcNode(javaview, "user")) != null) {
            m_userFirstName = PsXmlSrc.getRsrc(user, "firstname");
            m_userLastName = PsXmlSrc.getRsrc(user, "lastname");
            m_userEmail = PsXmlSrc.getRsrc(user, "email");
            m_userUrl = PsXmlSrc.getRsrc(user, "url");
        }
        if ((display = PsXmlSrc.getRsrcNode(javaview, "display")) != null) {
            PsXmlNode foreground;
            PsXmlNode camera = PsXmlSrc.getRsrcNode(display, "camera");
            if (camera != null) {
                PsXmlNode clipping;
                PsXmlNode interest;
                m_cameraProjection = PsXmlSrc.getRsrc(camera, "projection");
                PsXmlNode view = PsXmlSrc.getRsrcNode(camera, "viewpoint");
                if (view != null) {
                    m_view.setEntry(0, PsXmlSrc.getRsrcAsDouble(view, "x"));
                    m_view.setEntry(1, PsXmlSrc.getRsrcAsDouble(view, "y"));
                    m_view.setEntry(2, PsXmlSrc.getRsrcAsDouble(view, "z"));
                }
                if ((interest = PsXmlSrc.getRsrcNode(camera, "interest")) != null) {
                    m_interest.setEntry(0, PsXmlSrc.getRsrcAsDouble(interest, "x"));
                    m_interest.setEntry(1, PsXmlSrc.getRsrcAsDouble(interest, "y"));
                    m_interest.setEntry(2, PsXmlSrc.getRsrcAsDouble(interest, "z"));
                }
                m_cameraDistance = PsXmlSrc.getRsrcAsDouble(camera, "distance");
                m_cameraRoll = PsXmlSrc.getRsrcAsDouble(camera, "roll");
                PsXmlNode transform = PsXmlSrc.getRsrcNode(camera, "transform");
                if (transform != null) {
                    m_transformEnable = PsXmlSrc.getRsrcAsBoolean(transform, "enable");
                    m_transformAmbient = PsXmlSrc.getRsrc(transform, "ambient");
                    m_transformProjection = PsXmlSrc.getRsrc(transform, "projection");
                }
                if ((clipping = PsXmlSrc.getRsrcNode(camera, "clipping")) != null) {
                    m_cameraClip = PsXmlSrc.getRsrcAsBoolean(clipping, "enable");
                    m_cameraClipNear = PsXmlSrc.getRsrcAsDouble(clipping, "near");
                    m_cameraClipFar = PsXmlSrc.getRsrcAsDouble(clipping, "far");
                }
            }
            m_displayHeight = PsXmlSrc.getRsrcAsInteger(display, "height");
            m_displayWidth = PsXmlSrc.getRsrcAsInteger(display, "width");
            m_displayAutorotate = PsXmlSrc.getRsrcAsBoolean(display, "autorotate");
            m_displayBackimage = PsXmlSrc.getRsrcAsBoolean(display, "backimge");
            m_displayXYGrid = PsXmlSrc.getRsrcAsBoolean(display, "xygrid");
            m_displayBackside = PsXmlSrc.getRsrcAsBoolean(display, "backside");
            m_displayDepth = PsXmlSrc.getRsrcAsBoolean(display, "depth");
            m_displaySorting = PsXmlSrc.getRsrcAsBoolean(display, "sorting");
            m_displayEdgeAura = PsXmlSrc.getRsrcAsBoolean(display, "edgeaura");
            PsXmlNode background = PsXmlSrc.getRsrcNode(display, "background");
            if (background != null) {
                m_background.setEntry(0, PsXmlSrc.getRsrcAsInteger(background, "r"));
                m_background.setEntry(1, PsXmlSrc.getRsrcAsInteger(background, "g"));
                m_background.setEntry(2, PsXmlSrc.getRsrcAsInteger(background, "b"));
            }
            if ((foreground = PsXmlSrc.getRsrcNode(display, "foreground")) != null) {
                m_foreground.setEntry(0, PsXmlSrc.getRsrcAsInteger(background, "r"));
                m_foreground.setEntry(1, PsXmlSrc.getRsrcAsInteger(background, "g"));
                m_foreground.setEntry(2, PsXmlSrc.getRsrcAsInteger(background, "b"));
            }
        }
    }

    static {
        MONITOR_XLARGE = 0;
        MONITOR_LARGE = 1;
        MONITOR_XCGA = 2;
        MONITOR_VGA = 3;
        MONITOR_DOS = 4;
        MONITOR_PALM = 5;
        MONITOR_USER = 6;
        m_monitorType = MONITOR_LARGE;
        m_monitorSize = new int[][]{{1600, 1200}, {1280, 1024}, {1024, 768}, {800, 600}, {640, 480}, {320, 240}, {320, 240}};
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = new int[]{5, 5, 390, 680};
        nArrayArray[1] = new int[]{5, 5, 390, 680};
        nArrayArray[2] = new int[]{5, 5, 390, 680};
        int[] nArray = new int[4];
        nArray[2] = 320;
        nArray[3] = 600;
        nArrayArray[3] = nArray;
        int[] nArray2 = new int[4];
        nArray2[2] = 250;
        nArray2[3] = 480;
        nArrayArray[4] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[2] = 250;
        nArray3[3] = 240;
        nArrayArray[5] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[2] = 250;
        nArray4[3] = 240;
        nArrayArray[6] = nArray4;
        m_controlSize = nArrayArray;
        int[][] nArrayArray2 = new int[7][];
        nArrayArray2[0] = new int[]{10, 10, 400, 450};
        nArrayArray2[1] = new int[]{10, 10, 400, 450};
        nArrayArray2[2] = new int[]{10, 10, 400, 450};
        int[] nArray5 = new int[4];
        nArray5[2] = 400;
        nArray5[3] = 450;
        nArrayArray2[3] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[2] = 400;
        nArray6[3] = 450;
        nArrayArray2[4] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[2] = 320;
        nArray7[3] = 240;
        nArrayArray2[5] = nArray7;
        int[] nArray8 = new int[4];
        nArray8[2] = 320;
        nArray8[3] = 240;
        nArrayArray2[6] = nArray8;
        m_aboutSize = nArrayArray2;
        int[][] nArrayArray3 = new int[7][];
        nArrayArray3[0] = new int[]{10, 10, 400, 450};
        nArrayArray3[1] = new int[]{10, 10, 400, 450};
        nArrayArray3[2] = new int[]{10, 10, 400, 450};
        int[] nArray9 = new int[4];
        nArray9[2] = 400;
        nArray9[3] = 450;
        nArrayArray3[3] = nArray9;
        int[] nArray10 = new int[4];
        nArray10[2] = 400;
        nArray10[3] = 450;
        nArrayArray3[4] = nArray10;
        int[] nArray11 = new int[4];
        nArray11[2] = 320;
        nArray11[3] = 240;
        nArrayArray3[5] = nArray11;
        int[] nArray12 = new int[4];
        nArray12[2] = 320;
        nArray12[3] = 240;
        nArrayArray3[6] = nArray12;
        m_helpSize = nArrayArray3;
        int[][] nArrayArray4 = new int[7][];
        nArrayArray4[0] = new int[]{10, 10, 500, 350};
        nArrayArray4[1] = new int[]{10, 10, 500, 350};
        nArrayArray4[2] = new int[]{10, 10, 500, 350};
        int[] nArray13 = new int[4];
        nArray13[2] = 500;
        nArray13[3] = 350;
        nArrayArray4[3] = nArray13;
        int[] nArray14 = new int[4];
        nArray14[2] = 500;
        nArray14[3] = 350;
        nArrayArray4[4] = nArray14;
        int[] nArray15 = new int[4];
        nArray15[2] = 320;
        nArray15[3] = 240;
        nArrayArray4[5] = nArray15;
        int[] nArray16 = new int[4];
        nArray16[2] = 320;
        nArray16[3] = 240;
        nArrayArray4[6] = nArray16;
        m_consoleSize = nArrayArray4;
        int[][] nArrayArray5 = new int[7][];
        nArrayArray5[0] = new int[]{10, 10, 400, 300};
        nArrayArray5[1] = new int[]{10, 10, 400, 300};
        nArrayArray5[2] = new int[]{10, 10, 400, 300};
        int[] nArray17 = new int[4];
        nArray17[2] = 400;
        nArray17[3] = 300;
        nArrayArray5[3] = nArray17;
        int[] nArray18 = new int[4];
        nArray18[2] = 400;
        nArray18[3] = 300;
        nArrayArray5[4] = nArray18;
        int[] nArray19 = new int[4];
        nArray19[2] = 320;
        nArray19[3] = 240;
        nArrayArray5[5] = nArray19;
        int[] nArray20 = new int[4];
        nArray20[2] = 320;
        nArray20[3] = 240;
        nArrayArray5[6] = nArray20;
        m_animationSize = nArrayArray5;
        int[][] nArrayArray6 = new int[7][];
        nArrayArray6[0] = new int[]{10, 10, 400, 350};
        nArrayArray6[1] = new int[]{10, 10, 400, 350};
        nArrayArray6[2] = new int[]{10, 10, 400, 350};
        int[] nArray21 = new int[4];
        nArray21[2] = 400;
        nArray21[3] = 350;
        nArrayArray6[3] = nArray21;
        int[] nArray22 = new int[4];
        nArray22[2] = 400;
        nArray22[3] = 350;
        nArrayArray6[4] = nArray22;
        int[] nArray23 = new int[4];
        nArray23[2] = 320;
        nArray23[3] = 240;
        nArrayArray6[5] = nArray23;
        int[] nArray24 = new int[4];
        nArray24[2] = 320;
        nArray24[3] = 240;
        nArrayArray6[6] = nArray24;
        m_newProjectSize = nArrayArray6;
        int[][] nArrayArray7 = new int[7][];
        nArrayArray7[0] = new int[]{10, 10, 400, 400};
        nArrayArray7[1] = new int[]{10, 10, 400, 400};
        nArrayArray7[2] = new int[]{10, 10, 400, 400};
        int[] nArray25 = new int[4];
        nArray25[2] = 400;
        nArray25[3] = 400;
        nArrayArray7[3] = nArray25;
        int[] nArray26 = new int[4];
        nArray26[2] = 400;
        nArray26[3] = 400;
        nArrayArray7[4] = nArray26;
        int[] nArray27 = new int[4];
        nArray27[2] = 320;
        nArray27[3] = 240;
        nArrayArray7[5] = nArray27;
        int[] nArray28 = new int[4];
        nArray28[2] = 320;
        nArray28[3] = 240;
        nArrayArray7[6] = nArray28;
        m_importModelSize = nArrayArray7;
        int[][] nArrayArray8 = new int[7][];
        nArrayArray8[0] = new int[]{10, 10, 400, 600};
        nArrayArray8[1] = new int[]{10, 10, 400, 600};
        nArrayArray8[2] = new int[]{10, 10, 400, 600};
        int[] nArray29 = new int[4];
        nArray29[2] = 400;
        nArray29[3] = 600;
        nArrayArray8[3] = nArray29;
        int[] nArray30 = new int[4];
        nArray30[2] = 400;
        nArray30[3] = 480;
        nArrayArray8[4] = nArray30;
        int[] nArray31 = new int[4];
        nArray31[2] = 320;
        nArray31[3] = 240;
        nArrayArray8[5] = nArray31;
        int[] nArray32 = new int[4];
        nArray32[2] = 320;
        nArray32[3] = 240;
        nArrayArray8[6] = nArray32;
        m_exportBounds = nArrayArray8;
        m_viewerScreen = "multiple";
        m_viewerVisible = "show";
        m_controlVisible = "hide";
        m_consoleVisible = "hide";
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
    }

    protected PsXmlSrc fillRsrcTree(PsXmlSrc src) {
        PsXmlNode javaview = src.getRootNode();
        if (javaview == null) {
            javaview = new PsXmlNode("javaview-rsrc");
            src.setRootNode(javaview);
        }
        PsXmlNode license = PsXmlSrc.assureChild(javaview, "license");
        license.removeChildren();
        license.addAttribute("license-type", m_licenseType);
        license.addAttribute("license-usage", m_licenseUsage);
        license.addChild("license-id", m_licenseId);
        license.addChild("license-expire", m_licenseExpire);
        PsXmlNode licensee = PsXmlSrc.assureChild(license, "licensee");
        licensee.removeChildren();
        licensee.addChild("firstname", m_licenseeFirstName);
        licensee.addChild("lastname", m_licenseeLastName);
        licensee.addChild("organization", m_licenseeOrganization);
        licensee.addChild("email", m_licenseeEmail);
        licensee.addChild("url", m_licenseeUrl);
        PsXmlNode user = PsXmlSrc.assureChild(javaview, "user");
        user.removeChildren();
        user.addChild("firstname", m_userFirstName);
        user.addChild("lastname", m_userLastName);
        user.addChild("organization", m_userOrganization);
        user.addChild("email", m_userEmail);
        user.addChild("url", m_userUrl);
        return src;
    }
}

