/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PvCameraEvent;
import jv.project.PvCameraListenerIf;
import jv.thirdParty.ruler.PgAxes;
import jv.vecmath.PdVector;
import jv.viewer.PvScene;

public final class PjAxes
extends PsObject
implements PvCameraListenerIf {
    protected PdVector m_viewVect;
    protected PgAxes m_axes;
    protected PgGeometry m_geom;
    protected PvScene m_scene;

    public PjAxes(int dim) {
        this.setName("Variable Axes");
        this.m_axes = new PgAxes(dim);
        this.m_viewVect = new PdVector(0.0, 0.0, -1.0);
        this.init();
    }

    public void dragCamera(PvCameraEvent pos) {
        this.pickCamera(pos);
    }

    public boolean update(Object event) {
        if (event == null) {
            return true;
        }
        PsDebug.notify("called");
        if (event == this.m_geom) {
            this.m_axes.configure(this.m_geom.getBounds(), this.m_viewVect);
            return this.m_axes.update(this.m_axes);
        }
        if (event == this.m_scene) {
            this.m_axes.configure(this.m_scene.getBounds(), this.m_viewVect);
            return this.m_axes.update(this.m_axes);
        }
        if (event == this.m_axes) {
            return super.update(null);
        }
        return super.update(event);
    }

    public void setScene(PvScene scene) {
        this.m_scene = scene;
        this.m_scene.addUpdateListener(this);
    }

    public void pickCamera(PvCameraEvent pos) {
        this.m_viewVect.copy(pos.getViewDir());
        if (this.m_geom != null) {
            this.m_axes.configure(this.m_geom.getBounds(), this.m_viewVect);
        } else if (this.m_scene != null) {
            this.m_axes.configure(this.m_scene.getBounds(), this.m_viewVect);
        } else {
            return;
        }
        this.m_axes.update(this.m_axes);
    }

    public void setGeometry(PgGeometry geom) {
        this.m_geom = geom;
        this.m_geom.addUpdateListener(this);
    }

    public PgAxes getAxes() {
        return this.m_axes;
    }

    public void init() {
        super.init();
        this.m_axes.init();
        this.m_axes.showTitles(true);
        this.m_axes.setMode(2);
    }

    public void removeScene(PvScene scene) {
        if (this.m_scene != scene) {
            PsDebug.warning("scene was not registered.");
            return;
        }
        scene.removeUpdateListener(this);
        this.m_scene = null;
    }

    public void removeGeometry(PgGeometry geom) {
        if (this.m_geom != geom) {
            PsDebug.warning("geometry was not registered.");
            return;
        }
        geom.removeUpdateListener(this);
        this.m_geom = null;
    }
}

