/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jv.vecmath.PdVector;

public class Lamp
extends JPanel {
    JButton colorButton;
    String lastX = "0";
    String lastY = "0";
    String lastZ = "0";
    String lastXj = "0";
    String lastYj = "0";
    String lastZj = "0";
    Project project;
    public int lampNo = 0;
    public JCheckBox cbox = new JCheckBox("", true);
    public int oldFrom = 0;
    public int oldTo = 1;
    public int newFrom = 0;
    public int newTo = 1;
    public JLabel intenseLabel = new JLabel("50");
    public JTextField from = new JTextField("0");
    public JTextField to = new JTextField("100");
    JLabel toLabel = new JLabel("to:");
    JLabel fromLabel = new JLabel("from:");
    JSlider intenseSlider = new JSlider(0, 100);
    public JLabel nameLabel = null;
    public JTextField xPos = new JTextField("0.000");
    public JTextField yPos = new JTextField("1.000");
    public JTextField zPos = new JTextField("0.000");
    JLabel xLabel = new JLabel(" x: ");
    JLabel zLabel = new JLabel(" z: ");
    JLabel yLabel = new JLabel(" y: ");
    JLabel PreviewPic;
    Lamp previewLamp;
    JButton setPos = new JButton("set Pos");
    JButton intensity = new JButton("Intensity");
    LampAdmin lampAdmin;

    Lamp(Project project, LampAdmin lampAdmin, JPanel[] jPanelArray) {
        this.project = project;
        this.lampAdmin = lampAdmin;
        this.nameLabel = new JLabel("  " + this.lampNo + " ");
        jPanelArray[0].add(this.nameLabel);
        this.PreviewPic = new JLabel();
        jPanelArray[1].add(this.setPos);
        jPanelArray[2].add(this.xPos);
        jPanelArray[3].add(this.yPos);
        jPanelArray[4].add(this.zPos);
        this.setPos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Lamp.this.updateLampAdmin();
            }
        });
        this.intenseSlider.setValue(50);
        this.intenseSlider.setMinorTickSpacing(1);
        this.intenseSlider.setMajorTickSpacing(10);
        this.intenseSlider.setPaintTicks(true);
        this.intenseSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Lamp.this.updateintenseSliderLabel();
            }
        });
        jPanelArray[5].add(this.intenseSlider);
        this.colorButton = new JButton();
        this.colorButton.setBackground(new Color(0, 180, 240));
        this.colorButton.setToolTipText("Select the \"light\" color");
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Lamp.this.setColor(JColorChooser.showDialog(null, "Change light color", Lamp.this.colorButton.getBackground()));
            }
        });
        jPanelArray[6].add(this.colorButton);
        jPanelArray[7].add(this.cbox);
    }

    public synchronized void updateLampAdmin() {
        this.lampAdmin.setSelectedLamp(this.lampNo - 1);
    }

    Lamp(Project project, LampAdmin lampAdmin) {
        this.project = project;
        this.lampAdmin = lampAdmin;
        this.intenseSlider.setValue(50);
        this.colorButton = new JButton();
        this.colorButton.setBackground(new Color(0, 180, 240));
    }

    public Lamp previewLamp(double d, double d2, double d3) {
        this.previewLamp = this.getNewLamp(d, d2, d3, this.colorButton.getBackground(), this.getVol(), this.isShining());
        return this.previewLamp;
    }

    public Lamp getNewLamp(double d, double d2, double d3, Color color, int n, boolean bl) {
        Lamp lamp = new Lamp(this.project, this.lampAdmin);
        lamp.setKoords(d, d2, d3);
        lamp.setIntensity(n);
        lamp.setColor(color);
        lamp.setIsShining(bl);
        return lamp;
    }

    public void setColor(Color color) {
        this.colorButton.setBackground(color);
        if (this.previewLamp != null) {
            this.previewLamp.setColor(color);
        }
    }

    public int getIntensity() {
        return this.intenseSlider.getValue();
    }

    public void setIntensity(int n) {
        this.intenseSlider.setValue(n);
        this.updateintenseSliderLabel();
        if (this.previewLamp != null) {
            this.previewLamp.setIntensity(n);
        }
    }

    public synchronized void updateintenseSliderLabel() {
        this.intenseLabel.setText("" + this.intenseSlider.getValue());
    }

    public void setKoords(double d, double d2, double d3) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(3);
        numberFormat.setMinimumFractionDigits(3);
        String string = numberFormat.format(d);
        int n = 0;
        while (string.compareTo("") != 0 && ++n < 10) {
            string = numberFormat.format(d);
        }
        this.xPos.setText(string);
        n = 0;
        String string2 = numberFormat.format(d2);
        while (string2.compareTo("") != 0 && ++n < 10) {
            string2 = numberFormat.format(d2);
        }
        this.yPos.setText(string2);
        n = 0;
        String string3 = numberFormat.format(d3);
        while (string3.compareTo("") != 0 && ++n < 10) {
            string3 = numberFormat.format(d3);
        }
        this.zPos.setText(string3);
    }

    public void setColor(int n, int n2, int n3) {
        this.colorButton.setBackground(new Color(n, n2, n3));
        if (this.previewLamp != null) {
            this.previewLamp.setColor(n, n2, n3);
        }
    }

    public boolean isSelected() {
        return this.cbox.isSelected();
    }

    public void setIsShining(boolean bl) {
        this.cbox.setSelected(bl);
        if (this.previewLamp != null) {
            this.previewLamp.setIsShining(bl);
        }
    }

    public String vec2Str(double[] dArray) {
        return "<" + dArray[0] + "," + dArray[1] + "," + dArray[2] + ">";
    }

    public PdVector getPos() {
        return new PdVector(this.getXpos(), this.getYpos(), this.getZpos());
    }

    public double getVecLength() {
        return Math.sqrt(Math.pow(this.getXpos(), 2.0) + Math.pow(this.getYpos(), 2.0) + Math.pow(this.getZpos(), 2.0));
    }

    public boolean isShining() {
        return this.cbox.isSelected();
    }

    public void setSelected(boolean bl) {
        if (this.previewLamp != null) {
            this.previewLamp.setSelected(bl);
        }
        if (bl) {
            this.setPos.setBackground(new Color(0, 255, 0));
        } else {
            this.setPos.setBackground(null);
        }
        this.setPos.repaint();
    }

    public synchronized String getXpos_str() {
        String string = "";
        while (string.compareTo("") == 0) {
            string = this.xPos.getText();
        }
        return string;
    }

    public synchronized String getYpos_str() {
        String string = "";
        while (string.compareTo("") == 0) {
            string = this.yPos.getText();
        }
        return string;
    }

    public synchronized String getZpos_str() {
        String string = "";
        while (string.compareTo("") == 0) {
            string = this.zPos.getText();
        }
        return string;
    }

    public synchronized double getXpos() {
        String string = "";
        while (string.compareTo("") == 0) {
            string = this.xPos.getText();
        }
        return Double.valueOf(string);
    }

    public synchronized double getYpos() {
        String string = "";
        while (string.compareTo("") == 0) {
            string = this.yPos.getText();
        }
        return Double.valueOf(string);
    }

    public synchronized double getZpos() {
        String string = "";
        while (string.compareTo("") == 0) {
            string = this.zPos.getText();
        }
        return Double.valueOf(string);
    }

    public int getVol() {
        return this.getIntensity();
    }

    public int getRed() {
        return this.colorButton.getBackground().getRed();
    }

    public int getGreen() {
        return this.colorButton.getBackground().getGreen();
    }

    public int getBlue() {
        return this.colorButton.getBackground().getBlue();
    }

    public void setLampNo(int n) {
        if (this.previewLamp != null) {
            this.previewLamp.setLampNo(n);
        }
        this.lampNo = n;
        this.nameLabel.setText("   " + this.lampNo);
    }

    public void updateActionCommands(int n) {
    }

    public String getSurfCode(int n, String[] stringArray, double[] dArray) {
        String string = "";
        string = string + "light" + n + "_x =" + this.evalWithPar(this.getXpos_str(), stringArray, dArray) + ";\n";
        string = string + "light" + n + "_y =" + this.evalWithPar(this.getYpos_str(), stringArray, dArray) + ";\n";
        string = string + "light" + n + "_z =" + this.evalWithPar(this.getZpos_str(), stringArray, dArray) + ";\n";
        string = string + "light" + n + "_vol =" + this.getVol() + ";\n";
        string = string + "light" + n + "_red =" + this.getRed() + ";\n";
        string = string + "light" + n + "_green =" + this.getGreen() + ";\n";
        string = string + "light" + n + "_blue =" + this.getBlue() + ";\n";
        return string;
    }

    public double evalWithPar(String string, String[] stringArray, double[] dArray) {
        boolean bl = false;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string.replaceAll(stringArray[i], new Double(dArray[i]).toString());
            }
        }
        string = string.replaceAll(" ", "");
        string = string.replaceAll("\\*", " ");
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public void saveYourself(PrintWriter printWriter) {
        String string = "";
        printWriter.println("////////////////// Parameter: /////////////////////////\n");
        printWriter.println("" + this.lampNo + "\n");
        printWriter.println("" + this.newFrom + "\n");
        printWriter.println("" + this.newTo + "\n");
        printWriter.println("" + this.intenseSlider.getValue() + "\n");
    }

    public String saveYourself() {
        String string = "";
        string = string + "////////////////// Parameter: /////////////////////////\n";
        string = string + "" + this.lampNo + "\n";
        string = string + "" + this.newFrom + "\n";
        string = string + "" + this.newTo + "\n";
        string = string + "" + this.intenseSlider.getValue() + "\n";
        return string;
    }
}

