/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import jv.object.PsConfig;
import jv.object.PsDebug;

public class PgFileDialog
extends FileDialog {
    protected static String m_dir = null;
    protected String m_ext = null;

    public PgFileDialog(Frame frame, String title, int mode) {
        super(frame, title, mode);
    }

    public String getDirectory() {
        if (m_dir == null) {
            m_dir = super.getDirectory();
        }
        return m_dir;
    }

    public void setDirectory(String dirName) {
        String osName;
        if (dirName == null) {
            return;
        }
        if (PsConfig.isApplication() && (osName = PsConfig.getOSName()) != null && osName.toLowerCase().startsWith("win")) {
            dirName = dirName.replace('/', '\\');
        }
        m_dir = dirName;
        super.setDirectory(m_dir);
    }

    public void setVisible(boolean flag) {
        if (flag) {
            if (m_dir == null) {
                String codeBase = PsConfig.getCodeBase();
                this.setDirectory(codeBase);
            }
            if (this.getFile() == null) {
                if (this.m_ext != null) {
                    super.setFile("javaview." + this.m_ext);
                } else {
                    super.setFile("javaview.txt");
                }
            }
        }
        super.setVisible(true);
        if (this.getFile() != null) {
            m_dir = super.getDirectory();
        }
    }

    public String getFullFileName() {
        String file = this.getFile();
        if (file == null) {
            return null;
        }
        String dir = this.getDirectory();
        if (dir == null) {
            return null;
        }
        String fullName = dir + file;
        return fullName.trim();
    }

    public void setExtension(String ext) {
        this.m_ext = ext;
    }

    public File openFile() {
        if (this.getDirectory() == null || this.getFile() == null) {
            PsDebug.warning("missing dir or file name");
            return null;
        }
        File file = null;
        file = PsConfig.isApplication() ? new File(this.getDirectory() + this.getFile()) : new File(this.getFile());
        if (file == null) {
            PsDebug.warning("could not open file = " + this.getFile() + " in directory = " + this.getDirectory());
        }
        return file;
    }
}

