/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import jv.geom.PgPointSet_IP;
import jv.geom.PgPolygonSet;
import jv.number.PiArray_IP;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;

public class PgPolygonSet_IP
extends PgPointSet_IP {
    protected PgPolygonSet m_polygonSet;
    protected TextField m_tNumPolygons;
    protected Label m_tDimPolygons;
    protected Panel m_pNumPolygons;
    protected PiArray_IP m_polygonPanel;
    protected int m_maxVisibleVectors = 5;
    protected int m_maxVisibleDim = 5;
    protected static String[] m_header = new String[]{"0", "1", "2", "3", "4"};
    private static /* synthetic */ Class class$jv$geom$PgPolygonSet_IP;

    public PgPolygonSet_IP() {
        if (this.getClass() == (class$jv$geom$PgPolygonSet_IP != null ? class$jv$geom$PgPolygonSet_IP : (class$jv$geom$PgPolygonSet_IP = PgPolygonSet_IP.class$("jv.geom.PgPolygonSet_IP")))) {
            this.init();
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_polygonSet = (PgPolygonSet)parent;
    }

    public boolean update(Object anObject) {
        PsDebug.notify("called");
        if (this.m_polygonSet == null) {
            PsDebug.warning("missing polygonSet");
            return true;
        }
        if (anObject == this.m_polygonSet) {
            this.m_bInteractive = false;
            ((TextComponent)this.m_tNumPolygons).setText(String.valueOf(this.m_polygonSet.getNumPolygons()));
            int dim = this.m_polygonSet.m_dimOfPolygons;
            if (dim == -1) {
                this.m_tDimPolygons.setText(PsConfig.getMessage("tDimPolygons"));
            } else {
                this.m_tDimPolygons.setText(String.valueOf(dim));
            }
            this.m_polygonPanel.setBounds(0, this.m_polygonSet.getNumVertices() - 1);
            this.m_polygonPanel.setVector(this.m_polygonSet.getPolygons(), m_header, this.m_polygonSet.getNumPolygons(), this.m_polygonSet.m_dimOfPolygons);
            this.m_bInteractive = true;
            return super.update(anObject);
        }
        if (anObject == this.m_polygonPanel) {
            this.m_polygonSet.update(this);
            return true;
        }
        return super.update(anObject);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void init() {
        super.init();
        this.addLine(1);
        Panel pNumPolygons = new Panel();
        pNumPolygons.setLayout(new GridLayout(2, 2));
        this.add(pNumPolygons);
        Label lNumPolygons = new Label(PsConfig.getMessage("lNumPolygons"));
        pNumPolygons.add(lNumPolygons);
        this.m_tNumPolygons = new TextField("0", 7);
        this.m_tNumPolygons.addTextListener(this);
        pNumPolygons.add(this.m_tNumPolygons);
        Label lDimPolygons = new Label(PsConfig.getMessage("lDimPolygons"));
        pNumPolygons.add(lDimPolygons);
        this.m_tDimPolygons = new Label("");
        pNumPolygons.add(this.m_tDimPolygons);
        this.m_polygonPanel = new PiArray_IP(this.m_maxVisibleVectors, this.m_maxVisibleDim);
        this.m_polygonPanel.setParent(this);
        this.add(this.m_polygonPanel);
    }

    public void textValueChanged(TextEvent event) {
        if (!this.m_bInteractive) {
            return;
        }
        Object source = event.getSource();
        if (source == this.m_tNumPolygons) {
            String text = this.m_tNumPolygons.getText();
            if (text == null || text.equals("")) {
                return;
            }
            try {
                int num = Integer.parseInt(text);
                if (num != this.m_polygonSet.getNumPolygons()) {
                    this.m_polygonSet.setNumPolygons(num);
                    this.m_polygonPanel.setBounds(0, this.m_polygonSet.getNumVertices() - 1);
                    this.m_polygonPanel.setVector(this.m_polygonSet.getPolygons(), m_header, num, this.m_polygonSet.m_dimOfPolygons);
                }
                this.m_polygonSet.update(this);
            }
            catch (NumberFormatException e) {
                PsDebug.warning("wrong format = " + text);
                return;
            }
        } else {
            super.textValueChanged(event);
        }
    }
}

