/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;

public class PiArray_IP
extends PsPanel
implements ActionListener,
AdjustmentListener,
ItemListener {
    protected PiVector[] m_vector;
    protected Scrollbar m_scroll;
    protected Panel m_coordPanel;
    protected TextField[][] m_text;
    protected Label[] m_headerLabel;
    protected Checkbox[] m_indexLabel;
    protected int m_index = 0;
    protected int m_shownDim = 0;
    protected int m_shownVectors = 0;
    protected int m_maxVisibleDim = 5;
    protected int m_maxVisibleVectors = 5;
    protected int m_minValue = Integer.MIN_VALUE;
    protected int m_maxValue = Integer.MAX_VALUE;
    private static /* synthetic */ Class class$jv$number$PiArray_IP;

    public void adjustmentValueChanged(AdjustmentEvent event) {
        Object source = event.getSource();
        if (source == this.m_scroll) {
            if (this.m_index == this.m_scroll.getValue()) {
                return;
            }
            this.m_index = this.m_scroll.getValue();
            PsDebug.notify("setValue=" + this.m_index);
            int i = 0;
            while (i < this.m_shownVectors) {
                PiVector vec = this.m_vector[i + this.m_index];
                this.m_indexLabel[i].setLabel(String.valueOf(i + this.m_index));
                this.m_indexLabel[i].setState(vec.hasTag(1));
                int maxLen = Math.min(this.m_shownDim, vec.getSize());
                int j = 0;
                while (j < maxLen) {
                    if (this.m_minValue <= vec.m_data[j] && vec.m_data[j] <= this.m_maxValue) {
                        ((TextComponent)this.m_text[i][j]).setText(String.valueOf(vec.m_data[j]));
                    }
                    ++j;
                }
                j = maxLen;
                while (j < this.m_shownDim) {
                    ((TextComponent)this.m_text[i][j]).setText("");
                    ++j;
                }
                ++i;
            }
        }
    }

    public PiArray_IP(int visibleVectors, int visibleDim) {
        this.m_maxVisibleVectors = visibleVectors;
        this.m_maxVisibleDim = visibleDim;
        if (this.getClass() == (class$jv$number$PiArray_IP != null ? class$jv$number$PiArray_IP : (class$jv$number$PiArray_IP = PiArray_IP.class$("jv.number.PiArray_IP")))) {
            this.init();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object source = event.getSource();
        int i = 0;
        while (i < this.m_shownVectors) {
            if (source == this.m_indexLabel[i]) {
                PiVector vec = this.m_vector[i + this.m_index];
                if (this.m_indexLabel[i].getState()) {
                    vec.setTag(1);
                } else {
                    vec.clearTag(1);
                }
                if (this.m_parent != null) {
                    this.m_parent.update(this);
                } else {
                    PsDebug.warning("missing parent");
                }
                return;
            }
            ++i;
        }
    }

    public void setVector(PiVector[] vector, String[] header, int numVectors, int dim) {
        if (dim < 0) {
            dim = this.m_maxVisibleDim;
        }
        if (header == null || vector == null) {
            PsDebug.warning("missing or empty argument");
            return;
        }
        this.m_vector = vector;
        if (!this.setNumOfEntries(numVectors, dim)) {
            PsDebug.error("invalid length", this);
            return;
        }
        if (this.m_index >= numVectors - this.m_shownVectors) {
            this.m_index = Math.max(0, numVectors - this.m_shownVectors);
        }
        this.m_scroll.setValues(this.m_index, 1, 0, Math.max(0, numVectors - this.m_shownVectors + 1));
        int j = 0;
        while (j < this.m_shownDim) {
            this.m_headerLabel[j].setText(header[j]);
            ++j;
        }
        int i = 0;
        while (i < this.m_shownVectors) {
            this.m_indexLabel[i].setLabel(String.valueOf(i + this.m_index));
            this.m_indexLabel[i].setState(this.m_vector[i + this.m_index].hasTag(1));
            int maxLen = Math.min(this.m_shownDim, this.m_vector[i + this.m_index].getSize());
            j = 0;
            while (j < maxLen) {
                ((TextComponent)this.m_text[i][j]).setText(String.valueOf(this.m_vector[i + this.m_index].m_data[j]));
                ++j;
            }
            j = maxLen;
            while (j < this.m_shownDim) {
                ((TextComponent)this.m_text[i][j]).setText("");
                ++j;
            }
            ++i;
        }
        if (this.m_shownVectors < this.m_maxVisibleVectors) {
            i = this.m_shownVectors;
            while (i < this.m_maxVisibleVectors) {
                this.m_indexLabel[i].setLabel("");
                this.m_indexLabel[i].setState(false);
                j = 0;
                while (j < this.m_shownDim) {
                    ((TextComponent)this.m_text[i][j]).setText("");
                    ++j;
                }
                ++i;
            }
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
    }

    public boolean update(Object anObject) {
        PsDebug.notify("isShowing = " + this.isShowing());
        if (this.m_parent == null) {
            PsDebug.warning("missing parent");
            return true;
        }
        if (anObject == this.m_parent) {
            int i = 0;
            int j = 0;
            try {
                i = 0;
                while (i < this.m_shownVectors) {
                    PiVector vec = this.m_vector[i + this.m_index];
                    this.m_indexLabel[i].setLabel(String.valueOf(i + this.m_index));
                    this.m_indexLabel[i].setState(vec.hasTag(1));
                    int maxLen = Math.min(this.m_shownDim, vec.getSize());
                    j = 0;
                    while (j < maxLen) {
                        if (this.m_minValue <= vec.m_data[j] && vec.m_data[j] <= this.m_maxValue) {
                            ((TextComponent)this.m_text[i][j]).setText(String.valueOf(vec.m_data[j]));
                        }
                        ++j;
                    }
                    j = maxLen;
                    while (j < this.m_shownDim) {
                        ((TextComponent)this.m_text[i][j]).setText("");
                        ++j;
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                PsDebug.warning("wrong format = " + this.m_text[i][j].getText());
                return false;
            }
            return true;
        }
        return super.update(anObject);
    }

    public void actionPerformed(ActionEvent event) {
        PsDebug.notify("entered");
        Object source = event.getSource();
        int i = 0;
        while (i < this.m_shownVectors) {
            PiVector vec = this.m_vector[i + this.m_index];
            int j = 0;
            while (j < this.m_shownDim) {
                if (source == this.m_text[i][j]) {
                    if (j >= vec.getSize()) {
                        vec.setSize(j + 1);
                        PsDebug.warning("empty field edited, j=" + j);
                    }
                    PsDebug.notify("text[" + i + "][" + j + "] modified");
                    try {
                        int val = Integer.parseInt(this.m_text[i][j].getText());
                        if (this.m_minValue <= val && val <= this.m_maxValue) {
                            vec.m_data[j] = val;
                        } else {
                            PsDebug.warning("value out of range = " + val);
                            ((TextComponent)this.m_text[i][j]).setText(String.valueOf(vec.m_data[j]));
                        }
                    }
                    catch (NumberFormatException e) {
                        PsDebug.warning("wrong format = " + this.m_text[i][j].getText());
                        return;
                    }
                    this.m_parent.update(this);
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public boolean setNumOfEntries(int num, int dim) {
        if (num == -1) {
            num = this.m_maxVisibleVectors;
        }
        if (dim == -1) {
            dim = this.m_maxVisibleDim;
        }
        if (this.m_shownDim == Math.min(this.m_maxVisibleDim, dim) && this.m_shownVectors == Math.min(this.m_maxVisibleVectors, num)) {
            return true;
        }
        if (num > this.m_maxVisibleVectors) {
            PsDebug.notify("num of vecs=" + num + " too large");
        }
        if (dim > this.m_maxVisibleDim) {
            PsDebug.notify("dimension=" + dim + " too large");
        }
        this.m_coordPanel.removeAll();
        this.m_shownVectors = Math.min(this.m_maxVisibleVectors, num);
        this.m_shownDim = Math.min(this.m_maxVisibleDim, dim);
        this.m_coordPanel.setLayout(new GridLayout(this.m_maxVisibleVectors + 1, this.m_shownDim));
        this.m_headerLabel = new Label[this.m_shownDim];
        int j = 0;
        while (j < this.m_shownDim) {
            this.m_headerLabel[j] = new Label("", 1);
            this.m_coordPanel.add(this.m_headerLabel[j]);
            ++j;
        }
        this.m_text = new TextField[this.m_maxVisibleVectors][];
        int i = 0;
        while (i < this.m_maxVisibleVectors) {
            this.m_text[i] = new TextField[this.m_shownDim];
            j = 0;
            while (j < this.m_shownDim) {
                this.m_text[i][j] = new TextField(10);
                this.m_text[i][j].addActionListener(this);
                this.m_coordPanel.add(this.m_text[i][j]);
                ++j;
            }
            ++i;
        }
        this.m_coordPanel.validate();
        return true;
    }

    public void setBounds(int min, int max) {
        if (min > max) {
            return;
        }
        this.m_minValue = min;
        this.m_maxValue = max;
    }

    public void init() {
        super.init();
        this.setLayout(new BorderLayout());
        Panel indexPanel = new Panel();
        indexPanel.setLayout(new BorderLayout());
        indexPanel.add("North", new Label(PsConfig.getMessage("Index"), 2));
        this.m_scroll = new Scrollbar(1);
        this.m_scroll.addAdjustmentListener(this);
        indexPanel.add("West", this.m_scroll);
        Panel pIndex = new Panel();
        pIndex.setLayout(new GridLayout(this.m_maxVisibleVectors, 1));
        this.m_indexLabel = new Checkbox[this.m_maxVisibleVectors];
        int i = 0;
        while (i < this.m_maxVisibleVectors) {
            this.m_indexLabel[i] = new Checkbox(String.valueOf(i));
            this.m_indexLabel[i].addItemListener(this);
            pIndex.add(this.m_indexLabel[i]);
            ++i;
        }
        indexPanel.add("Center", pIndex);
        this.m_coordPanel = new Panel();
        this.add("West", indexPanel);
        this.add("Center", this.m_coordPanel);
    }
}

