/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JSlider;
import javax.swing.JTextField;

public class LampAdminUpdater
extends Thread {
    double lastjv4sxScale = 0.0;
    double[] lastCamPos = new double[]{0.0, 0.0, 0.0};
    double[] lastCamRot = new double[]{0.0, 0.0, 0.0};
    double eps = 1.0E-4;
    int zoomFac = 1;
    String lastx = "0";
    String lasty = "0";
    String lastz = "0";
    String lastx2 = "0";
    String lasty2 = "0";
    String lastz2 = "0";
    double lastzoom = 0.0;
    double factor;
    double scaleMin;
    double scaleMax;
    jv4surfex jv4sx;
    JTextField x = new JTextField("0");
    JTextField y = new JTextField("0");
    JTextField z = new JTextField("0");
    JTextField x2 = new JTextField("0");
    JTextField y2 = new JTextField("0");
    JTextField z2 = new JTextField("0");
    JSlider zoom;
    int genauigkeit = 8;
    int timedist = 5;

    LampAdminUpdater() {
    }

    LampAdminUpdater(double d, double d2, double d3) {
        this.scaleMin = d2;
        this.scaleMax = d3;
        this.factor = 1.0 / d * (this.scaleMax - this.scaleMin) / 1000.0;
    }

    public void setScaleMinMax(double d, double d2) {
        this.scaleMin = d;
        this.scaleMax = d2;
        this.factor = 1.0 * (d2 - d) / 1000.0;
    }

    public synchronized void setSlider(JSlider jSlider) {
        this.zoom = jSlider;
    }

    public synchronized void setPosTextFields(JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        this.x = jTextField;
        this.y = jTextField2;
        this.z = jTextField3;
    }

    public synchronized void setPosTextFields2(JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        this.x2 = jTextField;
        this.y2 = jTextField2;
        this.z2 = jTextField3;
    }

    public synchronized void setJv4sx(jv4surfex jv4surfex2) {
        this.jv4sx = jv4surfex2;
    }

    public void run() {
        while (true) {
            try {
                LampAdminUpdater.sleep(this.timedist);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.check(this.jv4sx.getCamPos(), this.lastCamPos)) {
                this.update();
                continue;
            }
            if ((double)this.zoom.getValue() != this.lastzoom) {
                this.updateZoom();
                continue;
            }
            if (this.x.getText().compareTo(this.lastx) != 0 || this.y.getText().compareTo(this.lasty) != 0 || this.z.getText().compareTo(this.lastz) != 0) {
                this.updatePos();
                continue;
            }
            if (this.x2.getText().compareTo(this.lastx2) == 0 && this.y2.getText().compareTo(this.lasty2) == 0 && this.z2.getText().compareTo(this.lastz2) == 0) continue;
            this.updatePos2();
        }
    }

    public synchronized boolean check(double[] dArray, double[] dArray2) {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] - dArray2[i] > this.eps)) continue;
            return true;
        }
        return false;
    }

    public synchronized void update() {
        double[] dArray = this.jv4sx.getCamPos();
        if (dArray[0] < this.lastCamPos[0] * 100.0) {
            this.x.setText(this.getString(dArray[0] + ""));
            this.y.setText(this.getString(dArray[1] + ""));
            this.z.setText(this.getString(dArray[2] + ""));
            this.x2.setText(this.getString(dArray[0] + ""));
            this.y2.setText(this.getString(dArray[1] + ""));
            this.z2.setText(this.getString(dArray[2] + ""));
            this.zoom.setValue((int)((this.jv4sx.getScale() - this.scaleMin) / (this.scaleMax - this.scaleMin) * 1000.0 + 0.5));
            this.updateLast();
        } else {
            this.updateZoom();
        }
    }

    public synchronized void updateZoom() {
        this.jv4sx.setScale(this.scaleMin + (double)this.zoom.getValue() / 1000.0 * (this.scaleMax - this.scaleMin));
        double[] dArray = this.jv4sx.getCamPos();
        this.x.setText(this.getString(dArray[0] + ""));
        this.y.setText(this.getString(dArray[1] + ""));
        this.z.setText(this.getString(dArray[2] + ""));
        this.x2.setText(this.getString(dArray[0] + ""));
        this.y2.setText(this.getString(dArray[1] + ""));
        this.z2.setText(this.getString(dArray[2] + ""));
        this.jv4sx.updateDisp();
        this.updateLast();
    }

    public synchronized void updatePos() {
        this.jv4sx.setCamPos2(Double.valueOf(this.x.getText() + "0"), Double.valueOf(this.y.getText() + "0"), Double.valueOf(this.z.getText() + "0"));
        this.zoom.setValue((int)((this.jv4sx.getScale() - this.scaleMin) / (this.scaleMax - this.scaleMin) * 1000.0 + 0.5));
        this.x2.setText(this.getString(this.x.getText()));
        this.y2.setText(this.getString(this.y.getText()));
        this.z2.setText(this.getString(this.z.getText()));
        this.jv4sx.updateDisp();
        this.updateLast();
    }

    public synchronized void updatePos2() {
        this.jv4sx.setCamPos2(Double.valueOf(this.x2.getText() + "0"), Double.valueOf(this.y2.getText() + "0"), Double.valueOf(this.z2.getText() + "0"));
        this.zoom.setValue((int)((this.jv4sx.getScale() - this.scaleMin) / (this.scaleMax - this.scaleMin) * 1000.0 + 0.5));
        this.x.setText(this.getString(this.x2.getText()));
        this.y.setText(this.getString(this.y2.getText()));
        this.z.setText(this.getString(this.z2.getText()));
        this.jv4sx.updateDisp();
        this.updateLast();
    }

    public synchronized void updateLast() {
        this.lastjv4sxScale = this.jv4sx.getScale();
        this.lastCamPos = this.jv4sx.getCamPos();
        this.lastCamRot = this.jv4sx.getCameraRotationYXZ();
        this.lastx = this.x.getText();
        this.lasty = this.y.getText();
        this.lastz = this.z.getText();
        this.lastx2 = this.x2.getText();
        this.lasty2 = this.y2.getText();
        this.lastz2 = this.z2.getText();
        this.lastzoom = this.zoom.getValue();
    }

    public synchronized String getString(String string) {
        return (string + "          ").substring(0, 8).replaceAll(" ", "");
    }
}

