/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import jv.object.PsDebug;

public abstract class PuString {
    public static int indexOfStringIgnoreCase(String[] strings, String string) {
        int i = 0;
        while (i < strings.length) {
            if (string.equalsIgnoreCase(strings[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int fromCharSet(String str, String charSet, int fromIdx) {
        int i = fromIdx;
        while (i < str.length()) {
            if (charSet.indexOf(str.charAt(i)) == -1) break;
            ++i;
        }
        return i - fromIdx;
    }

    public static int indexOfString(String[] strings, String string) {
        int i = 0;
        while (i < strings.length) {
            if (string.equals(strings[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String bracketedString(String str, char leftDelim, char rightDelim) {
        if (str == null) {
            return null;
        }
        int leftInd = str.indexOf(leftDelim);
        int rightInd = str.lastIndexOf(rightDelim);
        if (leftInd == -1 && rightInd == -1) {
            return null;
        }
        if (leftInd == -1 && rightInd != -1 || leftInd != -1 && rightInd == -1) {
            PsDebug.warning("missing delimiter in string.");
            return null;
        }
        if (leftInd == rightInd - 1) {
            return "";
        }
        return str.substring(leftInd + 1, rightInd);
    }

    public static String intToString(int i, int width) {
        boolean neg = false;
        if (i < 0) {
            neg = true;
            i *= -1;
        }
        if ((double)i >= Math.pow(10.0, width - 1)) {
            PsDebug.warning("string width too small.");
            i = (int)Math.pow(10.0, width - 1) - 1;
        }
        String s = Long.toString(i);
        if (neg) {
            s = "-" + s;
        }
        while (s.length() < width) {
            s = " " + s;
        }
        return s;
    }

    public static void sort(String[] strings) {
        if (strings == null) {
            return;
        }
        int i = 0;
        while (i < strings.length - 1) {
            int j = i + 1;
            while (j < strings.length) {
                if (strings[i].compareTo(strings[j]) > 0) {
                    String t = strings[i];
                    strings[i] = strings[j];
                    strings[j] = t;
                }
                ++j;
            }
            ++i;
        }
    }

    public static String[] sort(String[] origStrings, int[] index) {
        if (origStrings == null || index == null) {
            PsDebug.warning("missing argument.");
            return null;
        }
        if (origStrings.length != index.length) {
            PsDebug.warning("argument arrays have different size.");
            return null;
        }
        String[] strings = new String[origStrings.length];
        int i = 0;
        while (i < strings.length - 1) {
            strings[i] = origStrings[i];
            ++i;
        }
        i = 0;
        while (i < strings.length - 1) {
            int j = i + 1;
            while (j < strings.length) {
                if (strings[i].compareTo(strings[j]) > 0) {
                    String t = strings[i];
                    strings[i] = strings[j];
                    strings[j] = t;
                }
                ++j;
            }
            ++i;
        }
        return strings;
    }

    public static String doubleToString(double d, int mantissa, int width) {
        if (mantissa < 1 || width - mantissa < 3) {
            return null;
        }
        long l = Math.round(d * Math.pow(10.0, mantissa));
        boolean neg = false;
        if (l < 0L) {
            neg = true;
            l *= -1L;
        }
        if ((double)l >= Math.pow(10.0, width - 2)) {
            l = (long)Math.pow(10.0, width - 2) - 1L;
        }
        String m = Long.toString(l);
        while (m.length() < mantissa + 1) {
            m = "0" + m;
        }
        if (neg) {
            m = "-" + m;
        }
        while (m.length() < width - 1) {
            m = " " + m;
        }
        m = m.substring(0, width - mantissa - 1) + "." + m.substring(width - mantissa - 1);
        return m;
    }

    public static String doubleToString(double d, int mantissa) {
        int e;
        if (mantissa < 1) {
            return null;
        }
        String m = Double.toString(d);
        int i = m.indexOf("E");
        if (i == -1) {
            e = 0;
        } else {
            e = Integer.valueOf(m.substring(i + 1));
            m = m.substring(0, i);
        }
        if (m.charAt(0) != '-') {
            m = " " + m;
        }
        i = m.indexOf(".");
        m = m.substring(0, i) + m.substring(i + 1);
        e += i - 2;
        while (m.length() > 2 && m.charAt(1) == '0') {
            m = m.substring(0, 1) + m.substring(2);
            --e;
        }
        if (m.charAt(1) == '0') {
            e = 0;
        }
        while (m.length() < mantissa + 2) {
            m = m + "0";
        }
        while (m.length() > mantissa + 2 && m.charAt(m.length() - 1) == '0') {
            m = m.substring(0, m.length() - 1);
        }
        if (m.length() > mantissa + 2 && (m = Long.toString(Math.round(Double.valueOf(m.substring(0, mantissa + 2) + "." + m.substring(mantissa + 2))))).charAt(0) != '-') {
            m = " " + m;
        }
        if (m.length() > mantissa + 2) {
            m = m.substring(0, mantissa + 2);
            ++e;
        }
        if (e >= 100) {
            e = 99;
            m = m.substring(0, 1);
            while (m.length() < mantissa + 2) {
                m = m + "9";
            }
        }
        if (e <= -100) {
            e = 0;
            m = " ";
            while (m.length() < mantissa + 2) {
                m = m + "0";
            }
        }
        m = m.substring(0, 2) + "." + m.substring(2) + "E" + Integer.toString(e);
        if (e < 0) {
            e *= -1;
        } else {
            m = m.substring(0, mantissa + 4) + "+" + m.substring(mantissa + 4);
        }
        if (e < 10) {
            m = m.substring(0, mantissa + 5) + "0" + m.substring(mantissa + 5);
        }
        return m;
    }

    public static int commonInitials(String str1, String str2) {
        int i = 0;
        while (i < str1.length() && i < str2.length() && str1.charAt(i) == str2.charAt(i)) {
            ++i;
        }
        return i;
    }

    public static String mergeStrings(String[] str, char delim) {
        if (str == null || str.length == 0 || str[0] == null) {
            return "";
        }
        String merge = new String(str[0]);
        int i = 1;
        while (i < str.length) {
            merge = str[i] != null ? merge + delim + str[i] : merge + delim;
            ++i;
        }
        return merge;
    }

    public static boolean matchPattern(String string, String pattern) {
        int p = 0;
        while (true) {
            int s = 0;
            while (true) {
                boolean pEnd;
                boolean sEnd = s >= string.length();
                boolean bl = pEnd = p >= pattern.length() || pattern.charAt(p) == '|';
                if (sEnd && pEnd) {
                    return true;
                }
                if (sEnd || pEnd) break;
                if (pattern.charAt(p) != '?') {
                    if (pattern.charAt(p) == '*') {
                        ++p;
                        int i = string.length();
                        while (i >= s) {
                            if (PuString.matchPattern(pattern.substring(p), string.substring(i))) {
                                return true;
                            }
                            --i;
                        }
                        break;
                    }
                    if (pattern.charAt(p) != string.charAt(s)) break;
                }
                ++p;
                ++s;
            }
            if ((p = pattern.indexOf(124, p)) == -1) {
                return false;
            }
            ++p;
        }
    }

    public static int containsChars(String str, char c) {
        int n = 0;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == c) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static String[][] clone(String[][] src) {
        String[][] clone = (String[][])src.clone();
        if (clone == null) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            clone[i] = (String[])src[i].clone();
            ++i;
        }
        return clone;
    }

    public static int notFromCharSet(String str, String charSet, int fromIdx) {
        int i = fromIdx;
        while (i < str.length()) {
            if (charSet.indexOf(str.charAt(i)) != -1) break;
            ++i;
        }
        return i - fromIdx;
    }

    public static String[] splitString(String str, char delim) {
        int nextIndex;
        if (str == null) {
            return null;
        }
        boolean bBlank = delim == ' ';
        int len = str.length();
        while (str.lastIndexOf(delim) == len) {
            str = str.substring(0, --len);
        }
        int n = 1;
        int index = -1;
        while ((nextIndex = str.indexOf(delim, index + 1)) != -1) {
            if (bBlank && nextIndex == index + 1) {
                index = nextIndex;
                continue;
            }
            index = nextIndex;
            ++n;
        }
        String[] strs = new String[n];
        index = -1;
        int i = 0;
        while (i < n) {
            int nextIndex2 = str.indexOf(delim, index + 1);
            if (nextIndex2 == -1) {
                strs[n - 1] = str.substring(index + 1);
                break;
            }
            if (bBlank && nextIndex2 == index + 1) {
                index = nextIndex2;
                continue;
            }
            strs[i++] = str.substring(index + 1, nextIndex2);
            index = nextIndex2;
        }
        return strs;
    }
}

