/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jv.number.PdColor;
import jv.number.PdColor_Dialog;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.GuiStackLayout;

public class PdColor_IP
extends PsPanel
implements TextListener {
    protected PdColor m_color;
    protected int[] m_rgbOld = new int[3];
    protected int[] m_rgbNew = new int[3];
    protected int m_length = 3;
    protected int m_min = 0;
    protected int m_max = 255;
    protected PsPanel m_pColor;
    protected TextField[] m_text;
    private boolean m_bInteractive = true;

    public PdColor_IP() {
        this.setLayout(new GridLayout(1, 2));
        Panel m_pLabel = new Panel();
        m_pLabel.setLayout(new GuiStackLayout(0, 0));
        this.add(m_pLabel);
        this.m_lTitle = new Label();
        m_pLabel.add("WIDE*2", this.m_lTitle);
        this.m_pColor = new PsPanel();
        this.m_pColor.setInsetSize(1);
        this.m_pColor.setLayout(new BorderLayout());
        this.m_pColor.setBorderType(2);
        this.m_pColor.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                PdColor_Dialog dialog = new PdColor_Dialog(PdColor_IP.this.m_color);
                dialog.setParent(PdColor_IP.this.m_color);
                ((Component)dialog).setVisible(true);
            }
            {
                PdColor_IP.this.getClass();
            }
        });
        this.m_pColor.setBackground(Color.red);
        m_pLabel.add("FILL*1", this.m_pColor);
        Panel m_pColor = new Panel();
        m_pColor.setLayout(new GridLayout(1, this.m_length));
        this.add(m_pColor);
        this.m_text = new TextField[this.m_length];
        int i = 0;
        while (i < this.m_length) {
            this.m_text[i] = new TextField("0");
            this.m_text[i].addTextListener(this);
            m_pColor.add(this.m_text[i]);
            ++i;
        }
    }

    public void setParent(PsUpdateIf parent) {
        super.setParent(parent);
        this.m_color = (PdColor)parent;
        this.m_lTitle.setText(this.m_color.getName());
        int i = 0;
        while (i < this.m_length) {
            this.m_rgbOld[0] = this.m_color.getEntry(i);
            ++i;
        }
    }

    public Color getColor() {
        return new Color(this.m_rgbNew[0], this.m_rgbNew[1], this.m_rgbNew[2]);
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_color == null) {
            PsDebug.warning("missing color");
            return true;
        }
        if (object == this.m_color) {
            this.setEnabled(this.m_color.isEnabled());
            this.m_bInteractive = false;
            int i = 0;
            while (i < this.m_length) {
                this.m_rgbNew[i] = this.m_color.getEntry(i);
                ((TextComponent)this.m_text[i]).setText(String.valueOf(this.m_rgbNew[i]));
                ++i;
            }
            this.m_bInteractive = true;
            this.m_pColor.setBackground(this.m_color.getColor());
            this.m_pColor.repaint();
            return true;
        }
        return false;
    }

    public void textValueChanged(TextEvent event) {
        if (!this.m_bInteractive) {
            return;
        }
        PsDebug.notify("entered");
        if (this.m_color == null) {
            PsDebug.warning("no color assigned, return");
            return;
        }
        Object source = event.getSource();
        int i = 0;
        while (i < this.m_length) {
            if (source == this.m_text[i]) {
                PsDebug.notify("text[" + i + "] chosen");
                String text = this.m_text[i].getText();
                if (text == null || text.equals("")) {
                    return;
                }
                try {
                    int val = Integer.parseInt(text);
                    if (val < this.m_min || this.m_max < val) {
                        PsDebug.warning("wrong format");
                        ((TextComponent)this.m_text[i]).setText(String.valueOf(this.m_rgbNew[i]));
                        return;
                    }
                    this.m_rgbNew[i] = val;
                    this.m_color.setEntry(i, this.m_rgbNew[i]);
                    this.m_pColor.setBackground(this.m_color.getColor());
                    this.m_pColor.repaint();
                    PsDebug.notify("setValue=" + this.m_rgbNew[i]);
                    this.m_color.update(null);
                }
                catch (NumberFormatException e) {
                    PsDebug.warning("wrong format = " + text);
                }
                return;
            }
            ++i;
        }
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.m_lTitle.setEnabled(flag);
        this.m_pColor.setEnabled(flag);
        int i = 0;
        while (i < this.m_length) {
            this.m_text[i].setEnabled(flag);
            ++i;
        }
    }
}

